<?php $__env->startSection('title'); ?>
    BTCotton | News
<?php $__env->stopSection(); ?>

<?php $__env->startSection('header'); ?>

    <div class="page-header">
        <h4 class="page-title">Suverance</h4>
        
        <ul class="breadcrumbs">
            <li class="nav-home">
                <a href="#" class="btn btn-icon btn-sm btn-round btn-light">
                    <i class="flaticon-home"></i>
                </a>
            </li>
            <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="#">Organisations</a>
            </li>
            
        </ul>
    </div>
    <div class="ml-md-auto py-2 py-md-0">
     

        <a href="<?php echo e(URL::previous()); ?>" class="btn btn-white btn-round btn-sm ml-1">
            <i class="fas fa-caret-left"></i> Back
        </a>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div id="vueapp">
    <div class="row row-card-no-pd mt--2">
        <div class="col-md-12">
            <div class="card">
                <div class="card-body">
                    <?php echo $__env->make('layouts._messages', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                    
                        <div class="table-responsive">
                            <table id="traders-list" class="display table table-striped table-hover" >
                            <thead>
                                <tr>
                                    <th>ID#</th>
                                    <th>County</th>
                                    <th>Message</th>
                                                   </tr>
                            </thead>
                       
                                <tbody>
                                <?php $__currentLoopData = $news; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $new): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e($new->id); ?></td>
                                    <td><?php echo e($new->traderchart->county_id); ?></td>
                                    <td><?php echo e($new->message); ?></td>
                                   
        
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                            </table>
                        </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Modal -->
    <div class="modal fade" id="crud-modal" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title" id="modal-title"></h4>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form id="trader-form" name="trader-form" method="post">
                    <?php echo csrf_field(); ?>

                    <div class="modal-body">
                    <add-news></add-news>
                    </div>                   
                </form>
            </div>
        </div>
    </div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-url-parser/2.3.1/purl.min.js"></script>
    <script>
    

        $(document).ready(function () {
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });

            $('#traders-list').DataTable({
                responsive: true,
                scrollX: true,
                fixedColumns: true,
                scrollCollapse: true,
            });

            //onload modal
            $('#crud-modal').on('shown.bs.modal', function() {
                $('#trader-organisation_name').trigger('focus');

                $('#trader-type-id').select2({
                    dropdownParent: $('#crud-modal')
                });

                $('#trader-region-id').select2({
                    dropdownParent: $('#crud-modal')
                });

                $('#trader-county-id').select2({
                    dropdownParent: $('#crud-modal')
                });
            });

            // create
            $('body').on('click', '#create-trader', function(e) {
                e.preventDefault();

                $('#modal-save').val("create-trader");
                $('#trader-form').trigger("reset");
                $('#trader-id').val('');
                $('#trader-type-id').val('').trigger('change');
                $('#trader-region-id').val('').trigger('change');
                $('#trader-county-id').val('').trigger('change');
                $('#trader-email').val('');
                $('#trader-phone').val('');
                $('#trader-postal-address').val('');
                $('#trader-account-status').val('');
                $('#trader-admin-user').attr('disabled', false), // enable entire fieldset
                $('#trader-user-firstname').val('');
                $('#trader-user-lastname').val('');
                $('#trader-user-email').val('');
                $('#trader-user-phone').val('');
                $('#trader-user-username').val('');
                $('#trader-user-password').val('');
                $('#trader-user-password-confirm').val('');
                // $('#trader-preferred-regions').val('').trigger('change');
                $('#modal-title').html("Add News Article");
                $('#crud-modal').modal('show');
            });

            // edit
            $('body').on('click', '#edit-trader', function (e) {
                e.preventDefault();

                var trader_id = $(this).data('id');

                $.get('traders/' + trader_id +'/edit-ajax', function (data) {
                    console.log(data);
                    $('#modal-title').html("Edit Organisation");
                    $('#modal-save').val("edit-trader");

                    $('#trader-id').val(data.id);
                    $('#trader-organisation-name').val(data.organisation_name);
                    $('#trader-type-id').val(data.type_id).trigger('change');
                    $('#trader-region-id').val(data.region_id).trigger('change');
                    $('#trader-county-id').val(data.county_id).trigger('change');
                    $('#trader-email').val(data.email);
                    $('#trader-phone').val(data.phone);
                    $('#trader-postal-address').val(data.postal_address);
                    //$('#trader-account-status').val(data.status);
                    // $('#trader-preferred-regions').val(data.preferred_regions).trigger('change');
                    $('#trader-admin-user').attr('disabled', true), // enable entire fieldset
                    $('#trader-user-firstname').val(data.user.firstname);
                    $('#trader-user-lastname').val(data.user.lastname);
                    $('#trader-user-email').val(data.user.email);
                    $('#trader-user-phone').val(data.user.phone);
                    $('#trader-user-username').val(data.user.username);
                    $('#crud-modal').modal('show');
                })
                .fail(function (jqXHR, textStatus, errorThrown) {
                    // console.warn(xhr.responseText)
                    console.log(JSON.stringify(jqXHR));
                    console.log("AJAX error: " + textStatus + ' : ' + errorThrown);
                    $('#modal-save').html('Save');
                })
            });

            // delete
            $('body').on('click', '#delete-trader', function (e) {
                e.preventDefault();

                var trader_id = $(this).data("id");
                var confirmDelete = confirm("Are you sure want to delete?");
                if (confirmDelete) {
                    let table = $('#traders-list').DataTable();

                    $.ajax({
                        type: "DELETE",
                        url: 'traders/' + trader_id + '/delete-ajax',
                        success: function (data) {
                            table.row( $("#trader_id_" + trader_id) ).remove().draw();
                            console.log('Success:', data);
                        },
                        error: function (data) {
                            console.log('Error:', data);
                        }
                    });
                }
            });

            // submit
            if ($("#trader-form").length > 0) {
                $("#trader-form").validate({
                    submitHandler: function(form) {
                        let formData = $('#trader-form').serialize();
                        var actionType = $('#modal-save').val();
                        $('#modal-save').html('Saving...');

                        $.ajax({
                            data: formData,
                            url: '/traders/store-ajax',
                            type: "POST",
                            dataType: 'json',
                            success: function (data) {
                                console.log(data);
                                let fullname = data.user.firstname + ' ' + data.user.lastname;
                                let trader = '<tr id="trader_id_' + data.id + '"><td><a href="'+ data.url +'">' + data.organisation_name + '</a></td>';
                                    trader += '<td>' + data.trader_type.name + '</td><td>' + data.email + '</td><td>' + data.phone + '</td><td>' + data.region.name + '</td><td>' + data.county.name + '</td><td>' + fullname + '</td>';
                                    trader += '<td class="text-right"><div class="btn-group form-actions" role="group" aria-label="Actions">';
                                    trader += '<a id="edit-trader" href="'+ data.url +'/edit" class="btn btn-primary btn-sm" data-toggle="tooltip" title="Edit" data-original-title="Edit" data-id="'+ data.id +'"><i class="fa fa-edit"></i> Edit</a>';
                                    trader += '<button id="delete-trader" type="submit" class="btn btn-danger btn-sm" data-toggle="tooltip" title="Delete" data-original-title="Delete" data-id="'+ data.id +'"><i class="far fa-trash-alt"></i> Delete</button></div></td></tr>';

                                    // $('#add-row').dataTable().fnAddData([
                                    //     $("#addName").val(),
                                    //     $("#addPosition").val(),
                                    //     $("#addOffice").val(),
                                    //     trader
                                    // ]);

                                if (actionType == "create-trader") {
                                    $('#trader-list').prepend(trader);
                                } else {
                                    $("#trader_id_" + data.id).replaceWith(trader);
                                }

                                $('#modal-save').html('Save');
                                $('#crud-modal').modal('hide');
                            },
                            error: function (jqXHR, textStatus, errorThrown) {
                                // console.warn(xhr.responseText)
                                console.log(JSON.stringify(jqXHR));
                                console.log("AJAX error: " + textStatus + ' : ' + errorThrown);
                                $('#modal-save').html('Save');
                            }
                        });
                    }
                });
            }
        });
    </script>

    <script type="text/javascript">
        function hasQueryString() {
            // get the current URL
            var currentUrl = window.location.href;
            // regex pattern for detecting ? character
            var pattern = new RegExp(/\?.+=.*/g);
            return pattern.test(currentUrl);
        }

        $( document ).ready(function() {
            if(hasQueryString()) {
                var urlParams = new URLSearchParams(location.search);
                let exportURL = $('#traders-export').attr('href');
                exportURL += '?' + urlParams.toString();
                $('#traders-export').attr('href', exportURL);

                $('#filter-panel').collapse("show");
                $("#filter-msg").removeClass('d-none');

                $('#filter-name').val(urlParams.get('name'));
                $('#filter-type').val(urlParams.get('type')).trigger('change');
                $('#filter-region').val(urlParams.get('region')).trigger('change');
                $('#filter-county').val(urlParams.get('county')).trigger('change');
            }
        });
    </script>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.site', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/spinmobisky/public_html/btcotton/resources/views/news/surveillance.blade.php ENDPATH**/ ?>