<?php $__env->startSection('title'); ?>
    Twalisha Trading | Produce Collection
<?php $__env->stopSection(); ?>

<?php $__env->startSection('header'); ?>
    <div class="page-header">
        <h4 class="page-title">Produce Collection</h4>
        

        <ul class="breadcrumbs">
            <li class="nav-home">
                <a href="#" class="btn btn-icon btn-sm btn-round btn-light">
                    <i class="flaticon-home"></i>
                </a>
            </li>
            <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="#">Produce Collection</a>
            </li>
            
        </ul>
    </div>
    <div class="ml-md-auto py-2 py-md-0">
        <a id="create-produce-order" href="<?php echo e(route('produce-orders.create')); ?>" class="btn btn-primary btn-round btn-sm">
            <span class="btn-label"><i class="fa fa-plus"></i></span> Add Produce Collection
        </a>

        <a href="<?php echo e(route('dashboard')); ?>" class="btn btn-white btn-border btn-round btn-sm ml-1">
            <span class="btn-label"><i class="fas fa-caret-left"></i></span> Back
        </a>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="row row-card-no-pd mt--2">
        <div class="col-md-12">
            <div class="card">
                <div class="card-body">
                    <?php echo $__env->make('layouts._messages', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                    <?php if($produce_orders->count()): ?>
                        <div class="table-responsive">
                            <table id="produce-orders-list" class="display table table-striped table-hover" >
                                <thead>
                                    <tr>
                                        <th>Order ID</th>
                                        <th>Organisation</th>
                                        <th>No. of Items</th>
                                        <th>Total (KES)</th>
                                        <th>Approved</th>
                                        <th class="text-center" style="width: 10%">Action</th>
                                    </tr>
                                </thead>
                                <tfoot>
                                    <tr>
                                        <th>Order ID</th>
                                        <th>Organisation</th>
                                        <th>No. of Items</th>
                                        <th>Total (KES)</th>
                                        <th>Approved</th>
                                        <th class="text-center">Action</th>
                                    </tr>
                                </tfoot>
                                <tbody id="produce-order-list">
                                    <?php $__currentLoopData = $produce_orders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $produce_order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr id="produce_order_id_<?php echo e($produce_order->id); ?>">
                                            <td><a href="<?php echo e($produce_order->url); ?>"><?php echo e($produce_order->id); ?></a></td>
                                            <td><?php echo e($produce_order->trader->organisation_name); ?></td>
                                            <td><?php echo e($produce_order->produce_order_items_count); ?></td>
                                            <td><?php echo e(number_format(round($produce_order->total, 2))); ?></td>
                                            <td class="text-center">
                                                <?php if($produce_order->approved == 1): ?>
                                                    <i class="fa fa-check"></i>
                                                <?php endif; ?>
                                            </td>
                                            <td>
                                            <?php if(Auth::user()->isAdmin()): ?>
                                                <div class="btn-group form-actions" role="group" aria-label="Actions">
                                                    <a id="edit-produce-order" href="<?php echo e(route('produce-orders.edit', $produce_order->id)); ?>" class="btn btn-primary btn-sm" data-toggle="tooltip" title="Edit" data-original-title="Edit" data-id="<?php echo e($produce_order->id); ?>">
                                                        <i class="fa fa-edit"></i> Edit
                                                    </a>
                                                    <button id="delete-produce-order" type="submit" class="btn btn-danger btn-sm" data-toggle="tooltip" title="Delete" data-original-title="Delete" data-id="<?php echo e($produce_order->id); ?>">
                                                        <i class="far fa-trash-alt"></i> Delete
                                                    </button>
                                                    <?php if(!$produce_order->approved): ?>
                                                        <form id="produce-order-approval-form" class="d-inline" method="post">
                                                            <?php echo csrf_field(); ?>
                                                            <input type="hidden" name="id" value="<?php echo e($produce_order->id); ?>">
                                                            <button type="submit" id="approve-produce-order" class="btn btn-warning btn-sm ml-1" data-toggle="tooltip" title="Approve" data-original-title="Approve" data-id="<?php echo e($produce_order->id); ?>">
                                                                <i class="fas fa-check-double"></i> Approve
                                                            </button>
                                                        </form>
                                                    <?php else: ?>
                                                        <button type="button" class="btn btn-dark btn-sm" title="Deliver" data-original-title="Deliver" data-id=""data-toggle="modal" data-target="#modal-default-<?php echo e($produce_order->id); ?>">
                                                            <i class="fas fa-truck-moving"></i> Deliver
                                                        </button>

                                                    <?php endif; ?>
                                                    <?php else: ?>

                                                        <?php endif; ?>
                                                </div>

                                            </td>
                                        </tr>
                                        <!--Modal Deliver-->
                                        <div class="modal fade" id="modal-default-<?php echo e($produce_order->id); ?>" tabindex="-1" role="dialog" aria-hidden="true">
                                            <div class="modal-dialog" role="document">
                                                <div class="modal-content">
                                                    <div class="modal-header">
                                                        <h4 class="modal-title" id="modal-title">Request Transportation | Order Ref#<?php echo e($produce_order->id); ?> </h4>
                                                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                            <span aria-hidden="true">&times;</span>
                                                        </button>
                                                    </div>
                                                    <form id="input-form" name="input-form" method="post" action="<?php echo e(route('produce-orders.store')); ?>">
                                                        <?php echo csrf_field(); ?>

                                                        <div class="modal-body">
                                                            <input type="hidden" name="_token" id="token" value="<?php echo e(csrf_token()); ?>">
                                                            <input type="hidden" name="approved" value="1">
                                                            <input type="hidden" name="trader_id" value="<?php echo e($produce_order->trader_id); ?>">
                                                            <input type="hidden" name="total" value="<?php echo e($produce_order->price); ?>">
                                                            <div class="form-group align-left">
                                                                <label for="trader-id">Transport Co..</label>
                                                                <select class="form-control" name="transporter_id">
                                                                <option value="">-Select Transporter-</option>
                                                                 <?php $__currentLoopData = $transporters; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $transporter): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                 <option value="<?php echo e($transporter->id); ?>"><?php echo e($transporter->organisation_name); ?></option>
                                                                 <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                                </select>
                                                                <label for="trader-id">Expected Picking Date</label>
                                                                <input type="date" name="picking_time" class="form-control">
                                                                <label for="trader-id">Expected Date of Arrival</label>
                                                                <input type="date" name="delivery_time" class="form-control">
                                                                <input type="hidden" name="produce_order_id" value="<?php echo e($produce_order->id); ?>">
                                                                <input type="hidden" name="status" value="0">
                                                            </div>

                                                        </div>
                                                        <div class="modal-footer">
                                                            <button type="submit" name="transport" id="modal-save" class="btn btn-primary btn-round btn-md"><i class="fa fa-check"></i> Save</button>
                                                            <button type="button" class="btn btn-dark btn-round btn-md" data-dismiss="modal">Close</button>
                                                        </div>
                                                    </form>
                                                </div>
                                            </div>
                                        </div>
                                        <!--/end modal deliver-->

                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>
                    <?php else: ?>
                        <?php echo $__env->make('layouts._nodata', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>

    <!-- Modal -->
    <div class="modal fade" id="produce-order-crud-modal" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title" id="modal-title"></h4>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form id="produce-order-form" name="produce-order-form" method="post">
                    <?php echo csrf_field(); ?>

                    <div class="modal-body">
                        <input type="hidden" name="_token" id="token" value="<?php echo e(csrf_token()); ?>">
                        <input type="hidden" name="id" id="produce-order-id">
                        <?php if(isset($trader)): ?>
                            <input type="hidden" name="trader_id" id="produce-order-trader-id" value="<?php echo e($trader->id); ?>">
                            <div id="repeater">
                                <div id="produce-order-item-repeater-1">
                                    <!-- Repeater Items -->
                                    <div class="row">
                                        <div class="col-md-6 form-group form-floating-label">
                                            <label for="produce-order-item-contract-id" class="control-label">Produce</label>
                                            <input type="hidden" name="produce_order_item[1][price_per_unit]" id="produce-order-item-price" class="produce-order-item-price">
                                            <select id="produce-order-item-contract-id" name="produce_order_item[1][contract_id]" class="form-control produce-order-item-contract-id" style="width: 100%; border-color: #ebedf2;">
                                                <option value="" data-price="" data-units="">- Select -</option>
                                                <?php $__currentLoopData = $trader->contracts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $contract): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <?php $__currentLoopData = $contract->contract_details; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $contract_detail): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <option value="<?php echo e($contract_detail->id); ?>" data-price="<?php echo e($contract->price_per_unit); ?>" data-units="<?php echo e($contract_detail->produce_item->produce_unit->abbreviation); ?>"><?php echo e($contract_detail->produce_item->produce->name . ' @' . $contract->price_per_unit . ' /' . $contract_detail->produce_item->produce_unit->abbreviation); ?></option>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>
                                        </div>
                                        <div class="col-md-6 form-group form-floating-label">
                                            <label for="produce-order-item-quantity">Quantity <span class="quantity-label"></span></label>
                                            <div class="input-group">
                                                <input name="produce_order_item[1][quantity]" type="number" id="produce-order-item-quantity" class="form-control" placeholder="Quantity">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        <?php else: ?>
                            <div class="form-group">
                                <label for="produce-order-trader-id">Organisation</label>
                                <select id="produce-order-trader-id" name="trader_id" class="form-control" style="width: 100%; border-color: #ebedf2;">
                                    <option value="">- Select -</option>
                                    <?php $__currentLoopData = $traders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $trader): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($trader->id); ?>"><?php echo e($trader->organisation_name); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                            <div id="repeater">
                                <div id="produce-order-item-repeater-1">
                                    <!-- Repeater Items -->
                                    <div class="row">
                                        <div class="col-md-6 form-group form-floating-label">
                                            <label for="produce-order-item-contract-id" class="control-label">Produce</label>
                                            <input type="hidden" name="produce_order_item[1][price_per_unit]" id="produce-order-item-price" class="produce-order-item-price">
                                            <select id="produce-order-item-contract-id" name="produce_order_item[1][contract_id]" class="form-control produce-order-item-contract-id" style="width: 100%; border-color: #ebedf2;">
                                                <option value="" data-price="" data-units="">- Select -</option>
                                            </select>
                                        </div>
                                        <div class="col-md-6 form-group form-floating-label">
                                            <label for="produce-order-item-quantity">Quantity <span class="quantity-label"></span></label>
                                            <div class="input-group">
                                                <input name="produce_order_item[1][quantity]" type="number" id="produce-order-item-quantity" class="form-control" placeholder="Quantity">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        <?php endif; ?>

                        <!-- Repeater Add Btn -->
                        <button id="add-produce-order-item" class="btn btn-dark btn-round btn-sm"><i class="fas fa-plus"></i> Add Item</button>
                    </div>
                    <div class="modal-footer">
                        <button type="submit" id="modal-save" class="btn btn-primary btn-round btn-md"><i class="fa fa-check"></i> Save</button>
                        <button type="button" class="btn btn-dark btn-round btn-md" data-dismiss="modal">Close</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
    <script>
        $(document).ready(function () {
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });

            $('#produce-order-crud-modal').on('shown.bs.modal', function() {
                $('#produce-order-trader-id').select2({
                    dropdownParent: $('#produce-order-crud-modal')
                });
            });

            $('body').on("select2:select", "#produce-order-trader-id", function(e) {
                let contract_select = $('.produce-order-item-contract-id');
                contract_select
                    .empty()
                    .append(
                        $('<option />')  // Create new <option> element
                            .text("- Select -") // Set textContent
                            .prop('selected', true)
                    );
                $('.produce-order-item-price').val('');
                $('.quantity-label').text('');

                var selected = e.params.data;
                if(selected.id) {
                    $.ajax({
                        url: '/traders/get-contracts/' + selected.id,
                        dataType: 'json',
                        type: "GET",
                        success: function (data) {
                            //populate #produce-order-item-contract-id
                            $.each(data, function (key, datum) {
                                contract_select
                                    .append($('<option />')  // Create new <option> element
                                    .val(datum.id)            // Set value as "Hello"
                                    .text(datum.produce.name+' @'+datum.price_per_unit+' /'+datum.produce_unit.abbreviation) // Set textContent as "Hello"
                                    .data({                  // Set multiple data-* attributes
                                        price: datum.price_per_unit,
                                        units: datum.produce_unit.name
                                    })
                                );
                            })
                        },
                        error: function (data) {
                            console.log('Error:', data);
                        }
                    });
                }
            });

            $('body').on('click', '#add-produce-order-item', function(e) {
                e.preventDefault();
                klone();
            });

            function klone() {
                var $div = $('div[id^="produce-order-item-repeater-"]:last');
                var num = parseInt( $div.prop("id").match(/\d+/g), 10 ) + 1;
                var $klon = $div.clone(true).prop('id', 'produce-order-item-repeater-' + num );
                $klon.find('input, select').each(function() {
                    this.value= "";
                    let name_number = this.name.match(/\d+/);
                    name_number++;
                    this.name = this.name.replace(/\[[0-9]\]+/, '['+name_number+']')
                });

                // Finally insert $klon after the last div
                // $div.after( $klon );
                $klon.appendTo('#repeater');
            }

            $('body').on("change",".produce-order-item-contract-id", function(e) {
                $(this).closest('.row').find('.produce-order-item-price').val('');
                $(this).closest('.row').find('.quantity-label').text('');

                let price = $(this).find(':selected').data('price');
                let units = $(this).find(':selected').data('units');

                if(price !== undefined) $(this).closest('.row').find('.produce-order-item-price').val(price);
                if(units !== undefined) $(this).closest('.row').find('.quantity-label').text('('+units+')');
            });

            $('#produce-orders-list').DataTable({
                // "pageLength": 5,
            });

            // create
            $('body').on('click', '#create-produce-order', function(e) {
                e.preventDefault();

                $('#modal-save').val("create-produce-order");
                $('#produce-order-form').trigger("reset");
                $('#produce-order-id').val('');
                $('#produce-order-trader-id').val('').trigger('change');
                $('#produce-order-item-contract-id')
                    .empty()
                    .val('')
                    .trigger('change')
                    .append(
                        $('<option />')
                            .text("- Select -")
                            .prop('selected', true)
                    )
                $('#produce-order-item-quantity').val('');
                $('#produce-order-item-price').val('');
                $('#modal-title').html("Add Produce Collection");
                $('#produce-order-crud-modal').modal('show');
            });

            // edit
            $('body').on('click', '#edit-produce-order', function (e) {
                e.preventDefault();
                var produce_order_id = $(this).data('id');

                $.get('/produce-orders/' + produce_order_id +'/edit-ajax', function (data) {
                    console.log(data);
                    $('#modal-title').html("Edit Produce Collection");
                    $('#modal-save').val("edit-produce-order");

                    $('#produce-order-id').val(data.id);
                    $('#produce-order-trader-id').select2();
                    $('#produce-order-trader-id')
                        .val(data.trader_id)
                        .trigger({
                            type: 'select2:select',
                            params: {
                                data: {id: data.trader_id},
                            }
                        });

                    $.each(data.produce_order_items, function (key, datum) {
                        console.log(key, datum);
                    })
                    // $('#produce-order-contract-id').val(data.contract_id).trigger('change');
                    // $('#produce-order-quantity').val(data.quantity);
                    // $('#produce-order-price-per-unit').val(data.price_per_unit);
                    $('#produce-order-crud-modal').modal('show');
                })
                .fail(function (jqXHR, textStatus, errorThrown) {
                    // console.warn(xhr.responseText)
                    console.log(JSON.stringify(jqXHR));
                    console.log("AJAX error: " + textStatus + ' : ' + errorThrown);
                    $('#modal-save').html('Save');
                })
            });

            // delete
            $('body').on('click', '#delete-produce-order', function (e) {
                e.preventDefault();

                var produce_order_id = $(this).data("id");
                var confirmDelete = confirm("Are you sure want to delete?");
                if (confirmDelete) {
                    $.ajax({
                        type: "DELETE",
                        url: '/produce-orders/' + produce_order_id + '/delete-ajax',
                        success: function (data) {
                            $("#produce_order_id_" + produce_order_id).remove();
                            console.log('Success:', data);
                        },
                        error: function (data) {
                            console.log('Error:', data);
                        }
                    });
                }
            });

            // approve
            $('body').on('click', '#approve-produce-order', function (e) {
                e.preventDefault();

                // let formData = $('#produce-order-approval-form').serialize();
                var formData = $(this).closest('form').serialize();
                let produce_order_id = $(this).data('id');

                $.ajax({
                    data: formData,
                    url: '/produce-orders/approve-ajax',
                    type: "POST",
                    dataType: 'json',
                    success: function (data) {
                        console.log(data);

                        let approved = data.approved == 1 ? '<i class="fa fa-check"></i>' : '';

                        var produce_order = '<tr id="produce_order_id_' + data.id + '"><td><a href="'+ data.url +'">' + data.id + '</a></td>';
                            produce_order += '<td>' + data.trader.organisation_name + '</td><td>' + data.produce_order_items_count + '</td><td>' + data.total + '</td><td>' + approved + '</td>';
                            produce_order += '<td><div class="btn-group form-actions" role="group" aria-label="Actions">';
                            produce_order += '<a id="edit-produce-order" href="'+ data.id +'/edit" class="btn btn-primary btn-sm" data-toggle="tooltip" title="Edit" data-original-title="Edit" data-id="'+ data.id +'"><i class="fa fa-edit"></i> Edit</a>';
                            produce_order += '<button id="delete-produce-order" type="submit" class="btn btn-danger btn-sm" data-toggle="tooltip" title="Delete" data-original-title="Delete" data-id="'+ data.id +'"><i class="far fa-trash-alt"></i> Delete</button>';
                            produce_order += '<button type="button" class="btn btn-dark btn-sm" title="Deliver" data-original-title="Deliver" data-id=""data-toggle="modal" data-target="#modal-default-'+ data.id +'"><i class="fas fa-truck-moving"></i> Deliver</button>'
                            produce_order += '</div></td></tr>';

                        $("#produce_order_id_" + data.id).replaceWith(produce_order);
                    },
                    error: function (jqXHR, textStatus, errorThrown) {
                        // console.warn(xhr.responseText)
                        console.log(JSON.stringify(jqXHR));
                        console.log("AJAX error: " + textStatus + ' : ' + errorThrown);
                        $('#modal-save').html('Save');
                    }
                });
            });

            // submit
            if ($("#produce-order-form").length > 0) {
                $("#produce-order-form").validate({
                    submitHandler: function(form) {
                        let formData = $('#produce-order-form').serialize();
                        var actionType = $('#modal-save').val();
                        $('#modal-save').html('Saving...');

                        $.ajax({
                            data: formData,
                            url: '/produce-orders/store-ajax',
                            type: "POST",
                            dataType: 'json',
                            success: function (data) {
                                console.log(data);
                                let approved = data.approved == 1 ? '<i class="fa fa-check"></i>' : '';

                                var produce_order = '<tr id="produce_order_id_' + data.id + '"><td><a href="'+ data.url +'">' + data.id + '</a></td>';
                                    produce_order += '<td>' + data.trader.organisation_name + '</td><td>' + data.produce_order_items_count + '</td><td>' + data.total + '</td><td>' + approved + '</td>';
                                    produce_order += '<td><div class="btn-group form-actions" role="group" aria-label="Actions">';
                                    produce_order += '<a id="edit-produce-order" href="'+ data.id +'/edit" class="btn btn-primary btn-sm" data-toggle="tooltip" title="Edit" data-original-title="Edit" data-id="'+ data.id +'"><i class="fa fa-edit"></i> Edit</a>';
                                    produce_order += '<button id="delete-produce-order" type="submit" class="btn btn-danger btn-sm" data-toggle="tooltip" title="Delete" data-original-title="Delete" data-id="'+ data.id +'"><i class="far fa-trash-alt"></i> Delete</button>';
                                    if(!data.approved) produce_order += '<form id="produce-order-approval-form" class="d-inline" method="post"><input type="hidden" name="_token" id="token" value="<?php echo e(csrf_token()); ?>"><input type="hidden" name="id" value="'+ data.id +'"><button type="submit" id="approve-produce-order" class="btn btn-warning btn-sm ml-1" data-toggle="tooltip" title="Approve" data-original-title="Approve" data-id="'+ data.id +'"><i class="fas fa-check-double"></i> Approve</button></form>';
                                    produce_order += '</div></td></tr>';

                                    // $('#add-row').dataTable().fnAddData([
                                    //     $("#addName").val(),
                                    //     $("#addPosition").val(),
                                    //     $("#addOffice").val(),
                                    //     produce_order
                                    // ]);

                                if (actionType == "create-produce-order") {
                                    $('#produce-order-list').prepend(produce_order);
                                } else {
                                    $("#produce_order_id_" + data.id).replaceWith(produce_order);
                                }

                                $('#modal-save').html('Save');
                                $('#produce-order-crud-modal').modal('hide');
                            },
                            error: function (jqXHR, textStatus, errorThrown) {
                                // console.warn(xhr.responseText)
                                console.log(JSON.stringify(jqXHR));
                                console.log("AJAX error: " + textStatus + ' : ' + errorThrown);
                                $('#modal-save').html('Save');
                            }
                        });
                    }
                });
            }
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make( (Auth::user()->isAdmin()) ? 'layouts.admin' : 'layouts.b', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/mobigrow/public_html/twa-orders/resources/views/produce-orders/index.blade.php ENDPATH**/ ?>