<?php $__env->startSection('title'); ?>
    Twalisha Trading | Organisations
<?php $__env->stopSection(); ?>

<?php $__env->startSection('header'); ?>
    <div class="page-header">
        <h4 class="page-title">Organisations</h4>
        
        <ul class="breadcrumbs">
            <li class="nav-home">
                <a href="#" class="btn btn-icon btn-sm btn-round btn-light">
                    <i class="flaticon-home"></i>
                </a>
            </li>
            <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="#">Organisations</a>
            </li>
            
        </ul>
    </div>
    <div class="ml-md-auto py-2 py-md-0">
        <a id="create-trader" href="<?php echo e(route('traders.create')); ?>" class="btn btn-primary btn-round btn-sm">
            <i class="fa fa-plus"></i> Add Organisation
        </a>

        <a href="<?php echo e(URL::previous()); ?>" class="btn btn-white btn-round btn-sm ml-1">
            <i class="fas fa-caret-left"></i> Back
        </a>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="row row-card-no-pd mt--2">
        <div class="col-md-12">
            <div class="card">
                <div class="card-body">
                    <?php echo $__env->make('layouts._messages', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                    <?php echo $__env->make('_partials.filter-traders', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                    <div class="text-right mb-3 border-bottom pb-3">
                        <a id="traders-export" href="<?php echo e(route('traders.export')); ?>" class="btn btn-primary btn-border btn-round btn-sm">
                            <i class="far fa-file-excel"></i> Export Excel
                        </a>
                        <a class="btn btn-success btn-border btn-round btn-sm" data-toggle="collapse" data-target="#filter-panel">
                            <i class="fas fa-filter"></i> Filter
                        </a>
                    </div>

                    <div id="filter-msg" class="d-none">
                        <div class="alert alert-info shadow-sm mb-0" role="alert">
                            <p class="mb-0"><i class="fas fa-info-circle"></i> This is a filtered view. <span id="filters"></span></p>
                        </div>
                        <hr>
                    </div>

                    <?php if($traders->count()): ?>
                        <div class="table-responsive">
                            <table id="traders-list" class="display table table-striped table-hover" >
                                <thead>
                                    <tr>
                                        <th>Name</th>
                                        <th>Type</th>
                                        <th>Email</th>
                                        <th>Phone</th>
                                        <th>Region</th>
                                        <th>County</th>
                                        <th>Contact Person</th>
                                        <th class="text-right">Action</th>
                                    </tr>
                                </thead>
                                <tfoot>
                                    <tr>
                                        <th>Name</th>
                                        <th>Type</th>
                                        <th>Email</th>
                                        <th>Phone</th>
                                        <th>Region</th>
                                        <th>County</th>
                                        <th>Contact Person</th>
                                        <th class="text-right">Action</th>
                                    </tr>
                                </tfoot>
                                <tbody id="trader-list">
                                    <?php $__currentLoopData = $traders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $trader): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr id="trader_id_<?php echo e($trader->id); ?>">
                                            <td><a href="<?php echo e($trader->url); ?>"><?php echo e($trader->organisation_name); ?></a></td>
                                            <td><?php echo e($trader->trader_type->name); ?></td>
                                            <td><?php echo e($trader->email); ?></td>
                                            <td><?php echo e($trader->phone); ?></td>
                                            <td><?php echo e(isset($trader->region) ? $trader->region->name : ''); ?></td>
                                            <td><?php echo e(isset($trader->county) ? $trader->county->name : ''); ?></td>
                                            <td><?php echo e($trader->user->fullname); ?></td>
                                            <td class="text-right">
                                                <div class="btn-group form-actions" role="group" aria-label="Actions">
                                                    <a id="edit-trader" href="<?php echo e(route('traders.edit', $trader->id)); ?>" class="btn btn-primary btn-sm" data-toggle="tooltip" title="Edit" data-original-title="Edit" data-id="<?php echo e($trader->id); ?>">
                                                        <i class="fa fa-edit"></i> Edit
                                                    </a>
                                                    <button id="delete-trader" type="submit" class="btn btn-danger btn-sm" data-toggle="tooltip" title="Delete" data-original-title="Delete" data-id="<?php echo e($trader->id); ?>">
                                                        <i class="far fa-trash-alt"></i> Delete
                                                    </button>
                                                </div>
                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>
                    <?php else: ?>
                        <?php echo $__env->make('layouts._nodata', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>

    <!-- Modal -->
    <div class="modal fade" id="crud-modal" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title" id="modal-title"></h4>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form id="trader-form" name="trader-form" method="post">
                    <?php echo csrf_field(); ?>

                    <div class="modal-body">
                        <input type="hidden" name="_token" id="token" value="<?php echo e(csrf_token()); ?>">
                        <input type="hidden" name="id" id="trader-id">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-row">
                                    <div class="col form-group">
                                        <label for="trader-organisation-name">Organisation Name*</label>
                                        <input type="text" name="organisation_name" id="trader-organisation-name" value="" class="form-control" placeholder="Organisation Name" autofocus>
                                    </div>
                                </div>
                                <div class="form-row">
                                    <div class="col form-group">
                                        <label for="trader-type-id">Organisation Type*</label>
                                        <select id="trader-type-id" name="type_id" class="form-control" style="width: 100%; border-color: #ebedf2;">
                                            <option value="">- Select -</option>
                                            <?php $__currentLoopData = $trader_types; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $trader_type): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($trader_type->id); ?>"><?php echo e($trader_type->name); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>
                                </div>
                                <div class="form-row">
                                    <div class="col form-group">
                                        <label for="trader-region-id">Region*</label><br>
                                        <select name="region_id" id="trader-region-id" class="form-control">
                                            <option value="">- Select -</option>
                                            <?php $__currentLoopData = $regions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $region): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($region->id); ?>"><?php echo e($region->name); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>
                                </div>
                                <div class="form-row">
                                    <div class="col form-group">
                                        <label for="trader-county-id">County*</label><br>
                                        <select name="county_id" id="trader-county-id" class="form-control">
                                            <option value="">- Select -</option>
                                            <?php $__currentLoopData = $counties; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $county): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($county->id); ?>"><?php echo e($county->name); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>
                                    <div class="col form-group">
                                        <label for="trader-ward">Ward</label><br>
                                        <input type="text" name="ward" id="trader-ward" class="form-control" placeholder="Ward">
                                    </div>
                                </div>
                                
                                <div class="form-row">
                                    <div class="col form-group">
                                        <label for="trader-email">Email*</label>
                                        <input name="email" id="trader-email" type="email" class="form-control" placeholder="Email">
                                    </div>

                                    <div class="col form-group">
                                        <label for="trader-phone">Phone Number</label>
                                        <input name="phone" id="trader-phone" type="text" class="form-control" placeholder="Phone Number">
                                    </div>
                                </div>
                                <div class="form-row">
                                    <div class="col form-group">
                                        <label for="trader-postal-address">Postal Address</label>
                                        <textarea name="postal_address" id="trader-postal-address" class="form-control" placeholder="Postal Address"></textarea>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                
                                <fieldset id="trader-admin-user">
                                    <legend>Admin Account</legend>

                                    <div class="panel panel-default">
                                        <div class="form-row">
                                            <div class="col form-group">
                                                <label for="trader-user-firstname">First Name*</label>
                                                <input name="user_firstname" id="trader-user-firstname" type="text" class="form-control" placeholder="First Name">
                                            </div> <!-- form-group end.// -->
                                            <div class="col form-group">
                                                <label for="trader-user-lastname">Last Name*</label>
                                                <input name="user_lastname" id="trader-user-lastname" type="text" class="form-control" placeholder="Last Name">
                                            </div> <!-- form-group end.// -->
                                        </div>
                                        <div class="form-row">
                                            <div class="col form-group">
                                                <label for="trader-user-email">Email*</label>
                                                <input name="user_email" id="trader-user-email" type="text" class="form-control" placeholder="Email">
                                            </div> <!-- form-group end.// -->

                                            <div class="col form-group">
                                                <label for="trader-user-phone">Phone Number*</label>
                                                <input name="user_phone" id="trader-user-phone" type="text" class="form-control" placeholder="Phone Number">
                                            </div> <!-- form-group end.// -->
                                        </div>
                                        <hr>
                                        <div class="form-row">
                                            <div class="col form-group">
                                                <label for="trader-user-username">Username*</label>
                                                <input name="user_username" id="trader-user-username" type="text" class="form-control" placeholder="Username">
                                            </div>
                                        </div>
                                        <div class="form-row">
                                            <div class="col form-group">
                                                <label for="trader-user-password">Password*</label>
                                                <input name="user_password" id="trader-user-password" type="password" class="form-control" placeholder="Password">
                                            </div>
                                            <div class="col form-group">
                                                <label for="trader-user-password-confirm">Confirm Password*</label>
                                                <input name="user_password_confirm" id="trader-user-password-confirm" type="password" class="form-control"  placeholder="Confirm Password">
                                            </div>
                                        </div>
                                    </div>
                                </fieldset>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="submit" id="modal-save" class="btn btn-primary btn-round btn-md"><i class="fa fa-check"></i> Save</button>
                        <button type="button" class="btn btn-dark btn-round btn-md" data-dismiss="modal">Close</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <!-- Modal -->
    
    <!--end of contract modal -->

    <!-- Activate Modal -->
    

    <!-- Deactivate Modal -->
    
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-url-parser/2.3.1/purl.min.js"></script>
    <script>
        // $(document).ready(function() {

        //     // $(document).on("click", "#activateTrader", function () {
        //     //     var ids = $(this).data('id');
        //     //     $("#activateModal #activate-trader_id").val(ids);
        //     // });

        //     // $(document).on("click", "#deactivateTrader", function () {
        //     //     var ids = $(this).data('id');
        //     //     $("#deactivateModal #deactivate-trader_id").val(ids);
        //     // });

        //     // //get the modal values on the contract
        //     // $(".editContractMethod").click(function() {
        //     //     var trader_id = $(this).data('trader-id');
        //     //     $("div#contract_fields input[name=trader-id]").val(id);
        //     // });

        // });

        $(document).ready(function () {
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });

            $('#traders-list').DataTable({
                responsive: true,
                scrollX: true,
                fixedColumns: true,
                scrollCollapse: true,
            });

            //onload modal
            $('#crud-modal').on('shown.bs.modal', function() {
                $('#trader-organisation_name').trigger('focus');

                $('#trader-type-id').select2({
                    dropdownParent: $('#crud-modal')
                });

                $('#trader-region-id').select2({
                    dropdownParent: $('#crud-modal')
                });

                $('#trader-county-id').select2({
                    dropdownParent: $('#crud-modal')
                });
            });

            // create
            $('body').on('click', '#create-trader', function(e) {
                e.preventDefault();

                $('#modal-save').val("create-trader");
                $('#trader-form').trigger("reset");
                $('#trader-id').val('');
                $('#trader-type-id').val('').trigger('change');
                $('#trader-region-id').val('').trigger('change');
                $('#trader-county-id').val('').trigger('change');
                $('#trader-email').val('');
                $('#trader-phone').val('');
                $('#trader-postal-address').val('');
                $('#trader-admin-user').attr('disabled', false), // enable entire fieldset
                $('#trader-user-firstname').val('');
                $('#trader-user-lastname').val('');
                $('#trader-user-email').val('');
                $('#trader-user-phone').val('');
                $('#trader-user-username').val('');
                $('#trader-user-password').val('');
                $('#trader-user-password-confirm').val('');
                // $('#trader-preferred-regions').val('').trigger('change');
                $('#modal-title').html("Add Organisation");
                $('#crud-modal').modal('show');
            });

            // edit
            $('body').on('click', '#edit-trader', function (e) {
                e.preventDefault();

                var trader_id = $(this).data('id');

                $.get('traders/' + trader_id +'/edit-ajax', function (data) {
                    console.log(data);
                    $('#modal-title').html("Edit Organisation");
                    $('#modal-save').val("edit-trader");

                    $('#trader-id').val(data.id);
                    $('#trader-organisation-name').val(data.organisation_name);
                    $('#trader-type-id').val(data.type_id).trigger('change');
                    $('#trader-region-id').val(data.region_id).trigger('change');
                    $('#trader-county-id').val(data.county_id).trigger('change');
                    $('#trader-email').val(data.email);
                    $('#trader-phone').val(data.phone);
                    $('#trader-postal-address').val(data.postal_address);
                    // $('#trader-preferred-regions').val(data.preferred_regions).trigger('change');
                    $('#trader-admin-user').attr('disabled', true), // enable entire fieldset
                    $('#trader-user-firstname').val(data.user.firstname);
                    $('#trader-user-lastname').val(data.user.lastname);
                    $('#trader-user-email').val(data.user.email);
                    $('#trader-user-phone').val(data.user.phone);
                    $('#trader-user-username').val(data.user.username);
                    $('#crud-modal').modal('show');
                })
                .fail(function (jqXHR, textStatus, errorThrown) {
                    // console.warn(xhr.responseText)
                    console.log(JSON.stringify(jqXHR));
                    console.log("AJAX error: " + textStatus + ' : ' + errorThrown);
                    $('#modal-save').html('Save');
                })
            });

            // delete
            $('body').on('click', '#delete-trader', function (e) {
                e.preventDefault();

                var trader_id = $(this).data("id");
                var confirmDelete = confirm("Are you sure want to delete?");
                if (confirmDelete) {
                    let table = $('#traders-list').DataTable();

                    $.ajax({
                        type: "DELETE",
                        url: 'traders/' + trader_id + '/delete-ajax',
                        success: function (data) {
                            table.row( $("#trader_id_" + trader_id) ).remove().draw();
                            console.log('Success:', data);
                        },
                        error: function (data) {
                            console.log('Error:', data);
                        }
                    });
                }
            });

            // submit
            if ($("#trader-form").length > 0) {
                $("#trader-form").validate({
                    submitHandler: function(form) {
                        let formData = $('#trader-form').serialize();
                        var actionType = $('#modal-save').val();
                        $('#modal-save').html('Saving...');

                        $.ajax({
                            data: formData,
                            url: '/traders/store-ajax',
                            type: "POST",
                            dataType: 'json',
                            success: function (data) {
                                console.log(data);
                                let fullname = data.user.firstname + ' ' + data.user.lastname;
                                let trader = '<tr id="trader_id_' + data.id + '"><td><a href="'+ data.url +'">' + data.organisation_name + '</a></td>';
                                    trader += '<td>' + data.trader_type.name + '</td><td>' + data.email + '</td><td>' + data.phone + '</td><td>' + data.region.name + '</td><td>' + data.county.name + '</td><td>' + fullname + '</td>';
                                    trader += '<td class="text-right"><div class="btn-group form-actions" role="group" aria-label="Actions">';
                                    trader += '<a id="edit-trader" href="'+ data.url +'/edit" class="btn btn-primary btn-sm" data-toggle="tooltip" title="Edit" data-original-title="Edit" data-id="'+ data.id +'"><i class="fa fa-edit"></i> Edit</a>';
                                    trader += '<button id="delete-trader" type="submit" class="btn btn-danger btn-sm" data-toggle="tooltip" title="Delete" data-original-title="Delete" data-id="'+ data.id +'"><i class="far fa-trash-alt"></i> Delete</button></div></td></tr>';

                                    // $('#add-row').dataTable().fnAddData([
                                    //     $("#addName").val(),
                                    //     $("#addPosition").val(),
                                    //     $("#addOffice").val(),
                                    //     trader
                                    // ]);

                                if (actionType == "create-trader") {
                                    $('#trader-list').prepend(trader);
                                } else {
                                    $("#trader_id_" + data.id).replaceWith(trader);
                                }

                                $('#modal-save').html('Save');
                                $('#crud-modal').modal('hide');
                            },
                            error: function (jqXHR, textStatus, errorThrown) {
                                // console.warn(xhr.responseText)
                                console.log(JSON.stringify(jqXHR));
                                console.log("AJAX error: " + textStatus + ' : ' + errorThrown);
                                $('#modal-save').html('Save');
                            }
                        });
                    }
                });
            }
        });
    </script>

    <script type="text/javascript">
        function hasQueryString() {
            // get the current URL
            var currentUrl = window.location.href;
            // regex pattern for detecting ? character
            var pattern = new RegExp(/\?.+=.*/g);
            return pattern.test(currentUrl);
        }

        $( document ).ready(function() {
            if(hasQueryString()) {
                var urlParams = new URLSearchParams(location.search);
                let exportURL = $('#traders-export').attr('href');
                exportURL += '?' + urlParams.toString();
                $('#traders-export').attr('href', exportURL);

                $('#filter-panel').collapse("show");
                $("#filter-msg").removeClass('d-none');

                $('#filter-name').val(urlParams.get('name'));
                $('#filter-type').val(urlParams.get('type')).trigger('change');
                $('#filter-region').val(urlParams.get('region')).trigger('change');
                $('#filter-county').val(urlParams.get('county')).trigger('change');
            }
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.site', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/mobigrow/public_html/twalisha.com/trading/public/resources/views/traders/index.blade.php ENDPATH**/ ?>