<?php $__env->startSection('title'); ?>
BTCotton | Input Orders
<?php $__env->stopSection(); ?>

<?php $__env->startSection('header'); ?>
    <div class="page-header">
        <h4 class="page-title"><?php if(Auth::user()->isTraderAdmin() && Auth::user()->getRelatedTrader()->isAgroDealer()): ?>
        Agrodealer
                                                    <?php else: ?>
                                                    Input Seller <?php endif; ?> | Input Orders</h4>
        
        <ul class="breadcrumbs">
            <li class="nav-home">
                <a href="#" class="btn btn-icon btn-sm btn-round btn-light">
                    <i class="flaticon-home"></i>
                </a>
            </li>
            <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
                                        <th class="text-right" style="width: 10%">Action</th>
                                    </tr>
                                </thead>
                                <tfoot>
                                    <tr>
            <li class="nav-item">
                <a href="#">Input orders</a>
            </li>
            
        </ul>

    </div>
    <div class="ml-md-auto py-2 py-md-0">
         <a href="<?php echo e(URL::previous()); ?>" class="btn btn-white btn-round btn-sm ml-1">
            <i class="fas fa-caret-left"></i> Back
        </a>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="row row-card-no-pd mt--2">
        <div class="col-md-12">
            <div class="card">
                <div class="card-body">
                    <?php echo $__env->make('layouts._messages', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                    <?php if($inputs->count()): ?>
                        <div class="table-responsive">
                            <table id="inputs-list" class="display table table-striped table-hover" >

                                <thead>
                                    <tr>
                                        <th>ID</th>
                                        <th>Farmer Organization</th>
                                        <th>Total Items</th>
                                        <th>Status</th>
                                        <th>Created On</th>
                                        <th class="text-right" style="width: 10%">Action</th>
                                    </tr>
                                </thead>
                                <tbody id="input-list">
                                <?php $__currentLoopData = $inputs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $input): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr id="<?php echo e($input->id); ?>">
                                            <td><a href="<?php echo e(route('bulk-seller.show', $input->id)); ?>"><?php echo e($input->id); ?></a></td>
                                            <td><?php echo e($input->trader->organisation_name); ?></td>
                                            <td><?php echo e($input->orderItems->count('quantity')); ?></td>
                                            <td>

                                             <?php
                                             $uid = Auth::user()->id;
                                             $trader = App\Trader::where('user_id',$uid)->pluck('id');
                                             $pending = App\inputOrderItems::where('order_id',$input->id)->where('directed_to',$trader[0])->where('approved',1)->get();
                                             $completed = App\inputOrderItems::where('order_id',$input->id)->where('directed_to',$trader[0])->where('approved',2)->get();
                                             $delivered = App\inputOrderItems::where('order_id',$input->id)->where('directed_to',$trader[0])->where('approved',3)->get();
                                             $received = App\inputOrderItems::where('order_id',$input->id)->where('directed_to',$trader[0])->where('approved',4)->get();

                                                if(count($pending))
                                                 {
                                                     echo '<span class="badge badge-danger">' .count($pending) ." - Pending".'</span><br>';
                                                 }
                                                 if(count($completed))
                                                 {
                                                    echo '<span class="badge badge-success">' .count($completed) ." - Completed".'</span><br>';
                                                 }
                                                 if(count($delivered))
                                                 {
                                                     echo '<span class="badge badge-success">' .count($delivered) ." - Delivered".'</span><br>';
                                                 }
                                                 if(count($received))
                                                 {
                                                     echo '<span class="badge badge-success">' .count($received) ." - Received".'</span><br>';
                                                 }

                                             ?>
                                            </td>
                                            <td><?php echo e(Str::limit($input->created_at,10,'.')); ?></td>
                                            <td class="text-right">
                                            <form action="<?php echo e(route('bulk-seller.update', $input->id)); ?>" method="post">
                                                <?php echo csrf_field(); ?>
                                                <?php echo method_field('PUT'); ?>
                                                <div class="btn-group form-actions" role="group" aria-label="Actions">
                                                <input type="hidden" name="id" value="<?php echo e($input->id); ?>">

                                                <input type="hidden" name="approved" value="2">
                                                <a href="<?php echo e(route('bulk-seller.show', $input->id)); ?>">
                                                <button type="button" class="btn btn-success btn-sm" data-toggle="tooltip" title="View Items" data-original-title="View Items" data-id="">
                                                        <i class="fa fa-edit"></i> View Items
                                                    </button>
                                                    </a>
                                                    <?php if((count($pending) == 0) && (count($completed)>0)): ?>
                                                    <?php if(Auth::user()->isTraderAdmin() && Auth::user()->getRelatedTrader()->isBulkSeller()): ?>

                                                <button type="button" name="deliver" class="btn btn-primary btn-sm" title="Deliver" data-original-title="Deliver" data-id=""data-toggle="modal" data-target="#modal-default-<?php echo e($input->id); ?>">
                                                        <i class="fa fa-edit"></i> Deliver
                                                    </button>
                                                    <?php endif; ?>
                                                    <?php endif; ?>
                                                    <?php if(count($completed)): ?>
                                                    <?php if(Auth::user()->isTraderAdmin() && Auth::user()->getRelatedTrader()->isAgroDealer()): ?>
                                                    <button type="submit" name="approveorder" class="btn btn-primary btn-sm" data-toggle="tooltip" title="Approve" data-original-title="Approve" data-id="">
                                                        <i class="fa fa-edit"></i> Complete
                                                    </button>
                                                    <button type="button" name="deliver" class="btn btn-primary btn-sm" title="Deliver" data-original-title="Deliver" data-id=""data-toggle="modal" data-target="#modal-default-<?php echo e($input->id); ?>">
                                                        <i class="fa fa-edit"></i> Deliver
                                                    </button>
                                                    <?php endif; ?>
                                                    <?php endif; ?>
                                                </form>
                                                <?php if($input->approved == 0): ?>
                                                <form action="<?php echo e(route('bulk-seller.destroy', $input->id)); ?>" method="post">
                                                <?php echo csrf_field(); ?>
                                                <?php echo method_field('DELETE'); ?>
                                                    <button id="delete-input" name="deleteorder" type="submit" class="btn btn-danger btn-sm" data-toggle="tooltip" title="Delete" data-original-title="Delete" data-id="">
                                                        <i class="far fa-trash-alt"></i> Cancel
                                                    </button>
                                                </form>
                                                <?php endif; ?>
                                    <!-- Modal -->
                                    <div class="modal fade" id="modal-default-<?php echo e($input->id); ?>" tabindex="-1" role="dialog" aria-hidden="true">
                                            <div class="modal-dialog" role="document">
                                                <div class="modal-content">
                                                    <div class="modal-header">
                                                        <h4 class="modal-title" id="modal-title">Add Delivery Information | Item Ref#<?php echo e($input->id); ?> </h4>
                                                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                            <span aria-hidden="true">&times;</span>
                                                        </button>
                                                    </div>
                                                    <form id="input-form" name="input-form" method="post" action="<?php echo e(route('bulk-seller.store')); ?>">
                                                        <?php echo csrf_field(); ?>

                                                        <div class="modal-body">
                                                            <input type="hidden" name="_token" id="token" value="<?php echo e(csrf_token()); ?>">
                                                            <input type="hidden" name="approved" value="1">
                                                            <input type="hidden" name="id" value="<?php echo e($input->id); ?>">
                                                            <input type="hidden" name="trader_id" value="<?php echo e($input->trader_id); ?>">
                                                            <input type="hidden" name="total" value="<?php echo e($input->price); ?>">
                                                            <div class="form-group align-left">
                                                                <label for="trader-id">Delivered/Picked By</label>
                                                                <input type="text" name="recipient" class="form-control">
                                                                <label for="trader-id">Means of Delivery</label>
                                                                <input type="text" name="means" class="form-control">
                                                                <label for="trader-id">Date Picked/Delivered</label>
                                                                <input type="date" name="date" class="form-control">
                                                                <input type="hidden" name="order_id" value="<?php echo e($input->id); ?>">
                                                            </div>

                                                        </div>
                                                        <div class="modal-footer">
                                                            <button type="submit" id="modal-save" class="btn btn-primary btn-round btn-md"><i class="fa fa-check"></i> Save</button>
                                                            <button type="button" class="btn btn-dark btn-round btn-md" data-dismiss="modal">Close</button>
                                                        </div>
                                                    </form>
                                                </div>
                                            </div>
                                        </div>
                                    </tr>

                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                                <tfoot>
                                    <tr>
                                        <th>ID</th>
                                        <th>Farmer Organization</th>
                                        <th>Total Items</th>
                                        <th>Status</th>
                                        <th>Created On</th>
                                        <th class="text-right" style="width: 10%">Action</th>
                                    </tr>
                                </tfoot>
                            </table>
                        </div>
                    <?php else: ?>
                        <?php echo $__env->make('layouts._nodata', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    <?php endif; ?>
                </div>
            </div>


        </div>
    </div>


<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>
<script>
$(document).ready(function () {
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });

            $('#inputs-list').DataTable({
                "order": [[ 0, "desc" ]]
            });
        });
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.site', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/spinmobisky/public_html/btcotton/resources/views/bulk-seller/index.blade.php ENDPATH**/ ?>