<?php $__env->startSection('title'); ?>
BTCotton | Update Profile - <?php echo e($user->fullname); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('header'); ?>
    <div class="page-header">
        <h4 class="page-title">Update Profile - <?php echo e($user->fullname); ?></h4>
        
        <ul class="breadcrumbs">
            <li class="nav-home">
                <a href="#" class="btn btn-icon btn-sm btn-round btn-light">
                    <i class="flaticon-home"></i>
                </a>
            </li>
            <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="<?php echo e(route('users.index')); ?>">Users</a>
            </li>
            
        </ul>

    </div>
    <div class="ml-md-auto py-2 py-md-0">
        <a href="<?php echo e(URL::previous()); ?>" class="btn btn-white btn-round btn-sm ml-1">
            <i class="fas fa-caret-left"></i> Back
        </a>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-body">
                    <?php echo $__env->make('layouts._messages', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                    <form action="<?php echo e(route('update-profile', $user->id)); ?>" method="post">
                        <?php echo csrf_field(); ?>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-row">
                                    <div class="col form-group">
                                        <label for="user-firstname">First Name*</label>
                                        <input name="firstname" id="user-firstname" type="text" class="form-control <?php echo e($errors->has('firstname') ? 'is-invalid' : ''); ?>" placeholder="First Name" value="<?php echo e(old('firstname', $user->firstname ?? '')); ?>">

                                        <?php if($errors->has('firstname')): ?>
                                            <div class="invalid-feedback">
                                                <strong><?php echo e($errors->first('firstname')); ?></strong>
                                            </div>
                                        <?php endif; ?>
                                    </div> <!-- form-group end.// -->
                                    <div class="col form-group">
                                        <label for="user-middlename">Middle Name</label>
                                        <input name="middlename" id="user-middlename" type="text" class="form-control <?php echo e($errors->has('middlename') ? 'is-invalid' : ''); ?>" placeholder="Middle Name" value="<?php echo e(old('middlename', $user->farmer_profile->middlename ?? '')); ?>">

                                        <?php if($errors->has('middlename')): ?>
                                            <div class="invalid-feedback">
                                                <strong><?php echo e($errors->first('middlename')); ?></strong>
                                            </div>
                                        <?php endif; ?>
                                    </div> <!-- form-group end.// -->
                                    <div class="col form-group">
                                        <label for="user-lastname">Last Name*</label>
                                        <input name="lastname" id="user-lastname" type="text" class="form-control <?php echo e($errors->has('lastname') ? 'is-invalid' : ''); ?>" placeholder="Last Name" value="<?php echo e(old('lastname', $user->lastname ?? '')); ?>">

                                        <?php if($errors->has('lastname')): ?>
                                            <div class="invalid-feedback">
                                                <strong><?php echo e($errors->first('lastname')); ?></strong>
                                            </div>
                                        <?php endif; ?>
                                    </div> <!-- form-group end.// -->
                                </div>
                                <div class="form-row">
                                    <div class="col form-group">
                                        <label for="user-email">Email*</label>
                                        <input name="email" id="user-email" type="text" class="form-control <?php echo e($errors->has('email') ? 'is-invalid' : ''); ?>" placeholder="Email" value="<?php echo e(old('email', $user->email ?? '')); ?>">

                                        <?php if($errors->has('email')): ?>
                                            <div class="invalid-feedback">
                                                <strong><?php echo e($errors->first('email')); ?></strong>
                                            </div>
                                        <?php endif; ?>
                                    </div> <!-- form-group end.// -->
                                </div>
                                <div class="form-row">
                                    <div class="col form-group">
                                        <label for="user-phone">Phone Number*</label>
                                        <input name="phone" id="user-phone" type="text" class="form-control <?php echo e($errors->has('phone') ? 'is-invalid' : ''); ?>" placeholder="Phone Number" value="<?php echo e(old('phone', $user->phone ?? '')); ?>">

                                        <?php if($errors->has('phone')): ?>
                                            <div class="invalid-feedback">
                                                <strong><?php echo e($errors->first('phone')); ?></strong>
                                            </div>
                                        <?php endif; ?>
                                    </div> <!-- form-group end.// -->
                                    <div class="col form-group">
                                        <label for="user-mpesa-number">M-Pesa Number</label>
                                        <input name="mpesa_number" id="user-mpesa-number" type="text" class="form-control <?php echo e($errors->has('mpesa_number') ? 'is-invalid' : ''); ?>" placeholder="M-Pesa Number" value="<?php echo e(old('mpesa_number', $user->farmer_profile->mpesa_number ?? '')); ?>">

                                        <?php if($errors->has('mpesa_number')): ?>
                                            <div class="invalid-feedback">
                                                <strong><?php echo e($errors->first('mpesa_number')); ?></strong>
                                            </div>
                                        <?php endif; ?>
                                    </div> <!-- form-group end.// -->
                                </div>
                                <div class="form-row">
                                    <div class="col form-group">
                                        <label for="user-address">Address</label>
                                        <textarea name="address" id="user-address" class="form-control <?php echo e($errors->has('address') ? 'is-invalid' : ''); ?>" placeholder="Address"><?php echo e(old('address', $user->address ?? '')); ?></textarea>
                                        <?php if($errors->has('address')): ?>
                                            <div class="invalid-feedback">
                                                <strong><?php echo e($errors->first('address')); ?></strong>
                                            </div>
                                        <?php endif; ?>
                                    </div> <!-- form-group end.// -->
                                </div>
                                <div class="form-row">
                                    <div class="col form-group">
                                        <label for="user-national-id">National ID</label>
                                        <input name="national_id" id="user-national-id" type="text" class="form-control <?php echo e($errors->has('national_id') ? 'is-invalid' : ''); ?>" placeholder="National ID" value="<?php echo e(old('national_id', $user->farmer_profile->national_id ?? '')); ?>">

                                        <?php if($errors->has('national_id')): ?>
                                            <div class="invalid-feedback">
                                                <strong><?php echo e($errors->first('national_id')); ?></strong>
                                            </div>
                                        <?php endif; ?>
                                    </div> <!-- form-group end.// -->
                                </div>
                                <div class="form-row">
                                    <div class="col form-group">
                                        <label for="user-education-level">Education Level</label>
                                        <select id="user-education-level" name="education_level" class="form-control" style="width: 100%; border-color: #ebedf2;">
                                            <option value="">- Select -</option>
                                            <option value="Primary Level" <?php echo e(old('education_level', $user->farmer_profile->education_level ?? '') == 'Primary Level' ? 'selected="selected"' : ''); ?>>Primary Level</option>
                                            <option value="Secondary Level" <?php echo e(old('education_level', $user->farmer_profile->education_level ?? '') == 'Secondary Level' ? 'selected="selected"' : ''); ?>>Secondary Level</option>
                                            <option value="Bachelors Degree" <?php echo e(old('education_level', $user->farmer_profile->education_level ?? '') == 'Bachelors Degree' ? 'selected="selected"' : ''); ?>>Bachelors Degree</option>
                                            <option value="Masters Degree" <?php echo e(old('education_level', $user->farmer_profile->education_level ?? '') == 'Masters Degree' ? 'selected="selected"' : ''); ?>>Masters Degree</option>
                                            <option value="Doctorate" <?php echo e(old('education_level', $user->farmer_profile->education_level ?? '') == 'Doctorate' ? 'selected="selected"' : ''); ?>>Doctorate</option>
                                        </select>

                                        <?php if($errors->has('education_level')): ?>
                                            <div class="invalid-feedback">
                                                <strong><?php echo e($errors->first('education_level')); ?></strong>
                                            </div>
                                        <?php endif; ?>
                                    </div> <!-- form-group end.// -->
                                </div>
                                <div class="form-row">
                                    <div class="col form-group">
                                        <label for="user-acreage">Acreage</label>
                                        <input name="acreage" id="user-acreage" type="text" class="form-control <?php echo e($errors->has('acreage') ? 'is-invalid' : ''); ?>" placeholder="Acreage" value="<?php echo e(old('acreage', $user->farmer_profile->acreage ?? '')); ?>">

                                        <?php if($errors->has('acreage')): ?>
                                            <div class="invalid-feedback">
                                                <strong><?php echo e($errors->first('acreage')); ?></strong>
                                            </div>
                                        <?php endif; ?>
                                    </div> <!-- form-group end.// -->
                                    <div class="col form-group">
                                        <label for="user-acreage-farmed">Acreage Farmed</label>
                                        <input name="acreage_farmed" id="user-acreage-farmed" type="text" class="form-control <?php echo e($errors->has('acreage_farmed') ? 'is-invalid' : ''); ?>" placeholder="Acreage Farmed" value="<?php echo e(old('acreage_farmed', $user->farmer_profile->acreage_farmed ?? '')); ?>">

                                        <?php if($errors->has('acreage_farmed')): ?>
                                            <div class="invalid-feedback">
                                                <strong><?php echo e($errors->first('acreage_farmed')); ?></strong>
                                            </div>
                                        <?php endif; ?>
                                    </div> <!-- form-group end.// -->
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-row">
                                    <div class="col form-group">
                                        <label for="user-input-spending">Input Spending
                                            <br><span class="small">Estimated spending per season in KSh</span>
                                        </label>
                                        <input name="input_spending" id="user-input-spending" type="number" class="form-control <?php echo e($errors->has('input_spending') ? 'is-invalid' : ''); ?>" placeholder="Input Spending" value="<?php echo e(old('input_spending', $user->farmer_profile->input_spending ?? '')); ?>">

                                        <?php if($errors->has('input_spending')): ?>
                                            <div class="invalid-feedback">
                                                <strong><?php echo e($errors->first('input_spending')); ?></strong>
                                            </div>
                                        <?php endif; ?>
                                    </div> <!-- form-group end.// -->
                                </div>
                                <div class="form-row">
                                    <div class="col form-group">
                                        <label for="user-preferred-learning-language">Preferred Learning Language</label>
                                        <input name="preferred_learning_language" id="user-preferred-learning-language" type="text" class="form-control <?php echo e($errors->has('preferred_learning_language') ? 'is-invalid' : ''); ?>" placeholder="Preferred Learning Language" value="<?php echo e(old('preferred_learning_language', $user->farmer_profile->preferred_learning_language ?? '')); ?>">

                                        <?php if($errors->has('preferred_learning_language')): ?>
                                            <div class="invalid-feedback">
                                                <strong><?php echo e($errors->first('preferred_learning_language')); ?></strong>
                                            </div>
                                        <?php endif; ?>
                                    </div> <!-- form-group end.// -->
                                </div>
                                <div class="form-row">
                                    <div class="col form-group">
                                        <label for="user-preferred-agrodealer">Preferred Agrodealer</label>
                                        <input name="preferred_agrodealer" id="user-preferred-agrodealer" type="text" class="form-control <?php echo e($errors->has('preferred_agrodealer') ? 'is-invalid' : ''); ?>" placeholder="Preferred Agrodealer" value="<?php echo e(old('preferred_agrodealer', $user->farmer_profile->preferred_agrodealer ?? '')); ?>">

                                        <?php if($errors->has('preferred_agrodealer')): ?>
                                            <div class="invalid-feedback">
                                                <strong><?php echo e($errors->first('preferred_agrodealer')); ?></strong>
                                            </div>
                                        <?php endif; ?>
                                    </div> <!-- form-group end.// -->
                                </div>
                                <div class="form-row">
                                    <div class="col form-group">
                                        <label for="user-computer-access">Computer Access
                                            <br><span class="small">Do you have access to a computer?</span>
                                        </label>
                                        <select id="user-computer-access" name="computer_access" class="form-control" style="width: 100%; border-color: #ebedf2;">
                                            <option value="">- Select -</option>
                                            <option value="0" <?php echo e(old('computer_access', $user->farmer_profile->computer_access ?? '') == '0' ? 'selected="selected"' : ''); ?>>No</option>
                                            <option value="1" <?php echo e(old('computer_access', $user->farmer_profile->computer_access ?? '') == '1' ? 'selected="selected"' : ''); ?>>Yes</option>
                                        </select>

                                        <?php if($errors->has('computer_access')): ?>
                                            <div class="invalid-feedback">
                                                <strong><?php echo e($errors->first('computer_access')); ?></strong>
                                            </div>
                                        <?php endif; ?>
                                    </div> <!-- form-group end.// -->
                                    <div class="col form-group">
                                        <label for="user-computer-access-location">Computer Location
                                            <br><small>Where do you access your computer from?</small>
                                        </label>
                                        <select id="user-computer-access-location" name="computer_access_location" class="form-control" style="width: 100%; border-color: #ebedf2;">
                                            <option value="">- Select -</option>
                                            <option value="Home" <?php echo e(old('computer_access_location', $user->farmer_profile->computer_access_location ?? '') == 'Home' ? 'selected="selected"' : ''); ?>>Home</option>
                                            <option value="Office" <?php echo e(old('computer_access_location', $user->farmer_profile->computer_access_location ?? '') == 'Office' ? 'selected="selected"' : ''); ?>>Office</option>
                                            <option value="Phone" <?php echo e(old('computer_access_location', $user->farmer_profile->computer_access_location ?? '') == 'Phone' ? 'selected="selected"' : ''); ?>>Phone</option>
                                            <option value="Cyber Cafe" <?php echo e(old('computer_access_location', $user->farmer_profile->computer_access_location ?? '') == 'Cyber Cafe' ? 'selected="selected"' : ''); ?>>Cyber Cafe</option>
                                            <option value="Other" <?php echo e(old('computer_access_location', $user->farmer_profile->computer_access_location ?? '') == 'Other' ? 'selected="selected"' : ''); ?>>Other</option>
                                        </select>

                                        <?php if($errors->has('computer_access_location')): ?>
                                            <div class="invalid-feedback">
                                                <strong><?php echo e($errors->first('computer_access_location')); ?></strong>
                                            </div>
                                        <?php endif; ?>
                                    </div> <!-- form-group end.// -->
                                </div>
                                <div class="form-row">
                                    <div class="col form-group">
                                        <label for="user-internet-access">Internet Access
                                            <br><span class="small">Do you have access to the Internet?</span>
                                        </label>
                                        <select id="user-internet-access" name="internet_access" class="form-control" style="width: 100%; border-color: #ebedf2;">
                                            <option value="">- Select -</option>
                                            <option value="0" <?php echo e(old('internet_access', $user->farmer_profile->internet_access ?? '') == '0' ? 'selected="selected"' : ''); ?>>No</option>
                                            <option value="1" <?php echo e(old('internet_access', $user->farmer_profile->internet_access ?? '') == '1' ? 'selected="selected"' : ''); ?>>Yes</option>
                                        </select>

                                        <?php if($errors->has('internet_access')): ?>
                                            <div class="invalid-feedback">
                                                <strong><?php echo e($errors->first('internet_access')); ?></strong>
                                            </div>
                                        <?php endif; ?>
                                    </div> <!-- form-group end.// -->
                                    <div class="col form-group">
                                        <label for="user-internet-access-location">Internet Location
                                            <br><small>Where do you access your computer from?</small>
                                        </label>
                                        <select id="user-internet-access-location" name="internet_access_location" class="form-control" style="width: 100%; border-color: #ebedf2;">
                                            <option value="">- Select -</option>
                                            <option value="Home" <?php echo e(old('internet_access_location', $user->farmer_profile->internet_access_location ?? '') == 'Home' ? 'selected="selected"' : ''); ?>>Home</option>
                                            <option value="Office" <?php echo e(old('internet_access_location', $user->farmer_profile->internet_access_location ?? '') == 'Office' ? 'selected="selected"' : ''); ?>>Office</option>
                                            <option value="Phone" <?php echo e(old('internet_access_location', $user->farmer_profile->internet_access_location ?? '') == 'Phone' ? 'selected="selected"' : ''); ?>>Phone</option>
                                            <option value="Cyber Cafe" <?php echo e(old('internet_access_location', $user->farmer_profile->internet_access_location ?? '') == 'Cyber Cafe' ? 'selected="selected"' : ''); ?>>Cyber Cafe</option>
                                            <option value="Other" <?php echo e(old('internet_access_location', $user->farmer_profile->internet_access_location ?? '') == 'Other' ? 'selected="selected"' : ''); ?>>Other</option>
                                        </select>

                                        <?php if($errors->has('computer_access_location')): ?>
                                            <div class="invalid-feedback">
                                                <strong><?php echo e($errors->first('computer_access_location')); ?></strong>
                                            </div>
                                        <?php endif; ?>
                                    </div> <!-- form-group end.// -->
                                </div>
                                <div class="form-row">
                                    <div class="col form-group">
                                        <label for="user-credit-history">Credit History
                                            <br><span class="small">Have you borrowed for farming purposes in the past?</span>
                                        </label>
                                        <select id="user-credit-history" name="credit_history" class="form-control" style="width: 100%; border-color: #ebedf2;">
                                            <option value="">- Select -</option>
                                            <option value="0" <?php echo e(old('credit_history', $user->farmer_profile->credit_history ?? '') == '0' ? 'selected="selected"' : ''); ?>>No</option>
                                            <option value="1" <?php echo e(old('credit_history', $user->farmer_profile->credit_history ?? '') == '1' ? 'selected="selected"' : ''); ?>>Yes</option>
                                        </select>

                                        <?php if($errors->has('credit_history')): ?>
                                            <div class="invalid-feedback">
                                                <strong><?php echo e($errors->first('credit_history')); ?></strong>
                                            </div>
                                        <?php endif; ?>
                                    </div> <!-- form-group end.// -->
                                    <div class="col form-group">
                                        <label for="user-credit-history-outstanding">Outstanding Credit
                                            <br><span class="small">Do you have an outstanding loan?</span>
                                        </label>
                                        <select id="user-credit-history-outstanding" name="credit_history_outstanding" class="form-control" style="width: 100%; border-color: #ebedf2;">
                                            <option value="">- Select -</option>
                                            <option value="0" <?php echo e(old('credit_history_outstanding', $user->farmer_profile->credit_history_outstanding ?? '') == '0' ? 'selected="selected"' : ''); ?>>No</option>
                                            <option value="1" <?php echo e(old('credit_history_outstanding', $user->farmer_profile->credit_history_outstanding ?? '') == '1' ? 'selected="selected"' : ''); ?>>Yes</option>
                                        </select>

                                        <?php if($errors->has('credit_history_outstanding')): ?>
                                            <div class="invalid-feedback">
                                                <strong><?php echo e($errors->first('credit_history_outstanding')); ?></strong>
                                            </div>
                                        <?php endif; ?>
                                    </div> <!-- form-group end.// -->
                                </div>
                                <div class="form-row">
                                    <div class="col form-group">
                                        <label for="user-credit-history-outstanding-details">Outstanding Credit
                                            <br><span class="small">Information about any outstanding credit</span>
                                        </label>
                                        <textarea name="credit_history_outstanding_details" id="user-credit-history-outstanding-details" class="form-control <?php echo e($errors->has('credit_history_outstanding_details') ? 'is-invalid' : ''); ?>" placeholder="Outstanding credit information"><?php echo e(old('credit_history_outstanding_details', $user->credit_history_outstanding_details ?? '')); ?></textarea>
                                        <?php if($errors->has('credit_history_outstanding_details')): ?>
                                            <div class="invalid-feedback">
                                                <strong><?php echo e($errors->first('credit_history_outstanding_details')); ?></strong>
                                            </div>
                                        <?php endif; ?>
                                    </div> <!-- form-group end.// -->
                                </div>
                            </div>
                            <div class="col-md-12">
                                <div class="form-row">
                                    <div class="col form-group">
                                        <hr>
                                        <button type="submit" class="btn btn-primary btn-round btn-md">Update Profile</button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.site', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/spinmobisky/public_html/btcotton/resources/views/users/profile.blade.php ENDPATH**/ ?>