<?php $__env->startSection('title'); ?>
    Twalisha Trading | Twalisha Invoices to pay
<?php $__env->stopSection(); ?>

<?php $__env->startSection('header'); ?>
    <div class="page-header">
        <h4 class="page-title">Invoices</h4>
        
        <ul class="breadcrumbs">
            <li class="nav-home">
                <a href="#" class="btn btn-icon btn-sm btn-round btn-light">
                    <i class="flaticon-home"></i>
                </a>
            </li>
            <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="#">Invoices</a>
            </li>
            
        </ul>

    </div>
    <div class="ml-md-auto py-2 py-md-0">
    <!-- <a href="#" class="btn btn-primary btn-round btn-sm" data-toggle="modal" data-target="#crud-modal">
            <i class="fa fa-plus"></i> Raise Invoice
        </a> -->
        <a href="<?php echo e(URL::previous()); ?>" class="btn btn-white btn-round btn-sm ml-1">
            <i class="fas fa-caret-left"></i> Back
        </a>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="row row-card-no-pd mt--2">
        <div class="col-md-12">
            <div class="card">
                <div class="card-body">
                    <?php echo $__env->make('layouts._messages', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                    <?php if($invoiceout->count()): ?>
                        <div class="table-responsive">
                            <table id="inputs-list" class="display table table-striped table-hover" >

                                <thead>
                                    <tr>
                                    <th>S/No.</th>
                                        <th>Amount</th>
                                        <th>Balance</th>
                                        <th>Directed To [From]</th>
                                        <th>Item</th>
                                        <th>Status</th>
                                        <th>Date</th>
                                        <th class="text-right" style="width: 10%">Action</th>
                                    </tr>
                                </thead>
                                <tbody id="input-list">
                                    <?php $__currentLoopData = $invoiceout; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $invoice): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr id="<?php echo e($invoice->id); ?>">
                                            <td><a href="#"><?php echo e($invoice->id); ?></a></td>
                                            <td><?php echo e(Str::limit($invoice->total,-2,'.')); ?></td>
                                            <td><?php echo e(Str::limit($invoice->balance,-2,'.')); ?></td>
                                            <td><?php if($invoice->type === "input"): ?>
                                            Twalisha<br>
                                            [From: <?php if($invoice->invoice): ?>
                                                    <?php if($invoice->invoice->trader): ?>
                                                        <?php echo e($invoice->invoice->trader->organisation_name); ?>

                                                    <?php endif; ?>
                                                    <?php endif; ?>]
                                            </td>
                                            <?php elseif($invoice->type === "produce"): ?>
                                            <?php if($invoice->invoiceproduce): ?>
                                                <?php if($invoice->invoiceproduce['contract_detail']): ?>
                                                    <?php echo e($invoice->invoiceproduce['contract_detail']->contract->trader->organisation_name); ?><br>
                                                <?php endif; ?>
                                            <?php endif; ?>
                                            [From:Twalisha]
                                            <?php endif; ?>
                                            <td><?php if($invoice->type === "input"): ?>
                                                <?php if($invoice->invoice): ?>
                                                    <?php if($invoice->invoice['input']): ?>
                                                        <?php echo e($invoice->invoice->input['name']); ?>

                                                    <?php endif; ?>
                                                <?php endif; ?>
                                            <?php elseif($invoice->type === "produce"): ?>
                                            <?php if($invoice->invoiceproduce): ?>
                                                <?php if($invoice->contract_detail): ?>
                                                    <?php echo e($invoice->invoiceproduce->contract_detail->produce_item->produce->name); ?>

                                                <?php endif; ?>
                                            <?php endif; ?>
                                            <?php endif; ?>
                                            </td>
                                            <td>
                                            <?php if($invoice->status == 0): ?>
                                            <span class="badge badge-danger">Pending</span>
                                            <?php elseif($invoice->status == 1): ?>
                                             <span class="badge badge-warning">Paid</span>
                                             <?php elseif($invoice->status == 2): ?>
                                             <span class="badge badge-success">Confirmed</span>
                                             <?php endif; ?>
                                            </td>
                                            <td><?php echo e(Str::limit($invoice->created_at,10,'.')); ?></td>
                                            <td class="text-right">
                                               <div class="btn-group form-actions" role="group" aria-label="Actions">
                                                    <a href="<?php echo e(route('admin-invoices.show', $invoice->id)); ?>">
                                                    <button type="submit" class="btn btn-success btn-sm" data-toggle="tooltip" title="View" data-original-title="View">
                                                        <i class="fa fa-edit"></i> View
                                                    </button>
                                                    </a>
                                           <?php if($invoice->status == 1): ?>
                                            <?php if($invoice->type === "produce"): ?>
                                                <form action="<?php echo e(route('admin-invoices.store')); ?>" method="post">
                                                <?php echo csrf_field(); ?>
                                                <input type="hidden" name="id" value="<?php echo e($invoice->id); ?>">
                                                <button type="submit" name="confirm" class="btn btn-sm btn-primary">
                                                <i class="fa fa-check"></i> Confirm</button>
                                                </form>
                                             <?php endif; ?>
                                            <?php endif; ?>
                                                    <?php if($invoice->type === "input"): ?>
                                                    <?php if($invoice->status < 2): ?>
                                                    <a href="#" class="btn btn-primary btn-sm" data-toggle="modal" data-target="#modal-default-<?php echo e($invoice->id); ?>">
                                                        <i class="fas fa-file-invoice-dollar"></i>Payments
                                                    </a>
                                                    <?php endif; ?>
                                                    <?php endif; ?>
                                    </tr>
                                        <!-- Modal -->
                                        <div class="modal fade" id="modal-default-<?php echo e($invoice->id); ?>" tabindex="-1" role="dialog" aria-hidden="true">
                                            <div class="modal-dialog" role="document">
                                                <div class="modal-content">
                                                    <div class="modal-header">
                                                        <h4 class="modal-title" id="modal-title">Pay Invoice Ref# <?php echo e($invoice->id); ?></h4>
                                                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                            <span aria-hidden="true">&times;</span>
                                                        </button>
                                                    </div>
                                                    <form id="input-form" name="input-form" method="post" action="<?php echo e(route('admin-invoices.store')); ?>">
                                                        <?php echo csrf_field(); ?>

                                                        <div class="modal-body">
                                                            <input type="hidden" name="_token" id="token" value="<?php echo e(csrf_token()); ?>">
                                                            <input type="hidden" name="approved" value="1">
                                                            <input type="hidden" name="id" value="<?php echo e($invoice->id); ?>">
                                                            <input type="hidden" name="total" value="<?php echo e($invoice->total); ?>">
                                                            <input type="hidden" name="balance" value="<?php echo e($invoice->balance); ?>">
                                                            <div class="form-group">
                                                            <label for="">Mode of Payment</label>
                                                                <input class="form-control" type="text" placeholder="e.g. cheque, cash..." name="mode">
                                                            <label for="">Amount</label>
                                                                <input class="form-control" type="number" name="amount">
                                                            <label for="">Date</label>
                                                                <input class="form-control" type="date" name="date" value="date()">

                                                            </div>
                                                        </div>
                                                        <div class="modal-footer">
                                                            <button type="submit" id="modal-save" class="btn btn-primary btn-round btn-md"><i class="fa fa-check"></i> Pay Invoice</button>
                                                            <button type="button" class="btn btn-dark btn-round btn-md" data-dismiss="modal">Close</button>
                                                        </div>
                                                    </form>
                                                </div>
                                            </div>
                                        </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                                <tfoot>
                                    <tr>
                                    <th>S/No.</th>
                                        <th>Amount</th>
                                        <th>Balance</th>
                                        <th>Directed To [From]</th>
                                        <th>Item</th>
                                        <th>Status</th>
                                        <th>Date</th>
                                        <th class="text-right" style="width: 10%">Action</th>
                                    </tr>
                                </tfoot>
                            </table>
                        </div>
                    <?php else: ?>
                        <?php echo $__env->make('layouts._nodata', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    <?php endif; ?>
                </div>
            </div>


        </div>
    </div>

                            <!-- Modal -->
                            <div class="modal fade" id="crud-modal" tabindex="-1" role="dialog" aria-hidden="true">
                                    <div class="modal-dialog" role="document">
                                        <div class="modal-content">
                                            <div class="modal-header">
                                                <h4 class="modal-title" id="modal-title">Raise Invoice</h4>
                                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                    <span aria-hidden="true">&times;</span>
                                                </button>
                                            </div>
                                                    <form id="input-form" name="input-form" method="post" action="<?php echo e(route('admin-invoices.store')); ?>">
                                                        <?php echo csrf_field(); ?>

                                                        <div class="modal-body">
                                                            <input type="hidden" name="_token" id="token" value="<?php echo e(csrf_token()); ?>">
                                                            <input type="hidden" name="approved" value="0">

                                                            <div class="form-group">
                                                                <label for="trader-id">Amount</label>
                                                                <input class="form-control" type="number" name="total">
                                                                <label for="trader-id">Type</label>
                                                                <select class="form-control" name="type">
                                                                <option value="produce">Produce</option>
                                                                <option value="input">Input</option>
                                                                </select>
                                                                <label for="trader-id">Number</label>
                                                                <input class="form-control" type="number" name="number" value="">
                                                                <label for="trader-id">Directed to</label>
                                                                <select class="form-control" name="directed_to">
                                                                <option value="">-Select Trader-</option>
                                                                <?php $__currentLoopData = $traders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $trader): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                <option value="<?php echo e($trader->id); ?>"><?php echo e($trader->organisation_name); ?></option>
                                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                                </select>
                                                            </div>

                                                        </div>
                                                        <div class="modal-footer">
                                                            <button type="submit" id="modal-save" class="btn btn-primary btn-round btn-md"><i class="fa fa-check"></i> Raise Invoice</button>
                                                            <button type="button" class="btn btn-dark btn-round btn-md" data-dismiss="modal">Close</button>
                                                        </div>
                                                    </form>
                                                </div>
                                            </div>
                                        </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>
<script>
$(document).ready(function () {
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });

            $('#inputs-list').DataTable({
                "order": [[ 0, "desc" ]]
            });
        });
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.site', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/mobigrow/public_html/twalisha.com/trading/public/resources/views/admin-invoices/index.blade.php ENDPATH**/ ?>