<div class="table-responsive">
    <table id="produce-order-items-list" class="display table table-striped table-hover" >
        <thead>
            <tr>
                <th></th>
                <th>Produce</th>
                <th>Quantity</th>
                <th>Price per Unit (KES)</th>
                <th class="text-center" style="width: 10%">Action</th>
            </tr>
        </thead>
        <tfoot>
            <tr>
                <th></th>
                <th>Produce</th>
                <th>Quantity</th>
                <th>Price per Unit (KES)</th>
                <th class="text-center">Action</th>
            </tr>
        </tfoot>
        <tbody id="produce-order-item-list">
            <?php $__currentLoopData = $produce_order->produce_order_items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $produce_order_item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr id="produce_order_item_id<?php echo e($produce_order_item->id); ?>">
                    <td class="details-control" data-id="<?php echo e($produce_order_item->id); ?>"></td>
                    <td>
                        <a href="<?php echo e($produce_order_item->contract_detail->url); ?>"><?php echo e($produce_order_item->contract_detail->produce_item->name); ?></a>
                        <br><small><b>Produce:</b> <?php echo e($produce_order_item->contract_detail->produce_item->produce->name); ?> | <b>Units:</b> <?php echo e($produce_order_item->contract_detail->produce_item->produce_unit->name); ?></small>
                    </td>
                    <td><?php echo e($produce_order_item->quantity); ?></td>
                    <td><?php echo e(number_format($produce_order_item->price_per_unit, 2)); ?></td>
                    <td>
                        <div class="btn-group form-actions" role="group" aria-label="Actions">
                            <button id="edit-produce-order-item" type="button" class="btn btn-primary btn-sm" data-toggle="tooltip" title="Edit" data-original-title="Edit" data-id="<?php echo e($produce_order_item->id); ?>">
                                <i class="fa fa-edit"></i> Edit
                            </button>
                            <button id="delete-produce-order-item" type="button" class="btn btn-danger btn-sm" data-toggle="tooltip" title="Delete" data-original-title="Delete" data-id="<?php echo e($produce_order_item->id); ?>">
                                <i class="far fa-trash-alt"></i> Delete
                            </button>
                            <?php if(!$produce_order_item->approved): ?>
                            <form name="form1" action="<?php echo e(route('collections.index')); ?>" method="post">
                            <?php echo csrf_field(); ?>
                            <input type="hidden" name="_token" id="token" value="<?php echo e(csrf_token()); ?>">
                            <input type="hidden" name="id" value="<?php echo e($produce_order_item->id); ?>">
                            <input type="hidden" name="contract_detail_id" value="<?php echo e($produce_order_item->contract_detail_id); ?>">
                            <button type="submit" class="btn btn-info btn-sm" data-toggle="tooltip" title="Collect Items" data-original-title="Collect Items" >
                                <a href="<?php echo e(route('collections.index')); ?>?id=<?php echo e($produce_order_item->id); ?>&&contract_detail_id=<?php echo e($produce_order_item->contract_detail_id); ?>"><i class="far fa-check"></i> Collect</a>
                            </button>
                            </form>
                            <?php endif; ?>
                        </div>
                    </td>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
    </table>
</div>
<?php /**PATH /home/mobigrow/public_html/twa-orders/resources/views/produce-order-items/_index.blade.php ENDPATH**/ ?>