<?php $__env->startSection('title'); ?>
BTCotton | Input Orders
<?php $__env->stopSection(); ?>

<?php $__env->startSection('header'); ?>
    <div class="page-header">
        <h4 class="page-title">Input Releases</h4>
        
        <ul class="breadcrumbs">
            <li class="nav-home">
                <a href="#" class="btn btn-icon btn-sm btn-round btn-light">
                    <i class="flaticon-home"></i>
                </a>
            </li>
            <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="#">Input orders</a>
            </li>
            
        </ul>

    </div>
    <div class="ml-md-auto py-2 py-md-0">
        <a href="<?php echo e(URL::previous()); ?>" class="btn btn-white btn-round btn-sm ml-1">
            <i class="fas fa-caret-left"></i> Back
        </a>
    </div>
<?php $__env->stopSection(); ?>
<!DOCTYPE html>
<html lang="en">
<?php $__env->startSection('content'); ?>
    <div class="row row-card-no-pd mt--2">
        <div class="col-md-12">
            <div class="card">
                <div class="card-body">
                    <?php echo $__env->make('layouts._messages', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                    <?php if($inputs->count()): ?>
                        <div class="table-responsive">
                            <table id="inputs-list" class="display table table-striped table-hover" >

                                <thead>
                                    <tr>
                                        <th>ID</th>
                                        <th>Farmer </th>
                                        <th>Picked By</th>
                                        <th>Item(s)</th>
                                        <th>Date Released</th>

                                    </tr>
                                </thead>
                                <tbody id="input-list">
                                    <?php $__currentLoopData = $inputs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $input): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr id="<?php echo e($input->id); ?>">
                                            <td><a href="<?php echo e(route('input_orders.show', $input->id)); ?>"><?php echo e($input->id); ?></a></td>
                                            <td><?php echo e($input->inputOrderItems->farmer->fullname); ?></td>
                                            <td><?php if($input->picked_by): ?>
                                            <strong>Name:</strong> <?php echo e($input->picked_by); ?><br>
                                            <strong>Phone:</strong> <?php echo e($input->phone); ?><br>
                                            <strong>ID No:</strong> <?php echo e($input->id_no); ?>

                                            <?php else: ?>
                                            Owner
                                            <?php endif; ?></td>
                                            <td><strong>Item:</strong> <?php echo e($input->inputOrderItems->input->name); ?><br>
                                            <strong>Quantity:</strong> <?php echo e($input->inputOrderItems->quantity); ?> <?php echo e($input->inputOrderItems->input->input_unit->abbreviation); ?> </td>

                                            <td><?php echo e(Str::limit($input->created_at,10,'.')); ?></td>

                                    </tr>
                                     <!--Modal Deliver-->
                                        <div class="modal fade" id="modal-default-<?php echo e($input->id); ?>" tabindex="-1" role="dialog" aria-hidden="true">
                                            <div class="modal-dialog" role="document">
                                                <div class="modal-content">
                                                    <div class="modal-header">
                                                        <h4 class="modal-title" id="modal-title">Add Transport Information | Order Ref#<?php echo e($input->id); ?> </h4>
                                                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                            <span aria-hidden="true">&times;</span>
                                                        </button>
                                                    </div>
                                                    <form id="input-form" name="input-form" method="post" action="<?php echo e(route('produce-orders.store')); ?>">
                                                        <?php echo csrf_field(); ?>

                                                        <div class="modal-body">

                                                            </div>

                                                        </div>
                                                        <div class="modal-footer">
                                                            <button type="submit" name="transport" id="modal-save" class="btn btn-primary btn-round btn-md"><i class="fa fa-check"></i> Save</button>
                                                            <button type="button" class="btn btn-dark btn-round btn-md" data-dismiss="modal">Close</button>
                                                        </div>
                                                    </form>
                                                </div>
                                            </div>
                                        </div>
                                    <!--/end modal deliver-->

                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                                <tfoot>
                                <tr>
                                        <th>ID</th>
                                        <th>Farmer </th>
                                        <th>Picked By</th>
                                        <th>Item(s)</th>
                                        <th>Date Released</th>

                                    </tr>
                                </tfoot>
                            </table>
                        </div>
                    <?php else: ?>
                        <?php echo $__env->make('layouts._nodata', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    <?php endif; ?>
                </div>
            </div>


        </div>
    </div>


<?php $__env->startSection('scripts'); ?>
<script>
$(document).ready(function () {
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });

            $('#inputs-list').DataTable({
                "order": [[ 0, "desc" ]]
            });
        });
</script>
<?php $__env->stopSection(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.site', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/spinmobisky/public_html/btcotton/resources/views/input_releases/index.blade.php ENDPATH**/ ?>