<?php $__env->startSection('title'); ?>
    Twalisha Trading | Produce Collections
<?php $__env->stopSection(); ?>

<?php $__env->startSection('header'); ?>
    <div class="page-header">
        <h4 class="page-title">Produce Collections</h4>
        

        <ul class="breadcrumbs">
            <li class="nav-home">
                <a href="#" class="btn btn-icon btn-sm btn-round btn-light">
                    <i class="flaticon-home"></i>
                </a>
            </li>
            <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="#">Produce Collections</a>
            </li>
            
        </ul>
    </div>
    <div class="ml-md-auto py-2 py-md-0">
        <a href="<?php echo e(route('produce-collections.collect')); ?>" class="btn btn-primary btn-round btn-sm ml-1">
            <i class="fas fa-layer-group"></i> Collect Produce
        </a>
        <a href="<?php echo e(URL::previous()); ?>" class="btn btn-white btn-round btn-sm ml-1">
            <i class="fas fa-caret-left"></i> Back
        </a>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="row row-card-no-pd mt--2">
        <div class="col-md-12">
            <div class="card">
                <div class="card-body">
                    <?php echo $__env->make('layouts._messages', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                    <?php echo $__env->make('_partials.filter-produce-collections', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                    <div class="text-right mb-3 border-bottom pb-3">
                        <a id="produce-collections-export" href="<?php echo e(route('produce-collections.export')); ?>" class="btn btn-primary btn-border btn-round btn-sm">
                            <i class="far fa-file-excel"></i> Export Excel
                        </a>
                        <a class="btn btn-success btn-border btn-round btn-sm" data-toggle="collapse" data-target="#filter-panel">
                            <i class="fas fa-filter"></i> Filter
                        </a>
                    </div>

                    <div id="filter-msg" class="d-none">
                        <div class="alert alert-info shadow-sm mb-0" role="alert">
                            <p class="mb-0"><i class="fas fa-info-circle"></i> This is a filtered view. <span id="filters"></span></p>
                        </div>
                        <hr>
                    </div>

                    <?php if($produce_collections->count()): ?>
                        <div class="table-responsive">
                            <table id="collections-list" class="display table table-striped table-hover" >
                                <thead>
                                    <tr>
                                        <th>ID</th>
                                        <th>Farmer Organisation</th>
                                        <th>Collection Details</th>
                                        <th>Status</th>
                                        <th class="text-right" style="width: 10%">Action</th>
                                    </tr>
                                </thead>
                                <tfoot>
                                    <tr>
                                        <th>ID</th>
                                        <th>Farmer Organisation</th>
                                        <th>Collection Details</th>
                                        <th>Status</th>
                                        <th class="text-right">Action</th>
                                    </tr>
                                </tfoot>
                                <tbody id="collection-list">
                                    <?php $__currentLoopData = $produce_collections; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $produce_collection): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr id="collection_id_<?php echo e($produce_collection->id); ?>">
                                            <td><?php echo e($produce_collection->id); ?></td>
                                            <td><h5><?php echo e($produce_collection->contract_detail->produce_item->trader->organisation_name); ?></h5></td>
                                            <td><h5><?php echo e($produce_collection->contract_detail->contract->trader->organisation_name); ?></h5>
                                                <b>Produce:</b> <?php echo e($produce_collection->contract_detail->produce_item->produce->name); ?>

                                                <br><b>Quality:</b> <?php echo e($produce_collection->contract_detail->produce_item->quality); ?>

                                                <br><b>Price:</b> <?php echo e('KSh '. number_format($produce_collection->contract_detail->contract->price_per_unit, 2) . '/ ' . $produce_collection->contract_detail->produce_item->produce_unit->abbreviation); ?>

                                                <br><b>Quantity:</b> <?php echo e($produce_collection->quantity . ' ' . $produce_collection->contract_detail->produce_item->produce_unit->abbreviation); ?>

                                                <br><b>Date:</b> <?php echo e($produce_collection->created_at); ?>

                                            </td>
                                            <td class="text-center">
                                                <?php if($produce_collection->status == 1): ?>
                                                    <span class="badge badge-success">Approved</span>
                                                <?php else: ?>
                                                    <span class="badge badge-danger">Pending</span>
                                                <?php endif; ?>
                                            </td>
                                            <td class="text-right">
                                                <div class="btn-group form-actions" role="group" aria-label="Actions">
                                                    <?php if($produce_collection->status == 0): ?>
                                                        <a id="edit-collection" href="#" class="btn btn-primary btn-sm" data-toggle="tooltip" title="Edit" data-original-title="Edit" data-id="<?php echo e($produce_collection->id); ?>">
                                                            <i class="fa fa-edit"></i> Edit
                                                        </a>
                                                        <button type="button" id="delete-collection" class="btn btn-danger btn-sm" data-toggle="tooltip" title="Delete" data-original-title="Delete" data-id="<?php echo e($produce_collection->id); ?>">
                                                            <i class="far fa-trash-alt"></i> Delete
                                                        </button>
                                                        <?php if(Auth::user()->isAdmin()): ?>
                                                            <button type="button" id="deliver-collection" class="btn btn-warning btn-sm ml-1" data-toggle="tooltip" title="Approve & Request Delivery" data-original-title="Approve & Request Delivery" data-id="<?php echo e($produce_collection->id); ?>">
                                                                <i class="fas fa-check-double"></i> Approve
                                                            </button>
                                                        <?php endif; ?>
                                                    <?php endif; ?>
                                                </div>
                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>
                    <?php else: ?>
                        <?php echo $__env->make('layouts._nodata', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>

    <!-- Modal -->
    <div class="modal fade" id="crud-modal" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title" id="modal-title"></h4>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form id="collection-form" name="collection-form" method="post">
                    <div class="modal-body">
                        <div class="alert alert-info">
                            <dl class="row">
                                <dt class="col-md-5">Farmer Organisation</dt>
                                <dd class="col-md-7" id="produce-item-farmer-organisation"></dd>
                                <dt class="col-md-5">Produce</dt>
                                <dd class="col-md-7" id="produce-item-produce"></dd>
                                <dt class="col-md-5">Pending Collections</dt>
                                <dd class="col-md-7 text-danger text-bold" id="produce-item-pending"></dd>
                                <dt class="col-md-5">Available Balance</dt>
                                <dd class="col-md-7" id="produce-item-balance"></dd>
                            </dl>
                        </div>
                        <input type="hidden" name="_token" id="token" value="<?php echo e(csrf_token()); ?>">
                        <input name="id" type="hidden" id="collection-id">
                        <input name="collected_by" type="hidden" id="collection-collected-by">
                        <div class="form-group">
                            <label for="collection-contract-detail">Contract</label>
                            <input name="contract_detail_id" type="hidden" id="collection-contract-detail-id">
                            <input name="contract_detail_name" id="collection-contract-detail" class="form-control" readonly>
                        </div>
                        <div class="form-group">
                            <label for="collection-quantity">Quantity <span id="produce-item-produce-unit"></span></label>
                            <input type="text" name="quantity" id="collection-quantity" class="form-control" placeholder="Quantity">
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="submit" id="modal-save" class="btn btn-primary btn-round btn-md"><i class="fa fa-check"></i> Save</button>
                        <button type="button" class="btn btn-dark btn-round btn-md" data-dismiss="modal">Close</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <!--Modal Deliver-->
    <div class="modal fade" id="delivery-request-crud-modal" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title" id="modal-title">Request Transportation | Collection Ref. #<span class="collection_id"></span> </h4>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form id="delivery-request-form" name="delivery-request-form" method="post">
                    <div class="modal-body">
                        <input type="hidden" name="_token" id="token" value="<?php echo e(csrf_token()); ?>">
                        <input type="hidden" id="delivery-request-produce-collection-id" name="produce_collection_id">
                        <input type="hidden" id="delivery-request-status" name="status" value="0">
                        
                        
                        

                        <div class="col form-group">
                            <label for="delivery-request-transporter-id">Transporter</label>
                            <select id="delivery-request-transporter-id" class="form-control" name="transporter_id">
                                <option>- Select -</option>
                                <?php $__currentLoopData = $transporters; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $transporter): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($transporter->id); ?>"><?php echo e($transporter->organisation_name); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                        <div class="form-row">
                            <div class="col form-group">
                                <label for="delivery-request-picking-time">Expected Picking Date</label>
                                <input id="delivery-request-picking-time" type="date" name="picking_time" class="form-control">
                            </div>
                            <div class="col form-group">
                                <label for="delivery-request-delivery-time">Expected Date of Arrival</label>
                                <input id="delivery-request-delivery-time" type="date" name="delivery_time" class="form-control">
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="submit" id="delivery-request-modal-save" class="btn btn-primary btn-round btn-md"><i class="fa fa-check"></i> Save</button>
                        <button type="button" class="btn btn-dark btn-round btn-md" data-dismiss="modal">Close</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <!--/end modal deliver-->
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
    <script>
        $(document).ready(function () {
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });

            $('#delivery-request-crud-modal').on('shown.bs.modal', function() {
                $('#delivery-request-transporter-id').select2({
                    dropdownParent: $('#delivery-request-crud-modal')
                });
            });

            $('#collections-list').DataTable({
                "order": [[ 0, "desc" ]]
            });

            // edit
            $('body').on('click', '#edit-collection', function (e) {
                e.preventDefault();

                var collection_id = $(this).data('id');

                $.get('/produce-collections/' + collection_id +'/edit-ajax', function (data) {
                    console.log(data);
                    $('#modal-title').html("Edit Collections");
                    $('#modal-save').val("edit-collection");

                    $('#collection-id').val(data.id);
                    $('#collection-collected-by').val(data.collected_by);
                    $('#collection-contract-detail-id').val(data.contract_detail_id);
                    $('#collection-contract-detail').val(data.contract_detail.contract.name);
                    $('#collection-produce-item-id').val(data.produce_item_id).trigger('change');
                    $('#collection-quantity').val(data.quantity);

                    $('#produce-item-produce-unit').text('('+ data.contract_detail.produce_item.produce_unit.abbreviation +')');
                    $('#produce-item-farmer-organisation').text(data.contract_detail.produce_item.trader.organisation_name);
                    $('#produce-item-produce').html(data.contract_detail.produce_item.produce.name +'<br><b>Price:</b> '+ data.contract_detail.contract.price_per_unit +'<br><b>Quality:</b> '+ data.contract_detail.produce_item.quality);// +' /'+ data.produce_item.produce_unit.abbreviation);
                    $('#produce-item-pending').text(data.contract_detail.produce_item.pending_collections + ' ' + data.contract_detail.produce_item.produce_unit.abbreviation);
                    $('#produce-item-balance').text(data.contract_detail.produce_item.available_balance + ' ' + data.contract_detail.produce_item.produce_unit.abbreviation);

                    $('#crud-modal').modal('show');
                })
                .fail(function (jqXHR, textStatus, errorThrown) {
                    // console.warn(xhr.responseText)
                    console.log(JSON.stringify(jqXHR));
                    console.log("AJAX error: " + textStatus + ' : ' + errorThrown);
                    $('#modal-save').html('Save');
                })
            });

            // delete
            $('body').on('click', '#delete-collection', function (e) {
                e.preventDefault();

                var collection_id = $(this).data("id");
                var confirmDelete = confirm("Are you sure want to delete?");
                if (confirmDelete) {
                    $.ajax({
                        type: "DELETE",
                        url: '/produce-collections/' + collection_id + '/delete-ajax',
                        success: function (data) {
                            $("#collection_id_" + collection_id).remove();
                            console.log('Success:', data);
                        },
                        error: function (data) {
                            console.log('Error:', data);
                        }
                    });
                }
            });

            // deliver
            $('body').on('click', '#deliver-collection', function (e) {
                e.preventDefault();

                var collection_id = $(this).data('id');

                $('#modal-title').html("Edit Collections");
                $('#delivery-request-produce-collection-id').val(collection_id);
                $('#delivery-request-transporter-id').val('').trigger('change');
                $('#delivery-request-picking-time').val('');
                $('#delivery-request-delivery-time').val('');
                $('.collection_id').text(collection_id);


                $('#modal-save').val("deliver-collection");
                $('#delivery-request-crud-modal').modal('show');
            });

            // submit edit
            if ($("#collection-form").length > 0) {
                $("#collection-form").validate({
                    submitHandler: function(form) {
                        let formData = $('#collection-form').serialize();
                        var actionType = $('#modal-save').val();
                        $('#modal-save').html('Saving...');

                        $.ajax({
                            data: formData,
                            url: '/produce-collections/store-ajax',
                            type: "POST",
                            dataType: 'json',
                            success: function (data) {
                                console.log(data);
                                let approved = data.produce_collection.status == 1 ? '<span class="badge badge-success">Approved</span>' : '<span class="badge badge-danger">Pending</span>';

                                var collection = '<tr id="collection_id_' + data.produce_collection.id + '"><td>' + data.produce_collection.id + '</td>';
                                    collection += '<td><h5>' + data.produce_collection.contract_detail.produce_item.trader.organisation_name + '</h5></td>';
                                    collection += '<td><h5>'+ data.produce_collection.contract_detail.contract.trader.organisation_name +'</h5><b>Produce:</b> '+ data.produce_collection.contract_detail.produce_item.produce.name +'<br><b>Quality:</b> '+ data.produce_collection.contract_detail.produce_item.quality +'<br><b>Price:</b> ' + data.produce_collection.contract_detail.contract.price_per_unit + '/ ' + data.produce_collection.contract_detail.produce_item.produce_unit.abbreviation + '<br><b>Quantity:</b> ' + data.produce_collection.quantity +' '+ data.produce_collection.contract_detail.produce_item.produce_unit.abbreviation + '<br><b>Price:</b> '+ data.produce_collection.created_at +'</td>';
                                    collection += '<td class="text-center">' + approved + '</td>';
                                    collection += '<td class="text-right"><div class="btn-group form-actions" role="group" aria-label="Actions">';
                                    collection += '<a id="edit-collection" href="#" class="btn btn-primary btn-sm" data-toggle="tooltip" title="Edit" data-original-title="Edit" data-id="'+ data.produce_collection.id +'"><i class="fa fa-edit"></i> Edit</a>';
                                    collection += '<button type="button" id="delete-collection" class="btn btn-danger btn-sm" data-toggle="tooltip" title="Delete" data-original-title="Delete" data-id="'+ data.produce_collection.id +'"><i class="far fa-trash-alt"></i> Delete</button>';
                                    collection += data.is_admin ? '<button type="button" id="deliver-collection" class="btn btn-warning btn-sm ml-1" data-toggle="tooltip" title="Approve & Request Delivery" data-original-title="Approve & Request Delivery" data-id="'+ data.produce_collection.id +'"><i class="fas fa-check-double"></i> Approve</button>' : '';
                                    collection += '</div></td></tr>';

                                if (actionType == "create-collection") {
                                    $('#collection-list').prepend(collection);
                                } else {
                                    $("#collection_id_" + data.produce_collection.id).replaceWith(collection);
                                }

                                $('#modal-save').html('Save');
                                $('#crud-modal').modal('hide');

                                setTimeout(function() {
                                    $("#collection_id_" + data.produce_collection.id).effect("highlight", {}, 4000);
                                }, 500);

                                if(data.notification) showNotification(data.notification);
                            },
                            error: function (jqXHR, textStatus, errorThrown) {
                                // console.warn(xhr.responseText)
                                console.log(JSON.stringify(jqXHR));
                                console.log("AJAX error: " + textStatus + ' : ' + errorThrown);
                                $('#modal-save').html('Save');
                            }
                        });
                    }
                });
            }

            // submit approve & delivery request
            if ($("#delivery-request-form").length > 0) {
                $("#delivery-request-form").validate({
                    submitHandler: function(form) {
                        let formData = $('#delivery-request-form').serialize();
                        var actionType = $('#delivery-request-modal-save').val();
                        $('#delivery-request-modal-save').html('Saving...');

                        $.ajax({
                            data: formData,
                            url: '/produce-collections/delivery-ajax',
                            type: "POST",
                            dataType: 'json',
                            success: function (data) {
                                console.log(data);
                                let approved = data.produce_collection.status == 1 ? '<span class="badge badge-success">Approved</span>' : '<span class="badge badge-danger">Pending</span>';

                                var collection = '<tr id="collection_id_' + data.produce_collection.id + '"><td>' + data.produce_collection.id + '</td>';
                                    collection += '<td><h5>' + data.produce_collection.contract_detail.produce_item.trader.organisation_name + '</h5></td>';
                                    collection += '<td><h5>'+ data.produce_collection.contract_detail.contract.trader.organisation_name +'</h5><b>Produce:</b> '+ data.produce_collection.contract_detail.produce_item.produce.name +'<br><b>Quality:</b> '+ data.produce_collection.contract_detail.produce_item.quality +'<br><b>Price:</b> ' + data.produce_collection.contract_detail.contract.price_per_unit + '/ ' + data.produce_collection.contract_detail.produce_item.produce_unit.abbreviation + '<br><b>Quantity:</b> ' + data.produce_collection.quantity + '<br><b>Price:</b> '+ data.produce_collection.created_at +'</td>';
                                    collection += '<td class="text-center">' + approved + '</td>';
                                    collection += '<td class="text-right"></td></tr>';

                                $("#collection_id_" + data.produce_collection.id).replaceWith(collection);

                                $('#delivery-request-modal-save').html('Save');
                                $('#delivery-request-crud-modal').modal('hide');

                                setTimeout(function() {
                                    $("#collection_id_" + data.produce_collection.id).effect("highlight", {}, 4000);
                                }, 500);

                                if(data.notification) showNotification(data.notification);
                            },
                            error: function (jqXHR, textStatus, errorThrown) {
                                // console.warn(xhr.responseText)
                                console.log(JSON.stringify(jqXHR));
                                console.log("AJAX error: " + textStatus + ' : ' + errorThrown);
                                $('#delivery-request-modal-save').html('Save');
                            }
                        });
                    }
                });
            }
        });
    </script>

<script type="text/javascript">
    function hasQueryString() {
        // get the current URL
        var currentUrl = window.location.href;
        // regex pattern for detecting ? character
        var pattern = new RegExp(/\?.+=.*/g);
        return pattern.test(currentUrl);
    }

    $( document ).ready(function() {
        if(hasQueryString()) {
            var urlParams = new URLSearchParams(location.search);
            let exportURL = $('#produce-collections-export').attr('href');
            exportURL += '?' + urlParams.toString();
            $('#produce-collections-export').attr('href', exportURL);

            $('#filter-panel').collapse("show");
            $("#filter-msg").removeClass('d-none');

            $('#filter-organisation-name').val(urlParams.get('organisation_name'));
            $('#filter-buyer').val(urlParams.get('buyer'));
            $('#filter-produce').val(urlParams.get('produce')).trigger('change');
            $('#filter-status').val(urlParams.get('status')).trigger('change');
        }
    });
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.site', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/mobigrow/public_html/twalisha.com/trading/public/resources/views/produce-collections/index.blade.php ENDPATH**/ ?>