<div class="table-responsive">
    <table id="trader-members-list" class="display table table-striped table-hover" >
        <thead>
            <tr>
                <th>Name</th>
                <th>Username</th>
                <th>Email</th>
                <th>Phone</th>
                <th>Active</th>
                <th class="text-center" style="width: 10%">Action</th>
            </tr>
        </thead>
        <tfoot>
            <tr>
                <th>Name</th>
                <th>Username</th>
                <th>Email</th>
                <th>Phone</th>
                <th>Active</th>
                <th class="text-center">Action</th>
            </tr>
        </tfoot>
        <tbody id="trader-member-list">
            <?php $__currentLoopData = $trader_members; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $member): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr id="trader_member_id_<?php echo e($member->id); ?>">
                    <td><a href="<?php echo e($member->user->url); ?>"><?php echo e($member->user->fullname); ?></a></td>
                    <td><?php echo e($member->user->username); ?></td>
                    <td><?php echo e($member->user->email); ?></td>
                    <td><?php echo e($member->user->phone); ?></td>
                    <td class="text-center"><?php echo $member->active ? '<i class="fa fa-check"></i>' : ''; ?></td>
                    <td>
                        <div class="btn-group form-actions" role="group" aria-label="Actions">
                            <button id="edit-trader-member" type="button" class="btn btn-primary btn-sm" data-toggle="tooltip" title="Edit" data-original-title="Edit" data-id="<?php echo e($member->id); ?>">
                                <i class="fa fa-edit"></i> Edit
                            </button>
                            <button id="delete-trader-member" type="button" class="btn btn-danger btn-sm" data-toggle="tooltip" title="Delete" data-original-title="Delete" data-id="<?php echo e($member->id); ?>">
                                <i class="far fa-trash-alt"></i> Delete
                            </button>
                        </div>
                    </td>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
    </table>
</div>
<?php /**PATH /home/mobigrow/public_html/twalisha.com/trading/public/resources/views/trader-members/_index.blade.php ENDPATH**/ ?>