<div class="table-responsive">
    <table id="trader-contracts-list" class="display table table-striped table-hover" >
        <thead>
            <tr>
                <th>Contract</th>
                <th>Price per Unit</th>
                <th>Tonnage (in Kgs)</th>
                <?php if(Auth::user()->isAdmin()): ?>
                    <th class="text-center" style="width: 10%">Action</th>
                <?php endif; ?>
            </tr>
        </thead>
        <tfoot>
            <tr>
                <th>Contract</th>
                <th>Price per Unit</th>
                <th>Tonnage (in Kgs)</th>
                <?php if(Auth::user()->isAdmin()): ?>
                    <th class="text-center">Action</th>
                <?php endif; ?>
            </tr>
        </tfoot>
        <tbody id="trader-contract-list">
            <?php $__currentLoopData = $trader_contracts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $contract): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr id="trader_contract_id_<?php echo e($contract->id); ?>">
                    <td>
                        <a href="<?php echo e($contract->url); ?>"><?php echo e($contract->name); ?></a>
                        <br><small><i class="far fa-file-pdf"></i> Contract Document [<a href="<?php echo e(asset('trader-contracts/' . $contract->contract_file)); ?>" target="_blank">Download</a>]</small>
                        <br><small>Produce: <?php echo e($contract->produce->name); ?></small>
                        <br><small>Unit: <?php echo e($contract->produce_unit->name); ?></small>
                    </td>
                    <td><?php echo e(number_format($contract->price_per_unit, 2)); ?></td>
                    <td><?php echo e(number_format($contract->tonnage)); ?></td>
                    <?php if(Auth::user()->isAdmin()): ?>
                        <td>
                            <div class="btn-group form-actions" role="group" aria-label="Actions">
                                <button id="edit-trader-contract" type="button" class="btn btn-primary btn-sm" data-toggle="tooltip" title="Edit" data-original-title="Edit" data-id="<?php echo e($contract->id); ?>">
                                    <i class="fa fa-edit"></i> Edit
                                </button>
                                <button id="delete-trader-contract" type="button" class="btn btn-danger btn-sm" data-toggle="tooltip" title="Delete" data-original-title="Delete" data-id="<?php echo e($contract->id); ?>">
                                    <i class="far fa-trash-alt"></i> Delete
                                </button>
                            </div>
                        </td>
                    <?php endif; ?>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
    </table>
</div>
<?php /**PATH /home/spinmobisky/public_html/btcotton/resources/views/trader-contracts/_index.blade.php ENDPATH**/ ?>