<?php $__env->startSection('title'); ?>
    Twalisha Trading | Regions
<?php $__env->stopSection(); ?>

<?php $__env->startSection('header'); ?>
    <div class="page-header">
        <h4 class="page-title">Regions</h4>
        

        <ul class="breadcrumbs">
            <li class="nav-home">
                <a href="#" class="btn btn-icon btn-sm btn-round btn-light">
                    <i class="flaticon-home"></i>
                </a>
            </li>
            <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="#">Regions</a>
            </li>
            
        </ul>
    </div>
    <div class="ml-md-auto py-2 py-md-0">
        <a id="create-region" href="<?php echo e(route('regions.create')); ?>" class="btn btn-primary btn-round btn-sm">
            <span class="btn-label"><i class="fa fa-plus"></i></span> Add Region
        </a>

        <a href="<?php echo e(route('dashboard')); ?>" class="btn btn-white btn-border btn-round btn-sm ml-1">
            <span class="btn-label"><i class="fas fa-caret-left"></i></span> Back
        </a>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="row row-card-no-pd mt--2">
        <div class="col-md-12">
            <div class="card">
                <div class="card-body">
                    <?php echo $__env->make('layouts._messages', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                    <?php if($regions->count()): ?>
                        <div class="table-responsive">
                            <table id="regions-list" class="display table table-striped table-hover" >
                                <thead>
                                    <tr>
                                        <th>Name</th>
                                        <th>Description</th>
                                        <th class="text-center" style="width: 10%">Action</th>
                                    </tr>
                                </thead>
                                <tfoot>
                                    <tr>
                                        <th>Name</th>
                                        <th>Description</th>
                                        <th class="text-center">Action</th>
                                    </tr>
                                </tfoot>
                                <tbody id="region-list">
                                    <?php $__currentLoopData = $regions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $region): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr id="region_id_<?php echo e($region->id); ?>">
                                            <td><a href="<?php echo e($region->url); ?>"><?php echo e($region->name); ?></a></td>
                                            <td><?php echo e(Str::limit($region->description, '100')); ?></td>
                                            <td>
                                                <div class="btn-group form-actions" role="group" aria-label="Actions">
                                                    <a id="edit-region" href="<?php echo e(route('regions.edit', $region->id)); ?>" class="btn btn-primary btn-sm" data-toggle="tooltip" title="Edit" data-original-title="Edit" data-id="<?php echo e($region->id); ?>">
                                                        <i class="fa fa-edit"></i> Edit
                                                    </a>
                                                    <button id="delete-region" type="submit" class="btn btn-danger btn-sm" data-toggle="tooltip" title="Delete" data-original-title="Delete" data-id="<?php echo e($region->id); ?>">
                                                        <i class="far fa-trash-alt"></i> Delete
                                                    </button>
                                                </div>
                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>
                    <?php else: ?>
                        <?php echo $__env->make('layouts._nodata', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>

    <!-- Modal -->
    <div class="modal fade" id="crud-modal" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title" id="modal-title"></h4>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form id="region-form" name="region-form" method="post">
                    <?php echo csrf_field(); ?>

                    <div class="modal-body">
                        <input type="hidden" name="id" id="region-id">
                        <input type="hidden" name="_token" id="token" value="<?php echo e(csrf_token()); ?>">
                        <div class="form-group">
                            <label for="region-name">Name</label>
                            <input type="text" name="name" id="region-name" value="" class="form-control" placeholder="Name" autofocus>
                        </div>
                        <div class="form-group">
                            <label for="region-description">Description</label>
                            <textarea name="description" id="region-description" class="form-control"></textarea>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="submit" id="modal-save" class="btn btn-primary btn-round btn-md"><i class="fa fa-check"></i> Save</button>
                        <button type="button" class="btn btn-dark btn-round btn-md" data-dismiss="modal">Close</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
    <script>
        $(document).ready(function () {
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });

            $('#crud-modal').on('shown.bs.modal', function() {
                $('#region-name').trigger('focus');
            });

            $('#regions-list').DataTable({
                // "pageLength": 5,
            });

            // create
            $('body').on('click', '#create-region', function(e) {
                e.preventDefault();

                $('#modal-save').val("create-region");
                $('#region-form').trigger("reset");
                $('#region-id').val('');
                $('#modal-title').html("Add Region");
                $('#crud-modal').modal('show');
            });

            // edit
            $('body').on('click', '#edit-region', function (e) {
                e.preventDefault();

                var region_id = $(this).data('id');

                $.get('regions/' + region_id +'/edit-ajax', function (data) {
                    console.log(data);
                    $('#modal-title').html("Edit Region");
                    $('#modal-save').val("edit-region");

                    $('#region-id').val(data.id);
                    $('#region-name').val(data.name);
                    $('#region-description').val(data.description);
                    $('#crud-modal').modal('show');
                })
                .fail(function (jqXHR, textStatus, errorThrown) {
                    // console.warn(xhr.responseText)
                    console.log(JSON.stringify(jqXHR));
                    console.log("AJAX error: " + textStatus + ' : ' + errorThrown);
                    $('#modal-save').html('Save');
                })
            });

            // delete
            $('body').on('click', '#delete-region', function (e) {
                e.preventDefault();

                var region_id = $(this).data("id");
                var confirmDelete = confirm("Are you sure want to delete?");
                if (confirmDelete) {
                    $.ajax({
                        type: "DELETE",
                        url: 'regions/' + region_id + '/delete-ajax',
                        success: function (data) {
                            $("#region_id_" + region_id).remove();
                            console.log('Success:', data);
                        },
                        error: function (data) {
                            console.log('Error:', data);
                        }
                    });
                }
            });

            // submit
            if ($("#region-form").length > 0) {
                $("#region-form").validate({
                    submitHandler: function(form) {
                        let formData = $('#region-form').serialize();
                        var actionType = $('#modal-save').val();
                        $('#modal-save').html('Saving...');

                        $.ajax({
                            data: formData,
                            url: '/regions/store-ajax',
                            type: "POST",
                            dataType: 'json',
                            success: function (data) {
                                var region = '<tr id="region_id_' + data.id + '"><td><a href="'+ data.url +'">' + data.name + '</a></td>';
                                    region += '<td>' + data.description + '</td><td class="text-right"><div class="btn-group form-actions" role="group" aria-label="Actions">';
                                    region += '<a id="edit-region" href="'+ data.url +'/edit" class="btn btn-primary btn-sm" data-toggle="tooltip" title="Edit" data-original-title="Edit" data-id="'+ data.id +'"><i class="fa fa-edit"></i> Edit</a>';
                                    region += '<button id="delete-region" type="submit" class="btn btn-danger btn-sm" data-toggle="tooltip" title="Delete" data-original-title="Delete" data-id="'+ data.id +'"><i class="far fa-trash-alt"></i> Delete</button></div></td></tr>';

                                    // $('#add-row').dataTable().fnAddData([
                                    //     $("#addName").val(),
                                    //     $("#addPosition").val(),
                                    //     $("#addOffice").val(),
                                    //     region
                                    // ]);

                                if (actionType == "create-region") {
                                    $('#region-list').prepend(region);
                                } else {
                                    $("#region_id_" + data.id).replaceWith(region);
                                }

                                $('#modal-save').html('Save');
                                $('#crud-modal').modal('hide');
                            },
                            error: function (jqXHR, textStatus, errorThrown) {
                                // console.warn(xhr.responseText)
                                console.log(JSON.stringify(jqXHR));
                                console.log("AJAX error: " + textStatus + ' : ' + errorThrown);
                                $('#modal-save').html('Save');
                            }
                        });
                    }
                });
            }
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/mobigrow/public_html/twa-orders/resources/views/regions/index.blade.php ENDPATH**/ ?>