<?php $__env->startSection('title'); ?>
    Twalisha Trading | Collection
<?php $__env->stopSection(); ?>

<?php $__env->startSection('header'); ?>
    <div class="page-header">
        <h4 class="page-title">Collection</h4>
        

        <ul class="breadcrumbs">
            <li class="nav-home">
                <a href="#" class="btn btn-icon btn-sm btn-round btn-light">
                    <i class="flaticon-home"></i>
                </a>
            </li>
            <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="#">Collection</a>
            </li>
            
        </ul>
    </div>
    <div class="ml-md-auto py-2 py-md-0">
        <?php if(isset($trader)): ?>
            <a id="create-aggregation" href="" class="btn btn-primary btn-round btn-sm">
                <span class="btn-label"><i class="fa fa-plus"></i></span> Collect
            </a>
        <?php endif; ?>

        <a href="<?php echo e(route('dashboard')); ?>" class="btn btn-white btn-border btn-round btn-sm ml-1">
            <span class="btn-label"><i class="fas fa-caret-left"></i></span> Back
        </a>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="row row-card-no-pd mt--2">
        <div class="col-md-12">
            <div class="card">
                <div class="card-body">
                <?php if($errors->any()): ?>
                        <div class="alert alert-danger alert-dismissible" role="alert">
                        <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
                           <strong>Error! </strong>There were some errors with inputs. 
                         <ul>
                        <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li><?php echo e($error); ?></li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul> 
                    </div>
                    
                <?php endif; ?>
                    <?php echo $__env->make('layouts._messages', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                    <?php if($produce_aggregations->count()): ?>
                        <div class="table-responsive">
                            <table id="aggregations-list" class="display table table-striped table-hover" >
                                <thead>
                                    <tr>
                                        <th>Trader</th>
                                        <th>Produce</th>
                                        <th>Quantity</th>
                                        <th>Details</th>
                                        <th class="text-center" style="width: 10%">Action</th>
                                    </tr>
                                </thead>
                                <tfoot>
                                    <tr>
                                        <th>Trader</th >
                                        <th>Produce</th>
                                        <th>Quantity</th>
                                        <th>Status</th>
                                        <th class="text-center">Action</th>
                                    </tr>
                                </tfoot>
                                <tbody id="aggregation-list">
                                    <?php $__currentLoopData = $produce_aggregations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $produce_aggregation): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr id="aggregation_id_<?php echo e($produce_aggregation->id); ?>">
                                            <td><?php echo e($produce_aggregation->id); ?></td>
                                            <td>
                                                <?php echo e($produce_aggregation->produce_id); ?></td>
                                            <td><?php echo e($produce_aggregation->balance); ?></td>
                                            <td>
                                                <?php if($produce_aggregation->approved == 1): ?>
                                                    <span class="text-success">Approved</span>
                                                    <?php else: ?>
                                                    <span class="text-danger">Not Approved</span>
                                                <?php endif; ?>
                                            </td>
                                            <td>
                                                <div class="btn-group form-actions" role="group" aria-label="Actions">
                                                    <?php if(!$produce_aggregation->approved): ?>
                                                      
                                                    <button type="button" name="collect" class="btn btn-success btn-sm" title="Collect" data-original-title="Collect" data-id=""data-toggle="modal" data-target="#modal-default-<?php echo e($produce_aggregation->id); ?>">
                                                        <i class="fa fa-check"></i> Collect
                                                    </button>
                                                    <?php endif; ?>
                                                    
                                                </div>

                                            </td>
                                            <!-- Modal -->
   
                                        <div class="modal fade" id="modal-default-<?php echo e($produce_aggregation->id); ?>" tabindex="-1" role="dialog" aria-hidden="true">
                                            <div class="modal-dialog" role="document">
                                                <div class="modal-content">
                                                    <div class="modal-header">
                                                        <h4 class="modal-title" id="modal-title">Collection Ref#<?php echo e($produce_aggregation->id); ?> </h4>
                                                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                            <span aria-hidden="true">&times;</span>
                                                        </button>
                                                    </div>
                                                    <form action="<?php echo e(route('collections.store')); ?>" name="form-collect" method="post">
                                                        <?php echo csrf_field(); ?>

                                                        <div class="modal-body">
                                                            <input type="hidden" name="produce_item_id" value="<?php echo e($cid[0]); ?>">
                                                            <input type="hidden" name="quantity" value="<?php echo e($produce_aggregation->quantity); ?>">
                                                            <input type="hidden" name="status" value="1">
                                                            <input type="hidden" name="produce_order_item_id" value="<?php echo e($pid); ?>">
                                                            <input type="hidden" name="_token" id="token" value="<?php echo e(csrf_token()); ?>">
                                                            
                                                            <div class="form-group">
                                                                
                                                            </div>
                                                        
                                                        </div>
                                                        <div class="modal-footer">
                                                            <button type="submit" id="modal-save" class="btn btn-primary btn-round btn-md"><i class="fa fa-check"></i> Save</button>
                                                            <button type="button" class="btn btn-dark btn-round btn-md" data-dismiss="modal">Close</button>
                                                        </div>
                                                    </form>
                                                </div>
                                            </div>
                                        </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>
                                        </tr>
                                        
                    <?php else: ?>
                        <?php echo $__env->make('layouts._nodata', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>

    

<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
    
<?php $__env->stopSection(); ?>

<?php echo $__env->make( (Auth::user()->isAdmin()) ? 'layouts.admin' : 'layouts.fo', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/mobigrow/public_html/twa-orders/resources/views/collections/index.blade.php ENDPATH**/ ?>