<?php $__env->startSection('title'); ?>
    Twalisha Trading | Input Order - #<?php echo e($order->id); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('header'); ?>

    <div class="page-header">
        <h4 class="page-title">
            Input Order - #<?php echo e($order->id); ?>


            <?php if($order->approved == 0): ?>
                <span id="approval-badge-main" class="badge badge-danger ml-2 mt--1" style="text-shadow: none;">Pending </span>
            <?php elseif($order->approved == 1): ?>
                <span id="approval-badge-main" class="badge badge-warning ml-2 mt--1" style="text-shadow: none;">In Process</span>
            <?php elseif($order->approved == 2): ?>
                <span id="approval-badge-main" class="badge badge-success ml-2 mt--1" style="text-shadow: none;">Completed</span>
            <?php elseif($order->approved == 3): ?>
                <span id="approval-badge-main" class="badge badge-success ml-2 mt--1" style="text-shadow: none;">Delivered</span>
            <?php elseif($order->approved == 4): ?>
                <span id="approval-badge-main" class="badge badge-success ml-2 mt--1" style="text-shadow: none;">Received</span>
            <?php endif; ?>
        </h4>
        <h5 class="mb-3">Organisation: <span class="op-7"><?php echo e($order->trader->organisation_name); ?> (<?php echo e($order->trader->trader_type->name); ?>)</span></h5>
        <ul class="breadcrumbs">
            <li class="nav-home">
                <a href="#" class="btn btn-icon btn-sm btn-round btn-light">
                    <i class="flaticon-home"></i>
                </a>
            </li>
            <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="<?php echo e(route('input_orders.index')); ?>">Input Orders</a>
            </li>
            <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <span>#<?php echo e($order->id); ?></span>
            </li>
            
        </ul>
    </div>
    <div class="ml-md-auto py-2 py-md-0">
        <?php if($order->approved == 0 && $order->order_items_count > 0): ?>
            <button id="approve-input-order" class="btn btn-warning btn-round btn-sm" data-id="<?php echo e($order->id); ?>">
                <i class="fas fa-check-double"></i></span> Approve
            </button>
        <?php endif; ?>
        <a href="<?php echo e(URL::previous()); ?>" class="btn btn-white btn-round btn-sm ml-1">
            <i class="fas fa-caret-left"></i></span> Back
        </a>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-body">
                    <?php echo $__env->make('layouts._messages', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                    <?php echo $__env->make('_partials.form-add-input-order-item', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    <?php echo $__env->make('_partials.filter-input-order-items', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                    <div class="text-right mb-3 border-bottom pb-3">
                        <a id="input-order-items-export" href="<?php echo e(route('input_orders.export', $order->id)); ?>" class="btn btn-primary btn-border btn-round btn-sm">
                            <i class="far fa-file-excel"></i> Export Excel
                        </a>
                        <a class="btn btn-success btn-border btn-round btn-sm" data-toggle="collapse" data-target="#filter-panel">
                            <i class="fas fa-filter"></i> Filter
                        </a>
                        <?php if($order->approved == 0): ?>
                            <button id="add-order-item" type="button" class="btn btn-primary btn-round btn-sm ml-1" data-toggle="collapse" data-target="#order-panel">
                                <i class="fa fa-plus"></i> Add Order Item
                            </button>
                        <?php endif; ?>
                    </div>

                    <div id="filter-msg" class="d-none">
                        <div class="alert alert-info shadow-sm mb-0" role="alert">
                            <p class="mb-0"><i class="fas fa-info-circle"></i> This is a filtered view. <span id="filters"></span></p>
                        </div>
                        <hr>
                    </div>

                    

                    <?php if($items->count()): ?>
                        <div class="table-responsive">
                            <table id="input-order-items-list" class="display table table-striped table-hover" >
                                <thead>
                                    <tr>
                                        <th>ID</th>
                                        <th>Farmer</th>
                                        <th>Order Details</th>
                                        <th class="text-center">Pay From</th>
                                        <th class="text-right">Total (KSh)</th>
                                        <?php if($order->approved == 1): ?>
                                            <th class="text-center">Status</th>
                                        <?php endif; ?>
                                        <th style="width: 10%">Action</th>
                                    </tr>
                                </thead>
                                <tfoot>
                                    <tr>
                                        <th>ID</th>
                                        <th>Farmer</th>
                                        <th>Order Details</th>
                                        <th class="text-center">Pay From</th>
                                        <th class="text-right">Total (KSh)</th>
                                        <?php if($order->approved == 1): ?>
                                            <th class="text-center">Status</th>
                                        <?php endif; ?>
                                        <th style="width: 10%">Action</th>
                                    </tr>
                                </tfoot>
                                <tbody id="input-order-item-list">
                                    <?php $__currentLoopData = $items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr id="input_order_item_id_<?php echo e($item->id); ?>">
                                            <td><a href="#"><?php echo e($item->id); ?></a></td>
                                            <td><?php echo e($item->farmer->fullname); ?></td>
                                            <td>
                                                <h5><?php echo e($item->input->name); ?></h5>
                                                <b>Seller:</b> <?php echo e($item->input->trader->organisation_name); ?>

                                                <br><b>Quantity:</b> <?php echo e($item->quantity); ?> <?php echo e($item->input->input_unit->abbreviation); ?>

                                                <br><b>Price:</b> <?php echo e(number_format($item->input->price_per_unit)); ?> /<?php echo e($item->input->input_unit->abbreviation); ?>

                                            </td>
                                            <td class="text-center"><?php echo e(strtoupper($item->financing)); ?></td>
                                            <td class="text-right"><?php echo e(number_format($item->price)); ?></td>
                                            <?php if($order->approved == 1): ?>
                                                <td class="text-center">
                                                    <?php if($item->approved == 0): ?>
                                                        <span class="badge badge-danger">Pending Financing</span>
                                                        <?php if($item->financing == "credit"): ?>
                                                            <?php if(isset($item->crs)): ?>
                                                                <p class="mt-1 mb-0"><b>Credited:</b> <?php echo e(number_format($item->crs[0]->credited_amount)); ?></p>
                                                            <?php endif; ?>
                                                        <?php endif; ?>
                                                    <?php elseif($item->approved == 1): ?>
                                                        <span class="badge badge-warning">In Process</span>
                                                    <?php elseif($item->approved == 2): ?>
                                                        <span class="badge badge-success">Done</span>
                                                    <?php elseif($item->approved == 3): ?>
                                                        <span class="badge badge-success">Delivered</span>
                                                    <?php elseif($item->approved == 4): ?>
                                                        <span class="badge badge-success">Received</span>
                                                    <?php elseif($item->approved == 5): ?>
                                                        <span class="badge badge-success">Released</span>
                                                    <?php endif; ?>
                                                </td>
                                            <?php endif; ?>
                                            <td class="text-right">
                                                <div class="btn-group form-actions" role="group" aria-label="Actions">
                                                    <?php if(Auth::user()->isTraderAdmin() && Auth::user()->getRelatedTrader()->isAgroDealer()): ?>
                                                        <form name="approveitem" action="<?php echo e(route('bulk-seller.store')); ?>" method="post" class="btn-group">
                                                            <input type="hidden" name="_token" id="token" value="<?php echo e(csrf_token()); ?>">
                                                            <input type="hidden" name="id" value="<?php echo e($item->id); ?>">
                                                            <input type="hidden" name="order_id" value="<?php echo e($order->id); ?>">
                                                            <input type="hidden" name="amount" value="<?php echo e($item->price); ?>">
                                                            <input type="hidden" name="financing" value="<?php echo e($item->financing); ?>">
                                                            <input type="hidden" name="uid" value="<?php echo e($item->farmer->wallet->id); ?>">
                                                            <input type="hidden" name="bal" value="<?php echo e($item->farmer->wallet->balance); ?>">
                                                            <input type="hidden" name="approved" value="2">
                                                            <?php if($item->approved == 1): ?>
                                                                <button type="submit" name="approveitem" class="btn btn-primary btn-sm" data-toggle="tooltip" title="Complete">
                                                                    <i class="fa fa-edit"></i> Complete
                                                                </button>
                                                            <?php endif; ?>
                                                        </form>
                                                    <?php endif; ?>

                                                    <?php if($order->approved == 0 || $item->approved == 0): ?>
                                                        

                                                        <button type="submit" id="edit-input-order-item" class="btn btn-primary btn-sm" data-toggle="tooltip" title="Edit" data-original-title="Edit" data-id="<?php echo e($item->id); ?>">
                                                            <i class="fa fa-edit"></i> Edit
                                                        </button>

                                                        <button type="submit" id="delete-input-order-item" class="btn btn-danger btn-sm" data-toggle="tooltip" title="Delete" data-original-title="Delete" data-id="<?php echo e($item->id); ?>">
                                                            <i class="far fa-trash-alt"></i> Delete
                                                        </button>
                                                    <?php endif; ?>

                                                    <?php if(Auth::user()->isTraderAdmin() && Auth::user()->getRelatedTrader()->isFarmerOrganisation()): ?>
                                                        <?php if($item->approved == 4): ?>
                                                            <a href="#" class="btn btn-info btn-sm" title="Release to farmer" data-toggle="modal" data-target="#modal-release-<?php echo e($item->id); ?>">
                                                                <i class="fas fa-people-carry"></i> Release
                                                            </a>
                                                        <?php endif; ?>
                                                    <?php endif; ?>
                                                </div>
                                            </td>
                                        </tr>

                                        <!-- Modal Release -->
                                        <div class="modal fade" id="modal-release-<?php echo e($item->id); ?>" tabindex="-1" role="dialog" aria-hidden="true">
                                            <div class="modal-dialog" role="document">
                                                <div class="modal-content">
                                                    <div class="modal-header">
                                                        <h4 class="modal-title" id="modal-title">Release Order Item</h4>
                                                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                            <span aria-hidden="true">&times;</span>
                                                        </button>
                                                    </div>
                                                    <div class="modal-body">
                                                        <form action="<?php echo e(route('input_orders.update', $item->id)); ?>" method="post">
                                                            <?php echo method_field('PUT'); ?>
                                                            <input type="hidden" name="_token" id="token" value="<?php echo e(csrf_token()); ?>">
                                                            <input type="hidden" name="input_order_item_id" value="<?php echo e($item->id); ?>">
                                                            <input type="hidden" id="user" value="<?php echo e($item->farmer->username); ?>">
                                                            <input type="hidden" name="approved" value="4">

                                                            <div class="form-group row">
                                                                <div class="col-md-12">
                                                                    <label for="picked_by">Picked By</label>
                                                                    <input type="text" name="picked_by" class="form-control" placeholder="Full Name">
                                                                    </div>
                                                                    <div class="col-md-12">
                                                                    <label for="id_no">ID No.</label>
                                                                    <input type="text" name="id_no" class="form-control" placeholder="ID No.">
                                                                    </div>
                                                                    <div class="col-md-12">
                                                                    <label for="phone">Phone No.</label>
                                                                    <input type="text" name="phone" class="form-control" placeholder="Phone No">
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="modal-footer">
                                                            <button type='submit' name='releaseitem' class='btn btn-primary btn-round btn-md'><i class='fa fa-check'></i> Release</button>
                                                            <button type="button" class="btn btn-dark btn-round btn-md" data-dismiss="modal"><i class="fa fa-remove"></i>Close</button>
                                                        </div>
                                                    </form>
                                                </div>
                                            </div>
                                        </div>
                                        <!--end modal release-->

                                        <!-- Modal -->
                                        <div class="modal fade" id="modal-approve-<?php echo e($item->id); ?>" tabindex="-1" role="dialog" aria-hidden="true">
                                            <div class="modal-dialog" role="document">
                                                <div class="modal-content">
                                                    <div class="modal-header">
                                                        <h4 class="modal-title" id="modal-title">Approve order</h4>
                                                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                            <span aria-hidden="true">&times;</span>
                                                        </button>
                                                    </div>
                                                    <div class="modal-body">
                                                        <form action="<?php echo e(route('input_orders.update', $item->id)); ?>" method="post">
                                                            <?php echo method_field('PUT'); ?>
                                                            <input type="hidden" name="_token" id="token" value="<?php echo e(csrf_token()); ?>">
                                                            <input type="hidden" name="id" value="<?php echo e($item->id); ?>">
                                                            <input type="hidden" id="user" value="<?php echo e($item->farmer->username); ?>">
                                                            <input type="hidden" name="approved" value="1">

                                                            <div class="form-group row">
                                                                <div class="col-md-12">
                                                                    <label for="input-order-item-expected-date">Farmer Confirmation</label>
                                                                    <input type="password" class="form-control" placeholder="confirm PIN">
                                                                    <button type="submit" name='approveitem' class="btn btn-info">Confirm</button>
                                                                    <button type='submit' style="display:none" name='approveitem' class='btn btn-warning btn-round btn-md'><i class="fas fa-check-double"></i> Approve</button>
                                                                </div>
                                                            </div>


                                                        <div class="modal-footer" id="save-button">
                                                            <button type="button" class="btn btn-dark btn-round btn-md" data-dismiss="modal"><i class="fa fa-remove"></i>Close</button>
                                                        </div>
                                                        </form>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>
                    <?php else: ?>
                        <?php echo $__env->make('layouts._nodata', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
    <script>
        function formatMoney(amount, decimalCount = 2, decimal = ".", thousands = ",") {
            try {
                decimalCount = Math.abs(decimalCount);
                decimalCount = isNaN(decimalCount) ? 2 : decimalCount;

                const negativeSign = amount < 0 ? "-" : "";

                let i = parseInt(amount = Math.abs(Number(amount) || 0).toFixed(decimalCount)).toString();
                let j = (i.length > 3) ? i.length % 3 : 0;

                return negativeSign + (j ? i.substr(0, j) + thousands : '') + i.substr(j).replace(/(\d{3})(?=\d)/g, "$1" + thousands) + (decimalCount ? decimal + Math.abs(amount - i).toFixed(decimalCount).slice(2) : "");
            } catch (e) {
                console.log(e)
            }
        }

        function sum() {
            var txtFirstNumberValue = document.getElementById('input-order-item-quantity').value;
            var txtSecondNumberValue = document.getElementById('input-order-item-price').value;
            if (txtFirstNumberValue == "")
                txtFirstNumberValue = 0;
            if (txtSecondNumberValue == "")
                txtSecondNumberValue = 0;

            var result = parseInt(txtFirstNumberValue) * parseInt(txtSecondNumberValue);
            if (!isNaN(result)) {
                document.getElementById('input-order-item-total').value = result;
            }

        }

        function checkPrice() {
            var total = document.getElementById('input-order-item-total').value;
            var wallet = Math.trunc(document.getElementById('wallet').value);
            var credit = Math.trunc(document.getElementById('credit').value);
            var credited = Math.trunc(document.getElementById('input-order-item-credited').value);
            var e = document.getElementById('input-order-item-financing');
            var finance = e.selectedIndex;
            var c = "credit";
            var w = "wallet";
            if(finance == 1) {
                if(wallet < total) {
                    alert('Insufficient funds in your wallet');
                }
            } else if(finance == 2) {
                if(credited > 0) {
                    if(credited < total) {
                        alert('Credited amount not sufficient for this order');
                    }
                } else {
                    if(credit < total) {
                        alert('Approved credit not sufficient for this order');
                    }
                }
            }
        }

        $('#input-order-input').on('change', function(){
            var price = $(this).children('option:selected').data('price');
            $('#price').val(price);
        });

        //wallet bal
        // $('#wallet_id').on('change', function(){
        //     var float = $(this).children('option:selected').data('float');
        //     var credit = $(this).children('option:selected').data('credit');
        //     $('#input_order_financing').empty();
        //     $('#input_order_financing').append("<option value=''>-Select Mode-</option><option value='wallet'>Wallet [" + float + "]</option><option value='credit'>Credit[" +credit+ "]</option>");
        $('#input-order-item-farmer-id').on('change', function(){
            var price = $(this).children('option:selected').data('price');
            var credit = $(this).children('option:selected').data('credit');
            var username = $(this).children('option:selected').data('username');
            $('#input-order-item-financing').empty();
            // $('#save-btn').empty();
            $("#credit").empty();
            $("#wallet").empty();
            $("#credit").val(credit);
            $("#wallet").val(price);
            $("#user").val(username);
            if(username) {
                $('#input-order-item-financing').append("<option value=''>- Select -</option><option value='wallet'>Wallet</option><option value='credit'>Credit</option>");
            } else {
                $('#input-order-item-financing').append("<option value=''>- Select -</option><option value='wallet'>Wallet [KSh " + formatMoney(price) + "]</option><option value='credit'>Credit [KSh "+formatMoney(credit) +"]</option>");
            }
            // $('#save-btn').append("'<input type='text' id='user1' placeholder='confirm username'> <input type='hidden' id='user'><button class='btn btn-info'>Confirm</button>");
        });

        //agro
        // $('#input-order-item-farmer-id').on('change', function(){
        //     var limit = $(this).children('option:selected').data('limit');
        //     var wallet = $(this).children('option:selected').data('wallet');
        //     $('#input-order-item-financing').empty();

        //     $("#credit").val(limit);
        //     $("#wallet").val(wallet);
        //     $('#input-order-item-financing').append("<option value=''>-Select Mode-</option><option value='wallet'>Wallet</option><option value='credit'>Credit</option>");
        // });
        ///show save for agro

        $('#user1').focusout(function(username,user){
            $("#user1").empty();
            var username = $("#user").val();
            var user = $("#user1").val();

            if(username == user) {
                $('#save-btn').empty();
                $('#save-btn').append("<button type='submit' id='input-order-item-save' onclick='checkPrice();' class='btn btn-primary btn-round btn-md' value='create-input-order-item'><i class='fa fa-check'></i> Save</button>");
            } else {
                $("#user1").css("background-color", "pink");
            }
        });

        //confirm after credit approval
        $('#userconfirm').focusout(function(uname,uconfirm){
            $("#userconfirm").empty();
            var uname = $("#uname").val();
            var uconfirm = $("#userconfirm").val();

            if(uname = uconfirm) {
                $('#save-button').empty();
                $('#save-button').append("<button type='submit' name='approveitem' class='btn btn-warning btn-round btn-md'><i class='fas fa-check-double'></i> Approve</button>");
            } else {
                $("#userconfirm").css("background-color", "pink");
            }
        });

        //input seller
        // $('#input-order-input').on('change', function() {
        //     var  id = $(this).children('option:selected').data('seller-id');
        //     var  org = $(this).children('option:selected').data('seller');
        //     $('#input-order-item-input-item-id').empty();
        //     $('#input-order-item-input-item-id').append("<option value=''>-Select Input Seller-</option><option value='" +id+ "'>" + org + "</option>");
        // });

        $(document).ready(function () {
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });

            function clearOrderForm() {
                $('#input-order-form').trigger("reset");
                $('#input-order-item-id').val('');
                $('#input-order-item-directed-to').val('');
                $('#input-order-item-total').val('');
                $('#input-order-item-farmer-id').val('').trigger('change');
                $('#input-order-item-farmer-id').prop('disabled', false);
                $('#input-order-item-farmer-id-hidden').val('')
                $('#input-order-item-farmer-id-hidden').prop('disabled', true);
                $('#input-order-item-input-id').val('').trigger('change');
                $('#input-order-item-input-item-id').empty()
                    .append(
                        $('<option />')  // Create new <option> element
                            .text("- Select -") // Set textContent
                            .val('')
                            .prop('selected', true)
                    );
                $('#input-order-item-quantity').val('');
                $('#input-order-item-price').val('0');
                $('#input-order-item-financing').val('').trigger('change');
                $('#input-order-item-expected-date').val('');
                $('#input-order-item-description').val('');

                $("#order-panel").collapse("hide")
            }

            $('#input-order-item-farmer-id, #input-order-item-input-id, #input-order-item-input-item-id').select2({
                dropdownParent: $('body')
            });

            $('#input-order-items-list').DataTable({
                "order": [[ 0, "desc" ]]
            });

            $('body').on('click', '#input-order-item-cancel', function (e) {
                clearOrderForm();
            });

            $('body').on("select2:select","#input-order-item-input-id", function(e) {
                let input_item_select = $('#input-order-item-input-item-id');
                input_item_select
                    .empty()
                    .append(
                        $('<option />')  // Create new <option> element
                            .text("- Select -") // Set textContent
                            .prop('selected', true)
                    );

                var selected = e.params.data;

                $.ajax({
                    url: '/input_orders/get-input-items/' + selected.id,
                    dataType: 'json',
                    type: "GET",
                    success: function (data) {
                        $('#input-order-selected-quantity').text('');
                        $('#input-order-item-quantity').val('');
                        $('#input-order-item-price').val('');
                        $('#input-order-item-total').val('');

                        $.each(data, function (key, datum) {
                            console.log(datum.input);
                            input_item_select
                                .append($('<option />')  // Create new <option> element
                                .val(datum.id)            // Set value as "Hello"
                                .text(datum.trader.organisation_name+' - '+datum.name) // Set textContent as "Hello"
                                .data({                  // Set multiple data-* attributes
                                    price: datum.price_per_unit,
                                    units: datum.price_per_unit+' /'+datum.input_unit.abbreviation,
                                    trader_id: datum.trader_id
                                })
                            );
                        })
                    },
                    error: function (data) {
                        console.log('Error:', data);
                    }
                });
            });

            $('body').on("select2:select", "#input-order-item-input-item-id", function(e) {
                $('#input-order-item-price').val('');
                $('#input-order-selected-quantity').text('');

                let price = $(this).find(':selected').data('price');
                let units = $(this).find(':selected').data('units');
                let trader_id = $(this).find(':selected').data('trader_id');

                if(price !== undefined) $('#input-order-item-price').val(price);
                if(units !== undefined) $('#input-order-selected-quantity').text('('+units+')');
                if(trader_id !== undefined) $('#input-order-item-directed-to').val(trader_id);

                if($('#input-order-item-quantity').val()) {
                    $('#input-order-item-quantity').trigger("keyup");
                }
            });

            $('body').on('click', '#edit-input-order-item', function (e) {
                e.preventDefault();

                var input_order_item_id = $(this).data('id');

                $.get('/input_orders/' + input_order_item_id +'/edit-ajax', function (data) {
                    // var t = data.expected_date.split(/[- :]/);
                    // expected_date = [t[0], t[1], t[2]].join('-');

                    var input_item_option = new Option(data.input.name, data.input_item_id, true, true);

                    $('#input-order-item-save').val("edit-input-order-item");
                    $('#input-order-form').trigger("reset");
                    $('#input-order-item-id').val(data.id);
                    $('#input-order-item-directed-to').val(data.directed_to);
                    $('#input-order-item-total').val(data.price);
                    $('#input-order-item-farmer-id').val(data.farmer_id).trigger('change');
                    $('#input-order-item-farmer-id').prop('disabled', true);
                    $('#input-order-item-farmer-id-hidden').prop('disabled', false);
                    $('#input-order-item-farmer-id-hidden').val(data.farmer_id)
                    $('#input-order-item-input-id').val(data.input.input.id).trigger('change');
                    $('#input-order-item-input-item-id').append(input_item_option).trigger('change');
                    $('#input-order-item-quantity').val(data.quantity);
                    $('#input-order-item-price').val(data.input.price_per_unit);
                    $('#input-order-item-financing').val(data.financing).trigger('change');
                    // $('#input-order-item-expected-date').val(expected_date);
                    // $('#input-order-item-description').val(data.description);

                    // $('#input-order-item-credited').val(data.crs[0].credited_amount);
                    // $('#credited-amts').append('Credited Amt.<input type="text" disabled id="input-order-item-crediteds">');
                    // $('#input-order-item-crediteds').val(formatMoney(data.crs[0].credited_amount));
                    // $('#input-order-item-credit').val(data.crs[0].credited_amount);

                    $("#order-panel").collapse("show")
                    $('html, body').animate({ scrollTop: $('body').offset().top }, 500, 'linear' );
                })
                .fail(function (jqXHR, textStatus, errorThrown) {
                    // console.warn(xhr.responseText)
                    console.log(JSON.stringify(jqXHR));
                    console.log("AJAX error: " + textStatus + ' : ' + errorThrown);
                    $('#produce-item-modal-save').html('Save');
                })
            });

            // delete
            $('body').on('click', '#delete-input-order-item', function (e) {
                e.preventDefault();

                var item_id = $(this).data("id");
                var confirmDelete = confirm("Are you sure want to delete?");
                if (confirmDelete) {
                    $.ajax({
                        type: "DELETE",
                        url: '/input_orders/' + item_id + '/delete-ajax',
                        success: function (data) {
                            console.log(data);
                            $("#input_order_item_id_" + data.order_item.id).fadeOut(300, function() {
                                $("#input_order_item_id_" + data.order_item.id).remove();
                            });

                            if(data.notification) showNotification(data.notification);
                        },
                        error: function (data) {
                            console.log('Error:', data);
                        }
                    });
                }
            });

            // approve
            $('body').on('click', '#approve-input-order', function(e) {
                e.preventDefault();
                let input_order_id = $(this).data('id');

                $.ajax({
                    data: { id: input_order_id },
                    url: '/input_orders/approve-ajax',
                    type: "POST",
                    dataType: 'json',
                    success: function (data) {
                        $("#approval-badge-main").text('In Process').removeClass('badge-danger').addClass('badge-warning');
                        $("#approve-input-order, #add-order-item, #order-panel").fadeOut(300, function() {
                            $("#approve-input-order").remove();
                            $("#add-order-item").remove();
                            $("#order-panel").remove();
                        });

                        if(data.notification) showNotification(data.notification);

                        var redirect_url = "<?php echo e(Request::url()); ?>";
                        setTimeout(function(){ $(location).attr('href', redirect_url); }, 2000);
                    },
                    error: function (jqXHR, textStatus, errorThrown) {
                        // console.warn(xhr.responseText)
                        console.log(JSON.stringify(jqXHR));
                        console.log("AJAX error: " + textStatus + ' : ' + errorThrown);
                        $('#modal-save').html('Save');
                    }
                });
            });

            // store input-order (after create or edit)
            if ($("#input-order-form").length > 0) {
                $("#input-order-form").validate({
                    submitHandler: function(form) {
                        let formData = $('#input-order-form').serialize();
                        var actionType = $('#input-order-item-save').val();
                        $('#input-order-item-save').html('Saving...');

                        $.ajax({
                            data: formData,
                            url: '/input_orders/store-ajax',
                            type: "POST",
                            dataType: 'json',
                            success: function (data) {
                                var approved = data.order_item.approved == 0 ? '<span class="badge badge-danger">Pending Financing</span>' : '';
                                var fullname = data.order_item.farmer.firstname + ' ' + data.order_item.farmer.lastname;
                                var input_order_item = '<tr id="input_order_item_id_' + data.order_item.id + '"><td><a href="#">' + data.order_item.id + '</a></td>';
                                    input_order_item += '<td>' + fullname + '</td><td><h5>'+ data.order_item.input.name +'</h5><b>Seller:</b> '+ data.order_item.input.trader.organisation_name +'<br><b>Quantity:</b> ' + data.order_item.quantity + ' ' + data.order_item.input.input_unit.abbreviation + '<br><b>Price:</b> '+ data.order_item.input.price_per_unit +' /'+ data.order_item.input.input_unit.abbreviation +'</td><td class="text-center">'+ data.order_item.financing.toUpperCase() +'</td><td class="text-right">' + data.order_item.price + '</td>';
                                    input_order_item += data.order_item.approved == 0 && data.order_item.orders.approved != 0 ? '<td class="text-center"><span class="badge badge-danger">Pending Financing</span></td>' : '';
                                    input_order_item += '<td class="text-right"><div class="btn-group form-actions" role="group" aria-label="Actions">';
                                    input_order_item += '<button type="submit" id="edit-input-order-item" class="btn btn-primary btn-sm" data-toggle="tooltip" title="Edit" data-original-title="Edit" data-id="'+ data.order_item.id +'"><i class="fa fa-edit"></i> Edit</button>';
                                    input_order_item += '<button type="submit" id="delete-input-order-item" class="btn btn-danger btn-sm" data-toggle="tooltip" title="Delete" data-original-title="Delete" data-id="'+ data.order_item.id +'"><i class="far fa-trash-alt"></i> Delete</button>';
                                    input_order_item += '</div></td></tr>';

                                if (actionType == "create-input-order-item") {
                                    $('#input-order-item-list').prepend(input_order_item);
                                } else {
                                    $("#input_order_item_id_" + data.order_item.id).replaceWith(input_order_item);
                                }

                                if(data.notification) showNotification(data.notification);

                                if(data.first_item === true) {
                                    var redirect_url = "<?php echo e(Request::url()); ?>";
                                    setTimeout(function(){ $(location).attr('href', redirect_url); }, 2000);
                                } else {
                                    clearOrderForm();
                                    $('#input-order-item-save').html('Save');

                                    $('html, body').animate({ scrollTop: $('#input-order-items-list').offset().top }, 500, 'linear' );
                                    setTimeout(function() {
                                        $('#input_order_item_id_' + data.order_item.id).effect("highlight", {}, 4000);
                                    }, 500);
                                }
                            },
                            error: function (jqXHR, textStatus, errorThrown) {
                                // console.warn(xhr.responseText)
                                console.log(JSON.stringify(jqXHR));
                                console.log("AJAX error: " + textStatus + ' : ' + errorThrown);
                                $('#input-order-item-save').html('Save');
                            }
                        });
                    }
                });
            }

            function hasQueryString() {
                // get the current URL
                var currentUrl = window.location.href;
                // regex pattern for detecting ? character
                var pattern = new RegExp(/\?.+=.*/g);
                return pattern.test(currentUrl);
            }

            $( document ).ready(function() {
                if(hasQueryString()) {
                    var urlParams = new URLSearchParams(location.search);
                    let exportURL = $('#input-order-items-export').attr('href');
                    exportURL += '?' + urlParams.toString();
                    $('#input-order-items-export').attr('href', exportURL);

                    $('#filter-panel').collapse("show");
                    $("#filter-msg").removeClass('d-none');

                    $('#filter-farmer-name').val(urlParams.get('farmer_name'));
                    $('#filter-seller-name').val(urlParams.get('seller_name'));
                    $('#filter-input').val(urlParams.get('input')).trigger('change');
                    $('#filter-status').val(urlParams.get('status')).trigger('change');
                    $('#filter-financing').val(urlParams.get('financing')).trigger('change');
                    $('#filter-price-less-than').val(urlParams.get('price_less_than'));
                    $('#filter-price-more-than').val(urlParams.get('price_more_than'));
                }
            });
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.site', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/mobigrow/public_html/twalisha.com/trading/public/resources/views/input_orders/details.blade.php ENDPATH**/ ?>