<?php $__env->startSection('title'); ?>
BTCotton | Input Deliveries
<?php $__env->stopSection(); ?>

<?php $__env->startSection('header'); ?>
    <div class="page-header">
        <h4 class="page-title">Input Deliveries</h4>
        
        <ul class="breadcrumbs">
            <li class="nav-home">
                <a href="#" class="btn btn-icon btn-sm btn-round btn-light">
                    <i class="flaticon-home"></i>
                </a>
            </li>
            <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
                                        <th class="text-right" style="width: 10%">Action</th>
                                    </tr>
                                </thead>
                                <tfoot>
                                    <tr>
            <li class="nav-item">
                <a href="#">Invoices</a>
            </li>
            
        </ul>

    </div>
    <div class="ml-md-auto py-2 py-md-0">
        <a href="<?php echo e(URL::previous()); ?>" class="btn btn-white btn-round btn-sm ml-1">
            <i class="fas fa-caret-left"></i> Back
        </a>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="row row-card-no-pd mt--2">
        <div class="col-md-12">
            <div class="card">
                <div class="card-body">
                    <?php echo $__env->make('layouts._messages', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                    <?php if($deliveries->count()): ?>
                        <div class="table-responsive">
                        <table id="inputs-list" class="display table table-striped table-hover" >

<thead>
    <tr>
        <th>Order Ref No#</th>
        <?php if(Auth::user()->isAdmin()): ?>
        <th>From</th>
        <th>To</th>
        <?php endif; ?>
        <th>Picked/Delivered By</th>
        <th>Mode of Delivery</th>
        <th>Date Transported</th>
        <th>Expected Date</th>
        <th>Status</th>

        <th>Actions</th>

        </tr>
</thead>
<tbody id="input-list">
    <?php $__currentLoopData = $deliveries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $delivery): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <tr id="<?php echo e($delivery->id); ?>">
            <td><a href="#" title="View Acknowledgement" data-original-title="View Acknowledgement" data-id=""data-toggle="modal" data-target="#viewItems-<?php echo e($delivery->id); ?>">
             <?php echo e($delivery->order_id); ?>

            </a></td>
            <?php if(Auth::user()->isAdmin()): ?>
            <td><?php echo e($delivery->inputOrderItemsRelease->organisation_name); ?></td>
            <td><?php echo e($delivery->inputOrders->trader->organisation_name); ?></td>
            <?php endif; ?>
            <td><?php echo e($delivery->recipient); ?></td>
            <td><?php echo e($delivery->means); ?></td>
            <td><?php echo e(Str::limit($delivery->created_at,10,'.')); ?></td>
            <td><?php echo e(Str::limit($delivery->date,10,'.')); ?></td>
            <td>
            <?php if($delivery->status == 2): ?>
                <span class="badge badge-black">Received</span>
                <?php elseif($delivery->status == 1): ?>
                <span class="badge badge-warning">Released</span>
                <?php else: ?>
                <span class="badge badge-danger">Pending</span>
            <?php endif; ?>
            </td>

            <td>
            <?php if(Auth::user()->isAdmin() || Auth::user()->getRelatedTrader()->isFarmerOrganisation()): ?>
            <?php if($delivery->status < 2): ?>
            <button type="button" class="btn btn-info btn-sm" title="Confirm" data-original-title="Confirm" data-id=""data-toggle="modal" data-target="#confirm-<?php echo e($delivery->id); ?>">
                                                            <i class="fas fa-truck-moving"></i> Confirm Receipt
                                                        </button>
            <?php elseif($delivery->status === 2): ?>
            <button type="button" class="btn btn-success btn-sm" title="View Acknowledgement" data-original-title="View Acknowledgement" data-id=""data-toggle="modal" data-target="#viewAck-<?php echo e($delivery->id); ?>">
              <i class="fas fa-check"></i> View Acknowledgement
            </button>
            <?php endif; ?>
            <?php elseif($delivery->status === 2): ?>
            <button type="button" class="btn btn-success btn-sm" title="View Acknowledgement" data-original-title="View Acknowledgement" data-id=""data-toggle="modal" data-target="#viewAck-<?php echo e($delivery->id); ?>">
              <i class="fas fa-check"></i> View Acknowledgement
            </button>

            <?php endif; ?>
            </td>
    </tr>
                                    <!--Modal Confirm receipt-->
                                    <div class="modal fade" id="confirm-<?php echo e($delivery->id); ?>" tabindex="-1" role="dialog" aria-hidden="true">
                                            <div class="modal-dialog" role="document">
                                                <div class="modal-content">
                                                    <div class="modal-header">
                                                        <h4 class="modal-title">Confirm Receipt | Order Ref#<?php echo e($delivery->id); ?> </h4>
                                                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                            <span aria-hidden="true">&times;</span>
                                                        </button>
                                                    </div>
                                                    <form name="confirm-receipt" method="post" action="<?php echo e(route('deliveries.store')); ?>">
                                                        <?php echo csrf_field(); ?>

                                                        <div class="modal-body">
                                                            <input type="hidden" name="_token" id="token" value="<?php echo e(csrf_token()); ?>">
                                                            <input type="hidden" name="trader_id" value="<?php echo e($delivery->inputOrders->trader->id); ?>">
                                                            <div class="form-group">
                                                                <label for="trader-id">State of input at arrival</label>
                                                                <textarea class="form-control"name="state_of_arrival"></textarea>
                                                                <label for="trader-id">Other Comments</label>
                                                                <textarea name="comment" class="form-control"></textarea>

                                                                <input type="hidden" name="input_order_items_release_id" value="<?php echo e($delivery->id); ?>">
                                                                <input type="hidden" name="order_id" value="<?php echo e($delivery->order_id); ?>">
                                                                <input type="hidden" name="status" value="2">
                                                            </div>

                                                        </div>
                                                        <div class="modal-footer">
                                                            <button type="submit" name="confirm-receipt" class="btn btn-primary btn-round btn-md"><i class="fa fa-check"></i> Save</button>
                                                            <button type="button" class="btn btn-dark btn-round btn-md" data-dismiss="modal">Close</button>
                                                        </div>
                                                    </form>
                                                </div>
                                            </div>
                                        </div>
                                        <!--/end modal confirm receipt-->
                                    <!--Modal view Confirm -->
                                    <div class="modal fade" id="viewAck-<?php echo e($delivery->id); ?>" tabindex="-1" role="dialog" aria-hidden="true">
                                            <div class="modal-dialog" role="document">
                                                <div class="modal-content">
                                                    <div class="modal-header">
                                                        <h4 class="modal-title">Delivery Acknowledgement | Delivery Ref#<?php echo e($delivery->id); ?> </h4>
                                                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                            <span aria-hidden="true">&times;</span>
                                                        </button>
                                                    </div>
                                                    <form name="confirm-receipt" method="post" action="<?php echo e(route('deliveries.store')); ?>">
                                                        <?php echo csrf_field(); ?>
                                                        <div class="modal-body">
                                                            <h3>State of Arrival</h3>
                                                            <?php if($delivery->release->count()): ?>
                                                            <?php echo e($delivery->release[0]->state_of_arrival); ?>

                                                            <?php endif; ?>
                                                            <h3>Other comments</h3>
                                                            <?php if($delivery->release->count()): ?>
                                                            <?php echo e($delivery->release[0]->comment); ?>

                                                            <?php endif; ?>
                                                            <h3>Delivered on</h3>
                                                            <?php if($delivery->release->count()): ?>
                                                            <?php echo e(Str::limit($delivery->release[0]->created_at,10,'.')); ?>

                                                            <?php endif; ?>
                                                        </div>

                                                        <div class="modal-footer">

                                                            <button type="button" class="btn btn-dark btn-round btn-md" data-dismiss="modal">Close</button>
                                                        </div>
                                                    </form>
                                                </div>
                                            </div>
                                        </div>
                                        <!--/end modal view confirm-->
                                        <!--Modal view items -->
                                    <div class="modal fade" id="viewItems-<?php echo e($delivery->id); ?>" tabindex="-1" role="dialog" aria-hidden="true">
                                            <div class="modal-dialog" role="document">
                                                <div class="modal-content">
                                                    <div class="modal-header">
                                                        <h4 class="modal-title">Input Order Items  | Delivery Ref#<?php echo e($delivery->id); ?> </h4>
                                                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                            <span aria-hidden="true">&times;</span>
                                                        </button>
                                                    </div>
                                                    <form name="confirm-receipt" method="post" action="<?php echo e(route('deliveries.store')); ?>">
                                                        <?php echo csrf_field(); ?>
                                                        <div class="modal-body">

                                                            <?php $__currentLoopData = $delivery->inputOrders->orderItems; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <?php echo e($item->input->name); ?> | <?php echo e($item->quantity); ?> <?php echo e($item->input->input_unit->abbreviation); ?><br>
                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                        </div>

                                                        <div class="modal-footer">

                                                            <button type="button" class="btn btn-dark btn-round btn-md" data-dismiss="modal">Close</button>
                                                        </div>
                                                    </form>
                                                </div>
                                            </div>
                                        </div>
                                        <!--/end modal view items-->
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
</tbody>
<tfoot>
    <tr>
        <th>Order Ref No#</th>
        <?php if(Auth::user()->isAdmin()): ?>
        <th>From</th>
        <th>To</th>
        <?php endif; ?>
        <th>Picked/Delivered By</th>
        <th>Mode of Delivery</th>
        <th>Date Transported</th>
        <th>Expected Date</th>
        <th>Status</th>
        <?php if(Auth::user()->isAdmin() || Auth::user()->getRelatedTrader()->isFarmerOrganisation()): ?>
        <th>Actions</th>
        <?php endif; ?>
    </tr>
</tfoot>
</table>
                        </div>
                    <?php else: ?>
                        <?php echo $__env->make('layouts._nodata', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    <?php endif; ?>
                </div>
            </div>


        </div>
    </div>


<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>
<script>
$(document).ready(function () {
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });

            $('#inputs-list').DataTable({
                "order": [[ 0, "desc" ]]
            });
        });
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.site', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/spinmobisky/public_html/btcotton/resources/views/deliveries/index.blade.php ENDPATH**/ ?>