<?php $__env->startSection('title'); ?>
BTCotton | Farmers
<?php $__env->stopSection(); ?>

<?php $__env->startSection('header'); ?>
    <div class="page-header">
        <h4 class="page-title"><?php if($selectedtrader->count()): ?> <?php echo e($selectedtrader[0]); ?> <?php else: ?> <?php echo e('All'); ?> <?php endif; ?> Farmers</h4>
        
        <ul class="breadcrumbs">
            <li class="nav-home">
                <a href="#">
                    <i class="flaticon-home"></i>
                </a>
            </li>
            <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="#">Farmers</a>
            </li>
            
        </ul>
    </div>
    <div class="ml-md-auto py-2 py-md-0">
        <a href="<?php echo e(URL::previous()); ?>" class="btn btn-white btn-round btn-sm ml-1">
            <i class="fas fa-caret-left"></i> Back
        </a>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="row row-card-no-pd mt--2">
        <div class="col-md-12">
            <div class="card">
            <div id="vueapp">
                <div class="card-body">
                    <?php echo $__env->make('layouts._messages', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                    <?php if($allfarmers->count()): ?>
                        <!-- end advisories -->
                        <!-- button -->
                        <div class="text-right text-white mb-3 border-bottom pb-3">
                            <a class="btn btn-success btn-sm btn-round btn-border" data-toggle="collapse" data-target="#filter-panel">
                                <i class="fa fa-filter"></i> Filter
                            </a>
                            <!-- <a class="btn btn-info btn-round" data-toggle="collapse" data-target="#advisory-panel">
                                <i class="fa fa-comments"></i> Sent Text Question
                            </a> -->

                        </div>
                        
                        <!-- content -->
                        <!-- filter -->
                        <div id="filter-panel" class="collapse filter-panel mb-2">
                            <div class="panel panel-default bg-light p-3">
                                <div class="panel-body">
                                    <form class="form" role="form">
                                        <div class="row">
                                            <div class="form-group col-xs-3 col-md-3">
                                                <label class="control-label" for="filter-name">FO</label>
                                                <select name="trader" id="filter-trader" class="form-control">
                                                    <option value="">All</option>
                                                    <?php $__currentLoopData = $fos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $fo): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <option value="<?php echo e($fo->id); ?>"><?php echo e($fo->organisation_name); ?></option>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </select>
                                            </div>
                                            
                                        </div>
                                        <div class="row">
                                            <div class="col">
                                                <button type="submit" id="filter-submit" class="btn btn-primary btn-round btn-sm">
                                                    <i class="fas fa-filter"></i> Filter
                                                </button>
                                                <a href="" class="btn btn-primary btn-round btn-border btn-sm">Clear</a>
                                            </div>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                        <!-- group messages -->
                        <div id="advisory-panel" class="collapse advisory-panel mb-2">
                            <div class="panel panel-default bg-light p-3">
                            <h3>Recipients: <?php echo e($allfarmers->count()); ?></h3>
                                <div class="panel-body row">
                                    <div class="col-md-6">
                                    <!-- sms -->
                                        <textquestion-component :farmer="<?php echo e(json_encode($allfarmers)); ?>"/>
                                    <!-- /end sms -->
                                    </div>
                                    <div class="col-md-6">
                                    <!-- ivr -->
                                        <audioquestionivr-component :farmer="<?php echo e(json_encode($allfarmers)); ?>"/>
                                    <!-- /end ivr -->
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- end send advisories -->
                        <div class="table-responsive">
                      <table id="farmer-users-list" class="display table table-striped table-hover" >
                                <thead>
                                    <tr>
                                    <th>Farmer </th>
                                        <th>Organization</th>
                                        <th>Coach</th>
                                        <th>Message</th>
                                        <th class="text-center" style="width: 10%">Action</th>
                                    </tr>
                                </thead>
                                <tfoot>
                                    <tr>
                                        <th>Farmer </th>
                                        <th>Organization</th>
                                        <th>Coach</th>
                                          <th>Message</th>
                                        <th class="text-center">Action</th>
                                            </tr>
                                        </tfoot>
                                        <tbody>
                                            <?php $__currentLoopData = $expert_messages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $expert_message): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <tr>
                                            <td>
                                                <a href="#"><?php echo e($expert_message->farmer_id); ?></a>
                                            </td>
                                            <td>                                           
                                            <?php if($expert_message->TextQuestionOrganization): ?> 
                        <?php echo e($expert_message->TextQuestionOrganization->organisation_name); ?>

                        <?php endif; ?>
                                            
                                            </td>
                                            <td>   <?php if($expert_message->TextQuestionCoach): ?> 
                        <?php echo e($expert_message->TextQuestionCoach->lastname); ?>

                        <?php endif; ?> </td>
                                            <td><?php echo e($expert_message->message); ?></td>
                                            <td>
                                            <div class="form-button-action" role="group" aria-label="Actions">
                                                    <div class="btn-group btn-group-sm"><a href="#" class="btn btn-sm btn-success" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">Actions</a>
                                                        <button type="button" class="btn btn-success btn-sm dropdown-toggle dropdown-toggle-split" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                                            <span class="sr-only">Toggle Dropdown</span>
                                                        </button>
                                                        <ul class="dropdown-menu dropdown-menu-left">
                                                       
                                                 

                                       
                                                    <a class="dropdown-item" href="<?php echo e(route('audioquestion.confirm', $expert_message->id)); ?>"  data-target="#smstext-<?php echo e($expert_message->id); ?>"><i class="fa fa-plus"></i>Confirm</a>
                          
                                                    <a class="dropdown-item" href="#" data-toggle="modal" data-target="#smstext-<?php echo e($expert_message->id); ?>"><i class="fa fa-plus"></i> Send Text Message</a>
                                                 
                                                    <a class="dropdown-item" href="#" data-toggle="modal" data-target="#pestsuvelance-<?php echo e($expert_message->id); ?>"><i class="fa fa-plus"></i> Pest suvelance</a>

                                                    <a class="dropdown-item" href="<?php echo e(route('audioquestion.delete', $expert_message->id)); ?>"  data-target="#smstext-<?php echo e($expert_message->id); ?>"><i class="fa fa-plus"></i>Delete</a>
                                                  
                                                    </div>
                                                </div>
                                            </td>




      <!-- Modal -->
      <div class="modal fade" id="pestsuvelance-<?php echo e($expert_message->id); ?>" tabindex="-1" role="dialog" aria-hidden="true">
                                            <div class="modal-dialog" role="document">
                                                <div class="modal-content">
                                                    <div class="modal-header">
                                                        <h5 class="modal-title">
                                                            Add Pest Suvelance -<?php echo e($expert_message->id); ?>

                                                        </h5>
                                                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                            <span aria-hidden="true">&times;</span>
                                                        </button>
                                                    </div>
                                                        <div class="modal-body">
                                                            
                                                        <pestsuvelance-component :textquestion="<?php echo e(json_encode($expert_message)); ?>"><pestsuvelance-component/>
                                                            
                                                        </div>
                                                </div>
                                            </div>
                                        </div>


                                                        <!-- Modal -->
                                        <div class="modal fade" id="smstext-<?php echo e($expert_message->id); ?>" tabindex="-1" role="dialog" aria-hidden="true">
                                            <div class="modal-dialog" role="document">
                                                <div class="modal-content">
                                                    <div class="modal-header">
                                                        <h5 class="modal-title">
                                                            Send Text Message -<?php echo e($expert_message->id); ?>

                                                        </h5>
                                                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                            <span aria-hidden="true">&times;</span>
                                                        </button>
                                                    </div>
                                                        <div class="modal-body">
                                                            
                                                        <addtextquestionsms-component :textquestion="<?php echo e(json_encode($expert_message)); ?>"><addtextquestionsms-component/>
                                                            
                                                        </div>
                                                </div>
                                            </div>
                                        </div>

                                            <!-- Modal -->
                                            <div class="modal fade" id="ivr-<?php echo e($expert_message->id); ?>" tabindex="-1" role="dialog" aria-hidden="true">
                                                <div class="modal-dialog" role="document">
                                                    <div class="modal-content">
                                                        <div class="modal-header">
                                                            <h5 class="modal-title">
                                                                Send Voice Message -<?php echo e($expert_message->id); ?>

                                                            </h5>
                                                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                                <span aria-hidden="true">&times;</span>
                                                            </button>
                                                        </div>
                                                            <div class="modal-body">
                                                                
                                                            <addivr-component :farmer="<?php echo e(json_encode($expert_message->user)); ?>"><addivr-component/>
                                                                
                                                            </div>
                                                    </div>
                                                </div>
                                            </div>

                             <!--sms modal-->

                            
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>


                            </div>  
                    <?php else: ?>
                        <?php echo $__env->make('layouts._nodata', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    <?php endif; ?>
                                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
    <script>
        $(document).ready(function () {
            $('#farmer-users-list').DataTable({
                "order": [[ 0, "desc" ]]
            });
        });
        /*display the farmerproducemodal with the farmerid*/
        $(document).on('click','#addproducelink',function(){
                var farmerid = $(this).data('farmer-id');
                var farmerorganisation = $(this).data('org-id');
                var fid=$("#farmerid").val(farmerid);
                var org=$("#organisationid").val(farmerorganisation);


        });

         /*display the walletmodal with the farmerid*/
         $(document).on('click','#addwalletlink',function(){
                var farmerid = $(this).data('farmer-id');
                var farmerorganisation = $(this).data('org-id');
                var fid=$("#userid").val(farmerid);
                var org=$("#orgid").val(farmerorganisation);


        });

    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.site', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/spinmobisky/public_html/btcotton/resources/views/tagged/index.blade.php ENDPATH**/ ?>