<?php $__env->startSection('title'); ?>
    Twalisha Trading | Produce Categories
<?php $__env->stopSection(); ?>

<?php $__env->startSection('header'); ?>
    <div class="page-header">
        <h4 class="page-title">Produce Categories</h4>
        
        <ul class="breadcrumbs">
            <li class="nav-home">
                <a href="#" class="btn btn-icon btn-sm btn-round btn-light">
                    <i class="flaticon-home"></i>
                </a>
            </li>
            <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="#">Produces</a>
            </li>
            <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="#">Categories</a>
            </li>
        </ul>

    </div>
    <div class="ml-md-auto py-2 py-md-0">
        <a id="create-produce-category" href="<?php echo e(route('produce-categories.create')); ?>" class="btn btn-primary btn-round btn-sm">
            <i class="fa fa-plus"></i> Add Produce Category
        </a>

        <a href="<?php echo e(URL::previous()); ?>" class="btn btn-white btn-round btn-sm ml-1">
            <i class="fas fa-caret-left"></i> Back
        </a>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="row row-card-no-pd mt--2">
        <div class="col-md-12">
            <div class="card">
                <div class="card-body">
                    <?php echo $__env->make('layouts._messages', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                    <?php if($produce_categories->count()): ?>
                        <div class="table-responsive">
                            <table id="produce-categories-list" class="display table table-striped table-hover" >
                                <thead>
                                    <tr>
                                        <th>Name</th>
                                        <th>Description</th>
                                        <th>Parent</th>
                                        <th class="text-right">Actions</th>
                                    </tr>
                                </thead>
                                <tfoot>
                                    <tr>
                                        <th>Name</th>
                                        <th>Description</th>
                                        <th>Parent</th>
                                        <th class="text-right">Actions</th>
                                    </tr>
                                </tfoot>
                                <tbody id="produce-category-list">

                                    <?php $__currentLoopData = $produce_categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $produce_category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr id="produce_category_id_<?php echo e($produce_category->id); ?>">
                                            <td><a href="<?php echo e($produce_category->url); ?>"><?php echo e($produce_category->name); ?></a></td>
                                            <td><?php echo e(Str::limit($produce_category->description, '100')); ?></td>
                                            <td><?php echo e(isset($produce_category->parent) ? $produce_category->parent->name : ''); ?></td>
                                            <td class="text-right">
                                                <div class="btn-group form-actions" role="group" aria-label="Actions">
                                                    <a id="edit-produce-category" href="<?php echo e(route('produce-categories.edit', $produce_category->id)); ?>" class="btn btn-primary btn-sm" data-toggle="tooltip" title="Edit" data-original-title="Edit" data-id="<?php echo e($produce_category->id); ?>">
                                                        <i class="fa fa-edit"></i> Edit
                                                    </a>
                                                    <button id="delete-produce-category" type="submit" class="btn btn-danger btn-sm" data-toggle="tooltip" title="Delete" data-original-title="Delete" data-id="<?php echo e($produce_category->id); ?>">
                                                        <i class="far fa-trash-alt"></i> Delete
                                                    </button>
                                                </div>
                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>
                    <?php else: ?>
                        <?php echo $__env->make('layouts._nodata', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>

    <!-- Modal -->
    <div class="modal fade" id="crud-modal" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title" id="modal-title"></h4>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form id="produce-category-form" name="produce-category-form" method="post">
                    <div class="modal-body">
                        <input type="hidden" name="id" id="produce-category-id">
                        <input type="hidden" name="_token" id="token" value="<?php echo e(csrf_token()); ?>">
                        <div class="form-group">
                            <label for="produce-category-name">Name</label>
                            <input type="text" name="name" id="produce-category-name" value="" class="form-control" placeholder="Name" autofocus>
                        </div>
                        <div class="form-group">
                            <label for="produce-category-description">Description</label>
                            <textarea name="description" id="produce-category-description" class="form-control"></textarea>
                        </div>
                        <div class="form-group">
                            <label for="produce-category-parent-id">Parent Category</label>
                            <select id="produce-category-parent-id" name="parent_id" class="form-control" style="width: 100%; border-color: #ebedf2;">
                                <option value="">- Select -</option>
                                <?php $__currentLoopData = $produce_categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($category->id); ?>"><?php echo e($category->name); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="submit" id="modal-save" class="btn btn-primary btn-round btn-md"><i class="fa fa-check"></i> Save</button>
                        <button type="button" class="btn btn-dark btn-round btn-md" data-dismiss="modal">Close</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
    <script>
        $(document).ready(function () {
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });

            $('#produce-categories-list').DataTable({
                "order": [[ 0, "desc" ]]
            });

            //onclick add
            $('#create-produce-category').click(function(e) {
                e.preventDefault();

                $('#modal-save').val("create-produce-category");
                $('#produce-category-form').trigger("reset");
                $('#produce-category-id').val('');
                $('#produce-category-parent-id').val('').trigger('change');
                $('#modal-title').html("Add Produce Category");
                $('#crud-modal').modal('show');
            });

            // onclick edit
            $('body').on('click', '#edit-produce-category', function (e) {
                e.preventDefault();

                var produce_category_id = $(this).data('id');

                $.get('produce-categories/' + produce_category_id +'/edit-ajax', function (data) {
                    console.log(data);
                    $('#modal-title').html("Edit Produce Category");
                    $('#modal-save').val("edit-produce-category");

                    $('#produce-category-id').val(data.id);
                    $('#produce-category-name').val(data.name);
                    $('#produce-category-description').val(data.description);
                    $('#produce-category-parent-id').val(data.parent_id).trigger('change');
                    $('#crud-modal').modal('show');
                })
                .fail(function (jqXHR, textStatus, errorThrown) {
                    // console.warn(xhr.responseText)
                    console.log(JSON.stringify(jqXHR));
                    console.log("AJAX error: " + textStatus + ' : ' + errorThrown);
                    $('#modal-save').html('Save');
                })
            });

            //onclick delete
            $('body').on('click', '#delete-produce-category', function (e) {
                e.preventDefault();

                var produce_category_id = $(this).data("id");
                var confirmDelete = confirm("Are You sure want to delete?");
                if (confirmDelete) {
                    $.ajax({
                        type: "DELETE",
                        url: 'produce-categories/' + produce_category_id + '/delete-ajax',
                        success: function (data) {
                            $("#produce_category_id_" + produce_category_id).remove();
                            console.log('Success:', data);
                        },
                        error: function (data) {
                            console.log('Error:', data);
                        }
                    });
                }
            });

            //onload modal
            $('#crud-modal').on('shown.bs.modal', function() {
                $('#produce-category-name').trigger('focus');

                $('#produce-category-parent-id').select2({
                    dropdownParent: $('#crud-modal')
                });
            });

            //onsubmit
            if ($("#produce-category-form").length > 0) {
                $("#produce-category-form").validate({
                    submitHandler: function(form) {
                        let formData = $('#produce-category-form').serialize();
                        var actionType = $('#modal-save').val();
                        $('#modal-save').html('Saving...');

                        $.ajax({
                            data: formData,
                            url: '/produce-categories/store-ajax',
                            type: "POST",
                            dataType: 'json',
                            success: function (data) {
                                var long_description = data.description;
                                if (long_description) var short_description = long_description.substring(0, 100);
                                var parent = data.parent != null ? data.parent.name : '';

                                var produce_category = '<tr id="produce_category_id_' + data.id + '"><td><a href="'+ data.url +'">' + data.name + '</a></td>';
                                    produce_category += '<td>' + short_description + '</td><td>' + parent + '</td><td class="text-right"><div class="btn-group form-actions" role="group" aria-label="Actions">';
                                    produce_category += '<a id="edit-produce-category" href="'+ data.url +'/edit" class="btn btn-primary btn-sm" data-toggle="tooltip" title="Edit" data-original-title="Edit" data-id="'+ data.id +'"><i class="fa fa-edit"></i> Edit</a>';
                                    produce_category += '<button id="delete-produce-category" type="submit" class="btn btn-danger btn-sm" data-toggle="tooltip" title="Delete" data-original-title="Delete" data-id="'+ data.id +'"><i class="far fa-trash-alt"></i> Delete</button></div></td></tr>';

                                    // $('#add-row').dataTable().fnAddData([
                                    //     $("#addName").val(),
                                    //     $("#addPosition").val(),
                                    //     $("#addOffice").val(),
                                    //     produce_category
                                    // ]);

                                if (actionType == "create-produce-category") {
                                    $('#produce-category-list').prepend(produce_category);
                                } else {
                                    $("#produce_category_id_" + data.id).replaceWith(produce_category);
                                }

                                $('#modal-save').html('Save');
                                $('#crud-modal').modal('hide');
                            },
                            error: function (jqXHR, textStatus, errorThrown) {
                                // console.warn(xhr.responseText)
                                console.log(JSON.stringify(jqXHR));
                                console.log("AJAX error: " + textStatus + ' : ' + errorThrown);
                                $('#modal-save').html('Save');
                            }
                        });
                    }
                });
            }
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.site', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/mobigrow/public_html/twalisha.com/trading/public/resources/views/produce-categories/index.blade.php ENDPATH**/ ?>