<?php $__env->startSection('title'); ?>
    Twalisha Trading | Counties
<?php $__env->stopSection(); ?>

<?php $__env->startSection('header'); ?>
    <div class="page-header">
        <h4 class="page-title">Counties</h4>
        

        <ul class="breadcrumbs">
            <li class="nav-home">
                <a href="#" class="btn btn-icon btn-sm btn-round btn-light">
                    <i class="flaticon-home"></i>
                </a>
            </li>
            <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="#">Counties</a>
            </li>
            
        </ul>
    </div>
    <div class="ml-md-auto py-2 py-md-0">
        <a id="create-county" href="<?php echo e(route('counties.create')); ?>" class="btn btn-primary btn-round btn-sm">
            <i class="fa fa-plus"></i> Add County
        </a>

        <a href="<?php echo e(URL::previous()); ?>" class="btn btn-white btn-round btn-sm ml-1">
            <i class="fas fa-caret-left"></i> Back
        </a>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="row row-card-no-pd mt--2">
        <div class="col-md-12">
            <div class="card">
                <div class="card-body">
                    <?php echo $__env->make('layouts._messages', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                    <?php if($counties->count()): ?>
                        <div class="table-responsive">
                            <table id="counties-list" class="display table table-striped table-hover" >
                                <thead>
                                    <tr>
                                        <th>Name</th>
                                        <th>Code</th>
                                        <th class="text-center" style="width: 10%">Action</th>
                                    </tr>
                                </thead>
                                <tfoot>
                                    <tr>
                                        <th>Name</th>
                                        <th>Code</th>
                                        <th class="text-center">Action</th>
                                    </tr>
                                </tfoot>
                                <tbody id="county-list">
                                    <?php $__currentLoopData = $counties; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $county): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr id="region_id_<?php echo e($county->id); ?>">
                                            <td><a href="<?php echo e($county->url); ?>"><?php echo e($county->name); ?></a></td>
                                            <td><?php echo e(Str::limit($county->code, '100')); ?></td>
                                            <td>
                                                <div class="btn-group form-actions" role="group" aria-label="Actions">
                                                    <a id="edit-county" href="<?php echo e(route('counties.edit', $county->id)); ?>" class="btn btn-primary btn-sm" data-toggle="tooltip" title="Edit" data-original-title="Edit" data-id="<?php echo e($county->id); ?>">
                                                        <i class="fa fa-edit"></i> Edit
                                                    </a>
                                                    <button id="delete-county" type="submit" class="btn btn-danger btn-sm" data-toggle="tooltip" title="Delete" data-original-title="Delete" data-id="<?php echo e($county->id); ?>">
                                                        <i class="far fa-trash-alt"></i> Delete
                                                    </button>
                                                </div>
                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>
                    <?php else: ?>
                        <?php echo $__env->make('layouts._nodata', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>

    <!-- Modal -->
    <div class="modal fade" id="crud-modal" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title" id="modal-title"></h4>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form id="county-form" name="county-form" method="post">
                    <?php echo csrf_field(); ?>

                    <div class="modal-body">
                        <input type="hidden" name="_token" id="token" value="<?php echo e(csrf_token()); ?>">
                        <input type="hidden" name="id" id="county-id">
                        <div class="form-group">
                            <label for="county-name">Name</label>
                            <input type="text" name="name" id="county-name" class="form-control" placeholder="Name" autofocus>
                        </div>
                        <div class="form-group">
                            <label for="county-code">Code</label>
                            <input type="text" name="code" id="county-code" class="form-control" placeholder="Code">
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="submit" id="modal-save" class="btn btn-primary btn-round btn-md"><i class="fa fa-check"></i> Save</button>
                        <button type="button" class="btn btn-dark btn-round btn-md" data-dismiss="modal">Close</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
    <script>
        $(document).ready(function () {
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });

            $('#crud-modal').on('shown.bs.modal', function() {
                $('#county-name').trigger('focus');
            });

            $('#counties-list').DataTable({
                "order": [[ 0, "desc" ]]
            });

            // create
            $('body').on('click', '#create-county', function(e) {
                e.preventDefault();

                $('#modal-save').val("create-county");
                $('#county-form').trigger("reset");
                $('#county-id').val('');
                $('#county-name').val('');
                $('#county-code').val('');
                $('#modal-title').html("Add County");
                $('#crud-modal').modal('show');
            });

            // edit
            $('body').on('click', '#edit-county', function (e) {
                e.preventDefault();

                var region_id = $(this).data('id');

                $.get('counties/' + region_id +'/edit-ajax', function (data) {
                    console.log(data);
                    $('#modal-title').html("Edit County");
                    $('#modal-save').val("edit-county");

                    $('#county-id').val(data.id);
                    $('#county-name').val(data.name);
                    $('#county-code').val(data.code);
                    $('#crud-modal').modal('show');
                })
                .fail(function (jqXHR, textStatus, errorThrown) {
                    // console.warn(xhr.responseText)
                    console.log(JSON.stringify(jqXHR));
                    console.log("AJAX error: " + textStatus + ' : ' + errorThrown);
                    $('#modal-save').html('Save');
                })
            });

            // delete
            $('body').on('click', '#delete-county', function (e) {
                e.preventDefault();

                var region_id = $(this).data("id");
                var confirmDelete = confirm("Are you sure want to delete?");
                if (confirmDelete) {
                    $.ajax({
                        type: "DELETE",
                        url: 'counties/' + region_id + '/delete-ajax',
                        success: function (data) {
                            $("#region_id_" + region_id).remove();
                            console.log('Success:', data);
                        },
                        error: function (data) {
                            console.log('Error:', data);
                        }
                    });
                }
            });

            // submit
            if ($("#county-form").length > 0) {
                $("#county-form").validate({
                    submitHandler: function(form) {
                        let formData = $('#county-form').serialize();
                        var actionType = $('#modal-save').val();
                        $('#modal-save').html('Saving...');

                        $.ajax({
                            data: formData,
                            url: '/counties/store-ajax',
                            type: "POST",
                            dataType: 'json',
                            success: function (data) {
                                var county = '<tr id="region_id_' + data.id + '"><td><a href="'+ data.url +'">' + data.name + '</a></td>';
                                    county += '<td>' + data.code + '</td><td class="text-right"><div class="btn-group form-actions" role="group" aria-label="Actions">';
                                    county += '<a id="edit-county" href="'+ data.url +'/edit" class="btn btn-primary btn-sm" data-toggle="tooltip" title="Edit" data-original-title="Edit" data-id="'+ data.id +'"><i class="fa fa-edit"></i> Edit</a>';
                                    county += '<button id="delete-county" type="submit" class="btn btn-danger btn-sm" data-toggle="tooltip" title="Delete" data-original-title="Delete" data-id="'+ data.id +'"><i class="far fa-trash-alt"></i> Delete</button></div></td></tr>';

                                    // $('#add-row').dataTable().fnAddData([
                                    //     $("#addName").val(),
                                    //     $("#addPosition").val(),
                                    //     $("#addOffice").val(),
                                    //     county
                                    // ]);

                                if (actionType == "create-county") {
                                    $('#county-list').prepend(county);
                                } else {
                                    $("#region_id_" + data.id).replaceWith(county);
                                }

                                $('#modal-save').html('Save');
                                $('#crud-modal').modal('hide');
                            },
                            error: function (jqXHR, textStatus, errorThrown) {
                                // console.warn(xhr.responseText)
                                console.log(JSON.stringify(jqXHR));
                                console.log("AJAX error: " + textStatus + ' : ' + errorThrown);
                                $('#modal-save').html('Save');
                            }
                        });
                    }
                });
            }
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.site', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/mobigrow/public_html/twalisha.com/trading/public/resources/views/counties/index.blade.php ENDPATH**/ ?>