<?php $__env->startSection('title'); ?>
BTCotton | Financing Requests
<?php $__env->stopSection(); ?>

<?php $__env->startSection('header'); ?>
    <div class="page-header">
        <h4 class="page-title">Credit Requests</h4>
        
        <ul class="breadcrumbs">
            <li class="nav-home">
                <a href="#" class="btn btn-icon btn-sm btn-round btn-light">
                    <i class="flaticon-home"></i>
                </a>
            </li>
            <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="#">Credit Requests</a>
            </li>
            
        </ul>

    </div>
    <div class="ml-md-auto py-2 py-md-0">
        <a href="<?php echo e(URL::previous()); ?>" class="btn btn-white btn-round btn-sm ml-1">
            <i class="fas fa-caret-left"></i> Back
        </a>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-body">
                    <?php echo $__env->make('layouts._messages', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                    <h5 class="text-right"></h5>


                    <?php if($creditwithorders->count()): ?>
                        <div class="table-responsive">
                            <table id="inputs-list" class="display table table-striped table-hover" >

                                <thead>
                                    <tr>
                                        <th>Input Order #ID</th>
                                        <?php if(Auth()->user()->isAdmin()): ?>
                                            <th>Farmer Organization</th>
                                        <?php endif; ?>
                                        <th>Total Requests</th>
                                        <td>Status</td>
                                        <th>Created On</th>
                                        <th>Actions</th>
                                    </tr>
                                </thead>
                                <tfoot>
                                    <tr>
                                        <th>Input Order #ID</th>
                                        <?php if(Auth()->user()->isAdmin()): ?>
                                            <th>Farmer Organization</th>
                                        <?php endif; ?>
                                        <th>Total Requests</th>
                                        <td>Status</td>
                                        <th>Created On</th>
                                        <th>Actions</th>
                                    </tr>
                                </tfoot>
                                <tbody id="input-list">
                                    <?php $__currentLoopData = $creditwithorders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $creditwithorder): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr id="input_order_<?php echo e($creditwithorder->id); ?>">
                                            <td><a href="<?php echo e(route('credit_requests.show', $creditwithorder->id)); ?>"></a><?php echo e($creditwithorder->id); ?></td>
                                            <?php if(Auth()->user()->isAdmin()): ?>
                                                <td><?php echo e($creditwithorder->trader->organisation_name); ?></td>
                                            <?php endif; ?>
                                            <td><?php echo e($creditwithorder->orderItems->where('financing', 'credit')->count('quantity')); ?></td>
                                            <td>
                                                <?php if($creditwithorder->approved == 0): ?>
                                                    <span class="badge badge-black">Pending</span>
                                                <?php elseif($creditwithorder->approved == 1): ?>
                                                    <span class="badge badge-warning">In Process</span>
                                                <?php elseif($creditwithorder->approved == 2): ?>
                                                    <span class="badge badge-success">Completed</span>
                                                <?php endif; ?>
                                            </td>
                                            <td><?php echo e($creditwithorder->created_at); ?></td>
                                            <td><a class="btn btn-sm btn-success" href="<?php echo e(route('credit_requests.show', $creditwithorder->id)); ?>">View Requests
                                                </a></td>

                                    </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>

                            </table>
                        </div>
                    <?php else: ?>
                        <?php echo $__env->make('layouts._nodata', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    <?php endif; ?>
                </div>
                </div>
            </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>
<script>
$(document).ready(function () {
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });

            $('#inputs-list').DataTable({
                "order": [[ 0, "desc" ]]
            });
        });
</script>
<?php $__env->stopSection(); ?>



<?php echo $__env->make('layouts.site', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/spinmobisky/public_html/btcotton/resources/views/credit_requests/index.blade.php ENDPATH**/ ?>