<div class="row mt--2">
    <div class="col-sm-6 col-lg-3">
        <div class="card p-3">
            <div class="d-flex align-items-center">
                <span class="stamp stamp-md bg-danger mr-3">
                    <i class="far fa-address-card"></i>
                </span>
                <div>
                    
                    <h5 class="mb-1"><b><a href="#"> Business plans</a></b></h5>
                    <small class="text-muted"><?php echo e($dashboard['statistics']['plans']); ?></small>
                </div>
            </div>
        </div>
    </div>
    <div class="col-sm-6 col-lg-3">
        <div class="card p-3">
            <div class="d-flex align-items-center">
                <span class="stamp stamp-md bg-secondary mr-3">
                    <i class="fas fa-seedling"></i>
                </span>
                <div>
                    <h5 class="mb-1"><b><a href="#">Season Produce</a></b></h5>
                    <small class="text-muted"> <?php echo e($dashboard['statistics']['produce']); ?></small>
                </div>
            </div>
        </div>
    </div>
    <div class="col-sm-6 col-lg-3">
        <div class="card p-3">
            <div class="d-flex align-items-center">
                <span class="stamp stamp-md bg-success mr-3">
                    <i class="fas fa-random"></i>
                </span>
                <div>
                    <h5 class="mb-1"><b><a href="#"> Livestock Inspections</a></b></h5>
                    <small class="text-muted"> <?php echo e($dashboard['statistics']['livestock']); ?> </small>
                </div>
            </div>
        </div>
    </div>
    <div class="col-sm-6 col-lg-3">
        <div class="card p-3">
            <div class="d-flex align-items-center">
                <span class="stamp stamp-md bg-warning mr-3">
                    <i class="fas fa-cart-arrow-down"></i>
                </span>
                <div>
                    <h5 class="mb-1"><b><a href="#"> Active Farmers</a></b></h5>
                    <small class="text-muted"><?php echo e($dashboard['statistics']['activefarmers']); ?> </small>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-12">
        <div class="card">
            <div class="card-body">
            <div class="text-left">
                Chart
            </div>
            <div id="filter-panelchart" class="collapse filter-panel mb-2">
                    <div class="panel panel-default bg-light p-3">
                        <div class="panel-body">
                            <form class="form" role="form">
                                <div class="row">
                                    <div class="form-group col-xs-3 col-md-3">
                                        <label class="control-label" for="filter-name">Trader</label>
                                        <select name="trader" id="filter-trader" class="form-control">
                                            <option value="">All</option>
                                             <?php $__currentLoopData = $dashboard['fotraders']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $trader): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($trader->id); ?>"><?php echo e($trader->organisation_name); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>
                                    <div class="form-group col-xs-3 col-md-3">
                                        <label class="control-label" for="filter-name">Produce</label>
                                        <select name="produce" id="filter-produce" class="form-control">
                                            <option value="">All</option>
                                             <?php $__currentLoopData = $dashboard['produceitems']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $produceitem): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($produceitem->id); ?>"><?php echo e($produceitem->produce->name); ?>-<?php echo e($produceitem->quality); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col">
                                        <button type="submit" id="filter-submit" class="btn btn-primary btn-round btn-sm">
                                            <i class="fas fa-filter"></i> Filter
                                        </button>
                                        <a href="" class="btn btn-primary btn-round btn-border btn-sm">Clear</a>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
                <div class="text-right mb-3 border-bottom pb-3">
                    <a class="btn btn-success btn-border btn-round btn-sm" data-toggle="collapse" data-target="#filter-panelchart">
                        <i class="fas fa-filter"></i> Filter
                    </a>
                </div>
    
                <div id="filter-msg" class="d-none">
                    <div class="alert alert-info shadow-sm mb-0" role="alert">
                        <p class="mb-0"><i class="fas fa-info-circle"></i> This is a filtered view. <span id="filters"></span></p>
                    </div>
                    <hr>
                </div>
                <div id="chart-container">
                    <?php echo $dashboard['producechart']->container(); ?>

                </div>
            </div>
        </div>
    </div>
    <div class="col-md-12">
        <div class="card">
            <div class="card-body">
                <div class="text-left">
                    Seasons produce
                </div>
                <!--<?php echo $__env->make('_partials.filter-season-produce-items', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>-->
                <div id="filter-panel" class="collapse filter-panel mb-2">
                    <div class="panel panel-default bg-light p-3">
                        <div class="panel-body">
                            <form class="form" role="form">
                                <div class="row">
                                    <div class="form-group col-xs-3 col-md-3">
                                        <label class="control-label" for="filter-name">Trader</label>
                                        <select name="trader" id="filter-trader" class="form-control">
                                            <option value="">All</option>
                                             <?php $__currentLoopData = $dashboard['fotraders']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $trader): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($trader->id); ?>"><?php echo e($trader->organisation_name); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>
                                    <div class="form-group col-xs-3 col-md-3">
                                        <label class="control-label" for="filter-name">Produce</label>
                                        <select name="produce" id="filter-produce" class="form-control">
                                            <option value="">All</option>
                                             <?php $__currentLoopData = $dashboard['produceitems']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $produceitem): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($produceitem->id); ?>"><?php echo e($produceitem->produce->name); ?>-<?php echo e($produceitem->quality); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>
                                    <div class="form-group col-xs-3 col-md-3">
                                        <label class="control-label" for="filter-type">Season</label>
                                        <select name="season" id="filter-season" class="form-control">
                                            <option value="">All</option>
                                            <?php $__currentLoopData = $dashboard['statistics']['seasons']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $season): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($season->season_id); ?>"><?php echo e($season->season); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>
                                    
                                    <div class="form-group col-xs-2 col-md-2">
                                        <label class="control-label" for="pref-perpage">Est. harvest date: From</label>
                                        <input type="date" class="form-control input-sm" name="from" id="filter-from" placeholder="yyyy-mm-dd" value="" min="2019-01-01" max="2030-12-31">
                                    </div>
                                    <div class="form-group col-xs-2 col-md-2">
                                        <label class="control-label" for="pref-search">To</label>
                                        <input type="date" class="form-control input-sm" placeholder="yyyy-mm-dd" name="to" id="filter-to" value="" min="2019-01-01" max="2030-12-31">
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col">
                                        <button type="submit" id="filter-submit" class="btn btn-primary btn-round btn-sm">
                                            <i class="fas fa-filter"></i> Filter
                                        </button>
                                        <a href="" class="btn btn-primary btn-round btn-border btn-sm">Clear</a>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
                <!--/end include-->
                <div class="text-right mb-3 border-bottom pb-3">
                    <a class="btn btn-success btn-border btn-round btn-sm" data-toggle="collapse" data-target="#filter-panel">
                        <i class="fas fa-filter"></i> Filter
                    </a>
                </div>
    
                <div id="filter-msg" class="d-none">
                    <div class="alert alert-info shadow-sm mb-0" role="alert">
                        <p class="mb-0"><i class="fas fa-info-circle"></i> This is a filtered view. <span id="filters"></span></p>
                    </div>
                    <hr>
                </div>
                <!--data-->
                <div class="table-responsive">
                    <strong>Count: </strong> <?php echo e($dashboard['statistics']['seasonproduces']->count()); ?>. 
                    <table id="farmer-users-list" class="display table table-striped table-hover" >
                        <thead>
                            <tr>
                                <th>Org.</th>
                                <th>Produce</th>
                                <th title="Recommended seed">seed</th>
                                <th>Inputs:</th>
                                <th>Sowing:</th>
                                <th>Estimated:</th>
                            </tr>
                        </thead>
                        <tfoot>
                            <tr>
                                <th>Org.</th>
                                <th>Produce</th>
                                <th title="Recommended seed">seed</th>
                                <th>Inputs:</th>
                                <th>Sowing:</th>
                                <th>Estimated:</th>
                            </tr>
                        </tfoot>
                        <tbody>
                            <strong>Total:</strong> <?php echo e(collect($dashboard['statistics']['seasonproduces'])->sum('yield_estimation')); ?> 
                            <?php $__currentLoopData = $dashboard['statistics']['seasonproduces']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $seasonprod): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                             <tr>
                                <td><?php echo e($seasonprod->seasonproduceSeason->soilFarmer->user->traderMember->trader->organisation_name); ?></td> 
                                <td><?php echo e($seasonprod->seasonproduceProduce->produce->name); ?>

                                <strong>Quality:</strong><?php echo e($seasonprod->quality); ?></td> 
                                <td><?php echo e($seasonprod->recommended_seed); ?></td> 
                                <td><b>Fertilizer:</b><?php echo e($seasonprod->fertilizer); ?><br> 
                                    <b>Pesticides:</b> <?php echo e($seasonprod->pesticides); ?></td> 
                                <td><b>Date:</b> <?php echo e($seasonprod->sowing_date); ?><br>
                                    <b>Area:</b> <?php echo e($seasonprod->sowing_area); ?></td> 
                                <td><b>Yields:</b> <?php echo e($seasonprod->yield_estimation); ?><br> 
                                    <b>HarvestDate:</b> <?php echo e($seasonprod->est_harvestdate); ?></td> 
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
                <!--/data-->
            </div>
        </div>
    </div>
    
</div>

<script>
    $(document).ready(function () {
        $('#farmer-users-list').DataTable({
            "order": [[ 0, "desc" ]]
        });
    });
</script><?php /**PATH /home/spinmobisky/public_html/btcotton/resources/views/_partials/dashboard-agent.blade.php ENDPATH**/ ?>