<?php $__env->startSection('title'); ?>
    Twalisha Trading | User - <?php echo e($user->fullname); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('header'); ?>
    <div class="page-header">
        <h4 class="page-title"><?php echo e($user->fullname); ?> - Wallet</h4>
        
        <ul class="breadcrumbs">
            <li class="nav-home">
                <a href="#" class="btn btn-icon btn-sm btn-round btn-light">
                    <i class="flaticon-home"></i>
                </a>
            </li>
            <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="<?php echo e(route('users.index')); ?>">Users</a>
            </li>
            
        </ul>

    </div>
    <div class="ml-md-auto py-2 py-md-0">
        <a href="<?php echo e(route('users.index')); ?>" class="btn btn-white btn-border btn-round btn-sm ml-1">
            <span class="btn-label"><i class="fas fa-caret-left"></i></span> Back
        </a>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="row">
        <div class="col-md-4">
            <div class="card card-profile">
                
                <div class="card-header">
                <div class="profile-picture">
                        <div class="avatar avatar-xl">
                            <img src="<?php echo e(asset('img/profile.jpg')); ?>" alt="..." class="avatar-img rounded-circle">
                        </div>
                    </div>
                </div>
                <div class="card-body">
                    <div class="user-profile text-center">
                        <div class="name"><?php echo e($user->fullname); ?></div>
                        <div class="job">
                            <p><b>Username:</b> <?php echo e($user->username); ?>

                            <br><b>Email:</b> <?php echo e($user->email); ?>

                            <br><b>Phone:</b> <?php echo e($user->phone); ?></p>
                        </div>
                        <div class="view-profile">
                            <a href="#" class="btn btn-primary btn-block">View Full Profile</a>
                        </div>
                    </div>
                </div>
                <div class="card-footer">
                    <div class="row user-stats text-center">
                        <div class="col">
                            <div class="number">-</div>
                            <div class="title">Aggregations</div>
                        </div>
                        <div class="col">
                            <div class="number">KES <?php echo e($user->balance ? number_format(round($user->balance, 2)) : number_format(0)); ?></div>
                            <div class="title">Wallet Balance</div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-8">
            <div class="card">
                <div class="card-header">
                    <h5 class="card-title">Transactions</h5>
                </div>
                <div class="card-body">
                    <?php if($user->transactions->count()): ?>
                        <div class="table-responsive">
                            <table id="users-list" class="display table table-striped table-hover" >
                                <thead>
                                    <tr>
                                        <th>Type</th>
                                        <th>Description</th>
                                        <th>Date</th>
                                        <th class="text-right">Amount (KES)</th>
                                    </tr>
                                </thead>
                                <tfoot>
                                    <tr>
                                        <th>Type</th>
                                        <th>Description</th>
                                        <th>Date</th>
                                        <th class="text-right">Amount (KES)</th>
                                    </tr>
                                </tfoot>
                                <tbody>
                                    <?php $__currentLoopData = $user->transactions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $transaction): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr id="transaction_id_<?php echo e($transaction->id); ?>">
                                            <td><?php echo e(ucfirst($transaction->type)); ?></td>
                                            <td><?php echo e($transaction->meta['description']); ?></td>
                                            <td><?php echo e($transaction->created_at); ?></td>
                                            <td class="text-right"><?php echo e(number_format($transaction->amount, 2)); ?></td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td colspan="3"></td>
                                        <td class="text-right"><?php echo e(number_format($user->balance, 2)); ?></td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    <?php else: ?>
                        <?php echo $__env->make('layouts._nodata', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/mobigrow/public_html/twa-orders/resources/views/users/wallet.blade.php ENDPATH**/ ?>