<?php echo csrf_field(); ?>
<div class="form-group">
    <label for="county-name">Name</label>
    <input type="text" name="name" id="county-name" value="<?php echo e(old('name', $county->name ?? '')); ?>" class="form-control <?php echo e($errors->has('name') ? 'is-invalid' : ''); ?>" placeholder="County Name">

    <?php if($errors->has('name')): ?>
        <div class="invalid-feedback">
            <strong><?php echo e($errors->first('name')); ?></strong>
        </div>
    <?php endif; ?>
</div>
<div class="form-group">
    <label for="county-code">Code</label>
    <input type="text" id="county-code" class="form-control <?php echo e($errors->has('code') ? 'is-invalid' : ''); ?>" value="<?php echo e(old('code', $county->code ?? '')); ?>">

    <?php if($errors->has('code')): ?>
        <div class="invalid-feedback">
            <strong><?php echo e($errors->first('code')); ?></strong>
        </div>
    <?php endif; ?>
</div>
<div class="form-group">
    <button type="submit" class="btn btn-primary btn-lg"><?php echo e($buttonText); ?></button>
</div>
<?php /**PATH /home/mobigrow/public_html/twalisha.com/trading/public/resources/views/counties/_form.blade.php ENDPATH**/ ?>