<?php $__env->startSection('title'); ?>
BTCotton | Financing Requests
<?php $__env->stopSection(); ?>

<?php $__env->startSection('header'); ?>
    <div class="page-header">
        <h4 class="page-title">Credit Requests for Order #<?php echo e($order->id); ?></h4>
        
        <ul class="breadcrumbs">
            <li class="nav-home">
                <a href="#" class="btn btn-icon btn-sm btn-round btn-light">
                    <i class="flaticon-home"></i>
                </a>
            </li>
            <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="<?php echo e(route('credit_requests.index')); ?>">Credit Requests</a>
            </li>
            <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <span>Order #<?php echo e($order->id); ?></span>
            </li>
        </ul>

    </div>
    <div class="ml-md-auto py-2 py-md-0">
        <a href="<?php echo e(URL::previous()); ?>" class="btn btn-white btn-round btn-sm ml-1">
            <i class="fas fa-caret-left"></i> Back
        </a>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-body">
                    <?php echo $__env->make('layouts._messages', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                    <div class="text-right">
                        <a href="<?php echo e(route('export', $order->id)); ?>?id=<?php echo e($order->id); ?>" class="btn btn-info btn-border btn-round btn-sm mr-2">
                            <i class="fa fa-pencil"></i>
                            Export Excel
                        </a>
                        <a href="#" class="btn btn-info btn-border btn-round btn-sm mr-2">
                            <i class="fa fa-print"></i>
                            Print PDF
                        </a>
                    </div>
                    <hr>

                    <?php if($credit->count()): ?>
                        <div class="table-responsive">
                            <table id="inputs-list" class="display table table-striped table-hover" >

                                <thead>
                                    <tr>
                                        <th>ID</th>
                                        <th>Farmer</th>
                                        <th>Requested Amount</th>
                                        <th>Credit Limit</th>
                                        <th>Order Details</th>
                                        <th>Status</th>
                                        <th>Created On</th>
                                        <th>Actions</th>
                                    </tr>
                                </thead>
                                <tbody id="input-list">
                                    <?php $__currentLoopData = $credit; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $credit): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr id="">
                                            <td><a href=""><?php echo e($credit->id); ?></a></td>
                                            <td><?php echo e($credit->user->fullname); ?></td>
                                            <td><?php echo e(number_format($credit->requested_amount, 2)); ?></td>
                                            <td><?php echo e(number_format($credit->user->wallet->credit_limit, 2)); ?></td>
                                            <td>
                                                <b>Input:</b> <?php echo e($credit->inputOrderItems->input->name); ?>

                                                <br><b>Quantity:</b><?php echo e($credit->inputOrderItems->quantity); ?> <?php echo e($credit->inputOrderItems->input->input_unit->abbreviation); ?>

                                            </td>
                                            <td>
                                                <?php if($credit->approved == 0): ?>
                                                    <span class="badge badge-black">Pending</span>
                                                <?php elseif($credit->approved == 1): ?>
                                                    <span class="badge badge-danger">Declined</span>
                                                <?php elseif($credit->approved == 2): ?>
                                                    <span class="badge badge-warning">In Process</span>
                                                <?php elseif($credit->approved == 3): ?>
                                                    <span class="badge badge-success">Approved</span>
                                                <?php endif; ?>
                                            </td>
                                            <td><?php echo e(Str::limit($credit->created_at,10,'.')); ?></td>
                                            <td>
                                            <?php if(Auth::user()->isAdmin()): ?>
                                            <form action="<?php echo e(route('credit_requests.store')); ?>" method="post">

                                            <?php echo csrf_field(); ?>

                                            <input type="hidden" name="uid" value="<?php echo e($credit->user->wallet->id); ?>">
                                            <input type="hidden" name="id" value="<?php echo e($credit->id); ?>">
                                            <input type="hidden" name="credited" value="<?php echo e($credit->requested_amount); ?>">
                                            <input type="hidden" name="io_id" value="<?php echo e($credit->input_order_item_id); ?>">
                                            <?php if($credit->approved == 0): ?>
                                            <div class="btn-group form-group">

                                            <button type="submit" name="process" class="btn btn-sm btn-success">Process</button>


                                            <button type="submit" name="decline" class="btn btn-sm btn-danger">Decline</button>
                                            </div>

                                            <?php elseif($credit->approved == 1): ?>
                                            <div class="btn-group form-group">

                                            <button type="submit" name="accept" class="btn btn-sm btn-success">Accept</button>
                                            </div>

                                            <?php elseif($credit->approved == 2): ?>
                                            <div class="btn-group form-group">

                                            <button type="button" name="approve" class="btn btn-sm btn-warning" title="Approve" data-original-title="Approve" data-id=""data-toggle="modal" data-target="#modal-approve-<?php echo e($credit->id); ?>"><i class="fas fa-check-double"></i> Approve</button>


                                            <button type="submit" name="decline" class="btn btn-sm btn-danger">Decline</button>
                                            </div>
                                            <?php endif; ?>
                                            </form>
                                            <?php endif; ?>
                                            </td>

                                    </tr>
                                    <!--Modal Confirm receipt-->
                                    <div class="modal fade" id="modal-approve-<?php echo e($credit->id); ?>" tabindex="-1" role="dialog" aria-hidden="true">
                                        <div class="modal-dialog" role="document">
                                            <div class="modal-content">
                                                <div class="modal-header">
                                                    <h4 class="modal-title">Approve Credit Request | Ref#<?php echo e($credit->id); ?> </h4>
                                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                        <span aria-hidden="true">&times;</span>
                                                    </button>
                                                </div>
                                                <form name="approve" method="post" action="<?php echo e(route('credit_requests.store')); ?>">
                                                    <?php echo csrf_field(); ?>

                                                    <input type="hidden" name="uid" value="<?php echo e($credit->user->wallet->id); ?>">
                                                    <input type="hidden" name="id" value="<?php echo e($credit->id); ?>">
                                                    <input type="hidden" name="io_id" value="<?php echo e($credit->inputOrderItems->id); ?>">
                                                    <input type="hidden"name="requested_amt" value="<?php echo e(Str::limit($credit->requested_amount,-5,'')); ?>">
                                                    <div class="modal-body">
                                                        <?php
                                                            $user_credits = App\Credits::where('user_id', $credit->user_id)->get();
                                                            $balance = 0;

                                                            foreach($user_credits as $user_credit) {
                                                                $balance += $user_credit->balance;
                                                            }
                                                        ?>

                                                        <div class="alert alert-success shadow-sm">
                                                            <dl class="row">
                                                                <dt class="col-md-5">Requested by:</dt>
                                                                <dd class="col-md-7"><?php echo e($credit->user->fullname); ?></dd>
                                                                <dt class="col-md-5">Farmer Organisation:</dt>
                                                                <dd class="col-md-7"><?php echo e($credit->user->trader->organisation_name); ?></dd>
                                                                <dt class="col-md-5">Credit Limit</dt>
                                                                <dd class="col-md-7">KSh <?php echo e(number_format($credit->user->wallet->credit_limit, 2)); ?></dd>
                                                                <dt class="col-md-5">Requested Amount</dt>
                                                                <dd class="col-md-7">KSh <?php echo e(number_format($credit->requested_amount, 2)); ?></dd>
                                                                <dt class="col-md-5">Pending Loans Total</dt>
                                                                <dd class="col-md-7">KSh <?php echo e($balance); ?></dd>
                                                            </dl>
                                                        </div>
                                                        <div class="form-group">
                                                            <label for="credited_amt" class="mb-0">Credited Amount</label>
                                                            <small class="d-block mb-2 text-italics">Change if approved amount is less than the requested amount</small>
                                                            <input class="form-control" type="text" id="credited_amt" name="credited_amt" value="<?php echo e(Str::limit($credit->requested_amount,-5,'')); ?>">
                                                        </div>
                                                        <div class="form-group">
                                                            <label for="interest">Interest (%)</label>
                                                            <input class="form-control" type="number" id="interest" onkeyup="payable();" name="interest">
                                                        </div>
                                                        <div class="form-group">
                                                            <label for="period">Period (Months)</label>
                                                            <input class="form-control" onkeyup="payable();" type="number" id="period" name="period">
                                                        </div>
                                                        <div class="form-group">
                                                            <label for="payable_amount">Payable Amount</label>
                                                            <input class="form-control" id="payable_amount" name="payable_amount" >
                                                        </div>
                                                    </div>
                                                    <div class="modal-footer">
                                                        <button type="submit" name="approve" class="btn btn-warning btn-round btn-md"><i class="fas fa-check-double"></i> Approve</button>
                                                        <button type="button" class="btn btn-dark btn-round btn-md" data-dismiss="modal">Close</button>
                                                    </div>
                                                </form>
                                            </div>
                                        </div>
                                    </div>
                                    <!--/end modal confirm receipt-->
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                                <tfoot>
                                    <tr>
                                    <th>ID</th>
                                        <th>Farmer</th>
                                        <th>Requested Amount</th>
                                        <th>Credit Limit</th>
                                        <th>Order Details</th>
                                        <th>Status</th>
                                        <th>Created On</th>
                                        <th>Actions</th>
                                    </tr>
                                </tfoot>
                            </table>
                        </div>
                    <?php else: ?>
                        <?php echo $__env->make('layouts._nodata', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    <?php endif; ?>
                </div>
                </div>
            </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
<script>
$(document).ready(function () {
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });

            $('#inputs-list').DataTable({
                "order": [[ 0, "desc" ]]
            });
        });
    function payable()
    {
        var credit = document.getElementById('credited_amt').value;
            var interest = document.getElementById('interest').value;
            if (credit == "")
                credit = 0;
            if (interest == "")
                interest = 0;

            var result = parseInt(credit)+(parseInt(credit) * parseInt(interest))/100;
            if (!isNaN(result)) {
                document.getElementById('payable_amount').value = result;
            }
    }
</script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.site', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/spinmobisky/public_html/btcotton/resources/views/credit_requests/details.blade.php ENDPATH**/ ?>