<?php echo csrf_field(); ?>
<div class="form-group">
    <label for="name">Name</label>
    <input type="text" name="name" id="name" value="<?php echo e(old('name', $produce_unit->name ?? '')); ?>" class="form-control <?php echo e($errors->has('name') ? 'is-invalid' : ''); ?>" placeholder="Produce Unit">

    <?php if($errors->has('name')): ?>
        <div class="invalid-feedback">
            <strong><?php echo e($errors->first('name')); ?></strong>
        </div>
    <?php endif; ?>
</div>
<div class="form-group">
    <label for="abbreviation">Abbreviation</label>
    <input type="text" name="abbreviation" id="abbreviation" value="<?php echo e(old('abbreviation', $produce_unit->abbreviation ?? '')); ?>" class="form-control <?php echo e($errors->has('abbreviation') ? 'is-invalid' : ''); ?>" placeholder="Abbreviation">

    <?php if($errors->has('abbreviation')): ?>
        <div class="invalid-feedback">
            <strong><?php echo e($errors->first('abbreviation')); ?></strong>
        </div>
    <?php endif; ?>
</div>
<div class="form-group">
    <label for="region-description">Description</label>
    <textarea name="description" id="description" class="form-control <?php echo e($errors->has('description') ? 'is-invalid' : ''); ?>" rows="10"><?php echo e(old('description', $produce_unit->description ?? '')); ?></textarea>

    <?php if($errors->has('description')): ?>
        <div class="invalid-feedback">
            <strong><?php echo e($errors->first('description')); ?></strong>
        </div>
    <?php endif; ?>
</div>
<?php if( isset($buttonText) ): ?>
    <div class="form-group">
        <button type="submit" class="btn btn-primary btn-lg"><?php echo e($buttonText); ?></button>
    </div>
<?php endif; ?>
<?php /**PATH /home/mobigrow/public_html/twalisha.com/trading/public/resources/views/produce-units/_form.blade.php ENDPATH**/ ?>