<div class="sidebar sidebar-style-2">
    <div class="sidebar-wrapper scrollbar scrollbar-inner">
        <div class="sidebar-content">
            <div class="user">
                <div class="avatar-sm float-left mr-2">
                    <img src="<?php echo e(asset('img/profile.jpg')); ?>" alt="..." class="avatar-img rounded-circle">
                </div>
                <div class="info">
                    <a data-toggle="collapse" href="#collapseExample" aria-expanded="true">
                        <span>
                            <?php echo e(auth()->user()->fullname); ?>

                            <small><b>Farmer Organisation</b></small>
                            <span class="caret"></span>
                        </span>
                    </a>
                    <div class="clearfix"></div>

                    <div class="collapse in" id="collapseExample">
                        <ul class="nav">
                            <li>
                                <a href="#profile">
                                    <span class="link-collapse">My Profile</span>
                                </a>
                            </li>
                            <li>
                                <a href="#edit">
                                    <span class="link-collapse">Edit Profile</span>
                                </a>
                            </li>
                            <li>
                                <a href="#settings">
                                    <span class="link-collapse">Settings</span>
                                </a>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
            <ul class="nav nav-warning">
                <li class="nav-item <?php echo e((request()->is('dashboard')) ? 'active' : ''); ?>">
                    <a href="<?php echo e(url('dashboard')); ?>">
                        <i class="fas fa-home"></i>
                        <p>Dashboard</p>
                        
                    </a>
                </li>
                
                    <li class="nav-item <?php echo e((request()->type=='trader*') ? 'active' : ''); ?>">
                        <a href="<?php echo e(route('traders.profile')); ?>">
                            <i class="far fa-building"></i>
                            <p>My Organisation</p>
                            
                        </a>
                    </li>
                
                
                    <li class="nav-item <?php echo e((request()->type=='produce-aggregation*') ? 'active' : ''); ?>">
                        <a href="<?php echo e(route('produce-aggregations.index')); ?>">
                            <i class="fas fa-random"></i>
                            <p>Aggregation</p>
                            
                        </a>
                    </li>
                    <li class="nav-item <?php echo e((request()->is('produce-collection*') || request()->is('my-deliveries*')) ? 'active' : ''); ?>">
                        <a data-toggle="collapse" href="#produce-collections-app-nav" aria-expanded="<?php echo e((request()->is('produce-collection*') || request()->is('my-deliveries*')) ? 'true' : 'false'); ?>">
                            <i class="fas fa-layer-group"></i>
                            <p>Collection</p>
                            <span class="caret"></span>
                        </a>
                        <div class="collapse <?php echo e((request()->is('produce-collection*') || request()->is('my-deliveries*')) ? 'show' : ''); ?>" id="produce-collections-app-nav">
                            <ul class="nav nav-collapse">
                                 <li>
                                <a href="<?php echo e(route('produce-collections.index')); ?>">
                                    <span class="sub-item">Collection</span>
                                </a>
                               </li>
                                <li>
                                    <a href="<?php echo e(route('my-deliveries.index')); ?>">
                                        <span class="sub-item">Deliveries</span><!-- fas fa-people-carry -->
                                        
                                    </a>
                                </li>
                            </ul>
                        </div>
                    </li>
                     <li class="nav-item <?php echo e((request()->type=='admin-invoices*') ? 'active' : ''); ?>">
                    <a href="<?php echo e(route('admin-invoices.index')); ?>">
                        <i class="fas fa-file-invoice-dollar"></i>
                        <p>Invoices</p>
                        
                    </a>
                </li>
                <li class="nav-item <?php echo e((request()->type=='farmer-credits*') ? 'active' : ''); ?>">
                    <a href="<?php echo e(route('farmer-credits.index')); ?>">
                        <i class="fas fa-hand-holding-usd"></i>
                        <p>Farmer Credits</p>
                        
                    </a>
                </li>
                
                
                    <li class="nav-item <?php echo e((request()->is('input_order*') || request()->is('credit_requests*') || request()->is('input-releases*')) ? 'active' : ''); ?>">
                        <a data-toggle="collapse" href="#input-orders-app-nav" aria-expanded="<?php echo e((request()->is('input-order*')) ? 'true' : 'false'); ?>">
                            <i class="fas fa-cart-arrow-down"></i>
                            <p>Input Orders</p>
                            <span class="caret"></span>
                        </a>
                        <div class="collapse <?php echo e((request()->is('input_order*') || request()->is('credit_requests*') || request()->is('input-releases*')) ? 'show' : ''); ?>" id="input-orders-app-nav">
                            <ul class="nav nav-collapse">
                                <li>
                                    <a href="<?php echo e(route('input_orders.index')); ?>">
                                        <span class="sub-item">Input Orders</span>
                                    </a>
                                </li>
                                <li>
                                    <a href="<?php echo e(route('credit_requests.index')); ?>">
                                        <span class="sub-item">Credit Request</span>
                                        
                                    </a>
                                </li>
                                <li>
                                    <a href="<?php echo e(route('deliveries.index')); ?>">
                                        <span class="sub-item">Deliveries</span>
                                        
                                    </a>
                                </li>
                                <li>
                                    <a href="<?php echo e(route('input_releases.index')); ?>">
                                        <span class="sub-item">Input Release</span>
                                        
                                    </a>
                                </li>
                            </ul>
                        </div>
                    </li>
                

                <li class="nav-item <?php echo e((request()->type=='farmer-credits*') ? 'active' : ''); ?>">
                    <a href="<?php echo e(route('farmer-credits.index')); ?>">
                        <i class="fas fa-hand-holding-usd"></i>
                        <p>Farmer Credits</p>
                        
                    </a>
                </li>
                <li class="nav-section">
                    <span class="sidebar-mini-icon">
                        <i class="fa fa-ellipsis-h"></i>
                    </span>
                    <h4 class="text-section">Reports</h4>
                </li>
                <li class="nav-item">
                    <a href="#">
                        <i class="far fa-chart-bar"></i>
                        <p>Reports</p>
                    </a>
                </li>
                <li class="nav-section">
                    <span class="sidebar-mini-icon">
                        <i class="fa fa-ellipsis-h"></i>
                    </span>
                    <h4 class="text-section">Messaging</h4>
                </li>
                <li class="nav-item">
                    <a data-toggle="collapse" href="#messages-app-nav" aria-expanded="false">
                        <i class="far fa-paper-plane"></i>
                        <p>Messages</p>
                        <span class="caret"></span>
                    </a>
                    <div class="collapse" id="messages-app-nav">
                        <ul class="nav nav-collapse">
                            <li>
                                <a href="#">
                                    <span class="sub-item">Compose</span>
                                </a>
                            </li>
                            <li>
                                <a href="#">
                                    <span class="sub-item">Inbox</span>
                                    <span class="badge badge-primary">4</span>
                                </a>
                            </li>
                        </ul>
                    </div>
                </li>
            </ul>
        </div>
    </div>
</div>
<?php /**PATH /home/spinmobisky/public_html/btcotton/resources/views/_partials/back-sidebar-fo.blade.php ENDPATH**/ ?>