<?php $__env->startSection('title'); ?>
    Twalisha Trading | Invoices
<?php $__env->stopSection(); ?>

<?php $__env->startSection('header'); ?>
    <div class="page-header">
        <h4 class="page-title">Invoices</h4>
        
        <ul class="breadcrumbs">
            <li class="nav-home">
                <a href="#" class="btn btn-icon btn-sm btn-round btn-light">
                    <i class="flaticon-home"></i>
                </a>
            </li>
            <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
                                        <th class="text-right" style="width: 10%">Action</th>
                                    </tr>
                                </thead>
                                <tfoot>
                                    <tr>
            <li class="nav-item">
                <a href="#">Invoices</a>
            </li>
            
        </ul>

    </div>
    <div class="ml-md-auto py-2 py-md-0">
        <a href="<?php echo e(route('dashboard')); ?>" class="btn btn-white btn-border btn-round btn-sm ml-1">
            <span class="btn-label"><i class="fas fa-caret-left"></i></span> Back
        </a>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="row row-card-no-pd mt--2">
        <div class="col-md-12">
            <div class="card">
                <div class="card-body">
                    <?php echo $__env->make('layouts._messages', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                    <?php if($invoiceout->count()): ?>
                        <div class="table-responsive">
                            <table id="inputs-list" class="display table table-striped table-hover" >
                                
                                <thead>
                                    <tr>
                                        <th>S/No.</th>
                                        <th>Invoice No.</th>
                                        <th>Amount</th>
                                        <th>Status</th>
                                        <th>Date</th>
                                        <th class="text-right" style="width: 10%">Action</th>
                                    </tr>
                                </thead>
                                <tbody id="input-list">
                                    <?php $__currentLoopData = $invoiceout; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $invoice): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr id="<?php echo e($invoice->id); ?>">
                                            <td><a href="#"><?php echo e($invoice->id); ?></a></td>
                                            <td><?php echo e($invoice->number); ?></td>
                                            <td><?php echo e($invoice->total); ?></td>
                                            
                                            <td>
                                            <?php if($invoice->status == 0): ?>
                                            <l>Pending</l>
                                            <?php elseif($invoice->status == 1): ?>
                                             <l>Paid</l>
                                             <?php endif; ?>
                                            </td>
                                            <td><?php echo e($invoice->created_at); ?></td>
                                            <td class="text-right">
                                               <div class="btn-group form-actions" role="group" aria-label="Actions">
                                                    <button type="submit" class="btn btn-success btn-sm" data-toggle="tooltip" title="View" data-original-title="View">
                                                        <i class="fa fa-edit"></i> View
                                                    </button>
                                                    <button type="button" class="btn btn-primary btn-sm" data-toggle="tooltip" title="Pay" data-original-title="Pay" data-id="" data-toggle="modal" data-target="#modal-default-<?php echo e($invoice->id); ?>">
                                                        <i class="far facheck"></i> Pay
                                                    </button>
                                    </tr>
                                        <!-- Modal -->
                                        <div class="modal fade" id="modal-default-<?php echo e($invoice->id); ?>" tabindex="-1" role="dialog" aria-hidden="true">
                                            <div class="modal-dialog" role="document">
                                                <div class="modal-content">
                                                    <div class="modal-header">
                                                        <h4 class="modal-title" id="modal-title">Pay Invoice</h4>
                                                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                            <span aria-hidden="true">&times;</span>
                                                        </button>
                                                    </div>
                                                    <form id="input-form" name="input-form" method="post" action="<?php echo e(route('invoices.index2')); ?>">
                                                        <?php echo csrf_field(); ?>

                                                        <div class="modal-body">
                                                            <input type="hidden" name="_token" id="token" value="<?php echo e(csrf_token()); ?>">
                                                            <input type="hidden" name="approved" value="0">
                                                            <input type="hidden" name="total" value="0">
                                                            <div class="form-group">
                                                                <label for="trader-id">Amount</label>
                                                                <input type="number" name="total">
                                                                <label for="trader-id"></label>
                                                                
                                                                <input type="number" name="id" value="<?php echo e($invoice->id); ?>">
                                                            </div>
                                                            
                                                        </div>
                                                        <div class="modal-footer">
                                                            <button type="submit" id="modal-save" class="btn btn-primary btn-round btn-md"><i class="fa fa-check"></i> PAy Invoice</button>
                                                            <button type="button" class="btn btn-dark btn-round btn-md" data-dismiss="modal">Close</button>
                                                        </div>
                                                    </form>
                                                </div>
                                            </div>
                                        </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                                <tfoot>
                                    <tr>
                                        <th>ID</th>
                                        <th>Farmer Organization</th>
                                        <th>Totals</th>
                                        <th>Status</th>
                                        <th>Created On</th>
                                        <th class="text-right" style="width: 10%">Action</th>
                                    </tr>
                                </tfoot>
                            </table>
                        </div>
                    <?php else: ?>
                        <?php echo $__env->make('layouts._nodata', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    <?php endif; ?>
                </div>
            </div>


        </div>
    </div>


<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/mobigrow/public_html/twa-orders/resources/views//invoices/index2.blade.php ENDPATH**/ ?>