<?php $__env->startSection('title'); ?>
    Twalisha Trading | Invoices to pay Twalisha
<?php $__env->stopSection(); ?>

<?php $__env->startSection('header'); ?>
    <div class="page-header">
        <h4 class="page-title">Invoices Payments for Ref# <?php echo e($invoice->id); ?></h4>
        
        <ul class="breadcrumbs">
            <li class="nav-home">
                <a href="#" class="btn btn-icon btn-sm btn-round btn-light">
                    <i class="flaticon-home"></i>
                </a>
            </li>
            <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
                                        <th class="text-right" style="width: 10%">Action</th>
                                    </tr>
                                </thead>
                                <tfoot>
                                    <tr>
            <li class="nav-item">
                <a href="#">Invoices</a>
            </li>
            
        </ul>

    </div>
    <div class="ml-md-auto py-2 py-md-0">

        <a href="<?php echo e(URL::previous()); ?>" class="btn btn-white btn-round btn-sm ml-1">
            <i class="fas fa-caret-left"></i> Back
        </a>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="row row-card-no-pd mt--2">
        <div class="col-md-12">
            <div class="card">
                <div class="card-body">
                    <?php echo $__env->make('layouts._messages', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                      <?php if($invoices): ?>
                        <div class="table-responsive">
                            <table id="inputs-list" class="display table table-striped table-hover" >

                                <thead>
                                    <tr>
                                        <th>S/No.</th>
                                        <th>Mode.</th>
                                        <th>Amount</th>
                                        <th>Date </th>
                                        </tr>
                                </thead>
                                <tbody id="input-list">
                                <?php $__currentLoopData = $invoices; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $invoicePay): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td><a href="#"><?php echo e($invoicePay->id); ?></a></td>
                                            <td><?php echo e($invoicePay->mode); ?></td>
                                            <td><?php echo e(Str::limit($invoicePay->amount,-2,'.')); ?></td>
                                            <td><?php echo e(Str::limit($invoicePay->created_at,10,'.')); ?></td>

                                    </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                                <tfoot>
                                    <tr>
                                    <th>S/No.</th>
                                        <th>Mode.</th>
                                        <th>Amount</th>
                                        <th>Date </th>
                                    </tr>
                                </tfoot>
                            </table>
                        </div>
                        <?php else: ?>
                        <?php echo $__env->make('layouts._nodata', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    <?php endif; ?>
                </div>
            </div>


        </div>
    </div>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>
<script>
$(document).ready(function () {
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });

            $('#inputs-list').DataTable({
                "order": [[ 0, "desc" ]]
            });
        });
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.site', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/mobigrow/public_html/twalisha.com/trading/public/resources/views/produce-invoices/details.blade.php ENDPATH**/ ?>