<?php

Route::get('/clearall', function() {
    $exitCode = Artisan::call('cache:clear');
    // return what you want
});

/*
 * =======================================================================================================
 * NO AUTH ROUTES
 * =======================================================================================================
 */
//post chat
Route::post('store_chat','ApiAccessController@storeChat');
//test sms
Route::get('/testsms', 'TestController@testSMS');
 
Route::get('/register_user', 'TradersController@showRegistrationForm')->name('show_registration_form');
Route::get('/register_user_no_organization', 'TradersController@register_user_no_organization')->name('register_user_no_organization');
Route::get('/counties_names','TradersController@counties_names');
Route::get('/farmerno_organizarion', 'TradersController@farmerno_organizarion')->name('farmerno_organizarion');
Route::get('/getregions_names','TradersController@getregions_names');

Route::get('/organisation_names','TradersController@organisation_names');
Route::get('/link_farmer_org/{id}','TradersController@linkFarmerOrg')->name('link_farmer_org');
Route::post('/update_user_org', 'TradersController@update_user_org')->name('update_user_org');

Route::post('/register', 'TradersController@register')->name('register');
Route::get('/login', 'UserController@showLoginForm')->name('show-login-form');
Route::post('/login', 'UserController@login')->name('login');
Route::get('/',  'HomeController@index')->name('home');

 //chat categories
 Route::resource('/chat-categories', 'ChatCategoryController');
 Route::post('/chat-categories/store-ajax', 'ChatCategoryController@storeAjax')->name('chat-units.store-ajax');
 Route::get('/chat-categories/{id}/edit-ajax', 'ChatCategoryController@editAjax')->name('chat-units.edit-ajax');
 Route::delete('/chat-categories/{id}/delete-ajax', 'ChatCategoryController@destroyAjax')->name('chat-units.delete-ajax');
  
// Route::get('/', function () {
//     return redirect()->route('home');
// });
Route::post('register_trader','TradersController@store'); //register the new user
Route::post('storeNonOrganization','TradersController@storeUserNonOrganization')->name('storeNonOrganization'); //register the new user

Route::get('/users/export','UserController@export')->name('users.export');
Route::get('/traders/export','TradersController@export')->name('traders.export');
Route::get('/trader-members/export/{id}/{type?}', 'TraderMemberController@export')->name('trader-members.export');
Route::get('/produce-aggregations/export', 'FarmerProduceAggregationController@export')->name('produce-aggregations.export');
Route::get('/produce-collections/export','ProduceCollectionsController@export')->name('produce-collections.export');

Route::post('/trader-members/import/{id}', 'TraderMemberController@import')->name('trader-members.import');
/*
 * =======================================================================================================
 * AUTH ROUTES
 * =======================================================================================================
 */

Route::middleware(['auth'])->group(function() {
    Route::get('/dashboard', 'UserController@dashboard')->name('dashboard');
    Route::get('/logout', 'UserController@logout')->name('logout');

    Route::get('/traders/profile','TradersController@profile')->name('traders.profile');

    Route::get('/users/get-user/{id}','UserController@getUserAjax')->name('get-user');

    //traders
    Route::resource('/traders', 'TradersController');
    Route::post('/traders/{trader}/activate', 'TradersController@activate')->name('traders.activate');
    Route::post('/traders/{trader}/deactivate', 'TradersController@deactivate')->name('traders.deactivate');
    Route::post('/traders/store-ajax', 'TradersController@storeAjax')->name('traders.store-ajax');
    Route::get('/traders/{id}/edit-ajax', 'TradersController@editAjax')->name('traders.edit-ajax');
    Route::delete('/traders/{id}/delete-ajax', 'TradersController@destroyAjax')->name('traders.delete-ajax');
    Route::get('/traders/get-contracts/{id}','TradersController@getContractsAjax')->name('get-contracts');
    Route::get('/traders/get-items/{id}','TradersController@getItemsAjax')->name('get-items');
    Route::get('/traders/get-agrodealers/{id}','TradersController@getAgroDealersAjax')->name('get-agrodealers');
    Route::post('/traders/store-settings', 'TradersController@storeSettings')->name('traders.store-settings');
        Route::get('/traders/{id}/link', 'TradersController@linkexpert')->name('traders.link');
    Route::post('/store_organization', 'TradersController@store_organization')->name('store_organization');

    //traders verification
    Route::resource('/verification', 'VerificationController');
    Route::post('/trader-verify/{id}','VerificationController@verifyAccount')->name('trader.verify');
    //trader-members
    Route::resource('/trader-members','TraderMemberController');
    Route::post('/trader-members/store-ajax', 'TraderMemberController@storeAjax')->name('trader-members.store-ajax');
    Route::get('/trader-members/{id}/edit-ajax', 'TraderMemberController@editAjax')->name('trader-members.edit-ajax');
    Route::delete('/trader-members/{id}/delete-ajax', 'TraderMemberController@destroyAjax')->name('trader-members.delete-ajax');
    //news
    
    Route::get('/surveillance', 'NewsController@surveillance')->name('surveillance');

    //get news categories
    Route::get('/news/getcategory/', 'NewsController@getNewsCategory');
    //news
    Route::get('/news', 'NewsController@index')->name('news.index');
    Route::post('/news/store', 'NewsController@store')->name('news.store');
    Route::post('/news/update', 'NewsController@update')->name('news.update');
    Route::get('/news/destroy/{id}', 'NewsController@destroy')->name('news.destroy');
    //trader-contracts
    Route::resource('/trader-contracts','TraderContractController');
    Route::post('/trader-contracts/store-ajax', 'TraderContractController@storeAjax')->name('trader-contracts.store-ajax');
    Route::get('/trader-contracts/{id}/edit-ajax', 'TraderContractController@editAjax')->name('trader-contracts.edit-ajax');
    Route::delete('/trader-contracts/{id}/delete-ajax', 'TraderContractController@destroyAjax')->name('trader-contracts.delete-ajax');
    Route::get('/trader-contracts/{id}/get-details', 'TraderContractController@getContractDetails')->name('trader-contracts.get-details');
    Route::get('/trader-contracts/calculate-fulfilment/{id}', 'TraderContractController@getFulfilment')->name('trader-contracts.calculate-fulfilment');

    //contract-details
    Route::resource('/contract-details','ContractDetailController');
    Route::post('/contract-details/store-ajax', 'ContractDetailController@storeAjax')->name('contract-details.store-ajax');
    Route::get('/contract-details/{id}/edit-ajax', 'ContractDetailController@editAjax')->name('contract-details.edit-ajax');
    Route::delete('/contract-details/{id}/delete-ajax', 'ContractDetailController@destroyAjax')->name('contract-details.delete-ajax');

    //trader-contacts
    Route::resource('/trader-contacts','TraderContactController');
    Route::post('/trader-contacts/store-ajax', 'TraderContactController@storeAjax')->name('trader-contacts.store-ajax');
    Route::get('/trader-contacts/{id}/edit-ajax', 'TraderContactController@editAjax')->name('trader-contacts.edit-ajax');
    Route::delete('/trader-contacts/{id}/delete-ajax', 'TraderContactController@destroyAjax')->name('trader-contacts.delete-ajax');

    //trader-networks
    Route::resource('/trader-networks','TraderNetworkController');
    Route::post('/trader-networks/store-ajax', 'TraderNetworkController@storeAjax')->name('trader-networks.store-ajax');
    Route::get('/trader-networks/{id}/edit-ajax', 'TraderNetworkController@editAjax')->name('trader-networks.edit-ajax');
    Route::delete('/trader-networks/{id}/delete-ajax', 'TraderNetworkController@destroyAjax')->name('trader-networks.delete-ajax');

    //users
    Route::resource('/users', 'UserController');
    Route::get('/users/{id}/wallet','UserController@showWallet')->name('wallet');
    Route::get('/users/profile/{id}','UserController@editProfile')->name('profile');
    Route::post('/users/update-profile/{id}','UserController@updateProfile')->name('update-profile');
    Route::get('/users/get-user/{id}','UserController@getUserAjax')->name('get-user');
    Route::get('/users/delete/{id}','UserController@deleteUserAjax')->name('users.delete');
    Route::get('/users/{id}/assignorganization','UserController@assignorganization')->name('assignorganization');

    //traders
    Route::resource('/produce-collections', 'ProduceCollectionsController');
    Route::post('/produce-collections/store-ajax', 'ProduceCollectionsController@storeAjax')->name('produce-collections.store-ajax');
    Route::post('/produce-collections/delivery-ajax', 'ProduceCollectionsController@storeDelivery')->name('produce-collections.delivery-ajax');
    Route::post('/produce-collections/approve-ajax', 'ProduceCollectionsController@approveAjax')->name('produce-collections.approve-ajax');
    Route::get('/produce-collections/{id}/edit-ajax', 'ProduceCollectionsController@editAjax')->name('produce-collections.edit-ajax');
    Route::get('/produce-collections/{id}/collect-ajax', 'ProduceCollectionsController@collectAjax')->name('produce-collections.collect-ajax');
    Route::delete('/produce-collections/{id}/delete-ajax', 'ProduceCollectionsController@destroyAjax')->name('produce-collections.delete-ajax');
    Route::get('/collect','ProduceCollectionsController@collect')->name('produce-collections.collect');

    //farmers
    Route::get('/farmers','FarmerController@index'); //list all the farmers
    Route::get('/farmerorganisations','FarmerController@create'); //show farmer create form
    Route::post('/add_farmer','FarmerController@addFarmer'); //add a farmer
    Route::get('/add_farmer_wallet/{id}','FarmerController@showWallet'); //show wallet
    Route::post('/add_wallet_money','FarmerController@addMoney'); //add money to wallet
    Route::get('/farmer_wallet/{id}','FarmerController@displayWallet'); //displays wallet transactions
    Route::post('/add_farmer_produce','FarmerController@addFarmerProduce'); //adds the farmer produce

    //NEW ROUTES
    Route::post('trader_addcontract','TradersController@addContract'); //adding trader contracts
    // Route::post('/trader/members','OrdersController@getOrderFarmers'); //get the list of farmers of a particular organisation
    Route::delete('trader_deletecontract','TraderContractController@destroy'); //trader contract
    Route::post('/trader_editcontract','TraderContractController@editContract');//edit the organisation contract
    Route::post('/trader_addcontract_details','TraderContractController@addContractDetails');//add more details on the contract
    Route::delete('trader_deletecontract_detail','TraderContractController@deleteContractItem'); //delete contract detail item

});

/*
 * =======================================================================================================
 * ADMIN ROUTES
 * =======================================================================================================
 */

Route::middleware(['auth','auth.admin'])->group(function() {
    //regions
    Route::resource('/regions', 'RegionController');
    Route::post('/regions/store-ajax', 'RegionController@storeAjax')->name('regions.store-ajax');
    Route::get('/regions/{id}/edit-ajax', 'RegionController@editAjax')->name('regions.edit-ajax');
    Route::delete('/regions/{id}/delete-ajax', 'RegionController@destroyAjax')->name('regions.delete-ajax');

    //counties
    Route::resource('/counties', 'CountyController');
    Route::post('/counties/store-ajax', 'CountyController@storeAjax')->name('counties.store-ajax');
    Route::get('/counties/{id}/edit-ajax', 'CountyController@editAjax')->name('counties.edit-ajax');
    Route::delete('/counties/{id}/delete-ajax', 'CountyController@destroyAjax')->name('counties.delete-ajax');

    //input-units
    Route::resource('/input-units', 'InputUnitController');
    Route::post('/input-units/store-ajax', 'InputUnitController@storeAjax')->name('input-units.store-ajax');
    Route::get('/input-units/{id}/edit-ajax', 'InputUnitController@editAjax')->name('input-units.edit-ajax');
    Route::delete('/input-units/{id}/delete-ajax', 'InputUnitController@destroyAjax')->name('input-units.delete-ajax');

    //input-categories
    Route::resource('/input-categories', 'InputCategoryController');
    Route::post('/input-categories/store-ajax', 'InputCategoryController@storeAjax')->name('input-units.store-ajax');
    Route::get('/input-categories/{id}/edit-ajax', 'InputCategoryController@editAjax')->name('input-units.edit-ajax');
    Route::delete('/input-categories/{id}/delete-ajax', 'InputCategoryController@destroyAjax')->name('input-units.delete-ajax');

    //inputs
    Route::resource('/inputs','InputController');
    Route::post('/inputs/store-ajax', 'InputController@storeAjax')->name('inputs.store-ajax');
    Route::get('/inputs/{id}/edit-ajax', 'InputController@editAjax')->name('inputs.edit-ajax');
    Route::delete('/inputs/{id}/delete-ajax', 'InputController@destroyAjax')->name('inputs.delete-ajax');

    //input-items
    Route::resource('/input-items', 'InputItemController');
    Route::post('/input-items/store-ajax', 'InputItemController@storeAjax')->name('input-items.store-ajax');
    Route::get('/input-items/{id}/edit-ajax', 'InputItemController@editAjax')->name('input-items.edit-ajax');
    Route::delete('/input-items/{id}/delete-ajax', 'InputItemController@destroyAjax')->name('input-items.delete-ajax');

    //produce-units
    Route::resource('/produce-units', 'ProduceUnitController');
    Route::post('/produce-units/store-ajax', 'ProduceUnitController@storeAjax')->name('produce-units.store-ajax');
    Route::get('/produce-units/{id}/edit-ajax', 'ProduceUnitController@editAjax')->name('produce-units.edit-ajax');
    Route::delete('/produce-units/{id}/delete-ajax', 'ProduceUnitController@destroyAjax')->name('produce-units.delete-ajax');

    //produce-categories
    Route::resource('/produce-categories','ProduceCategoryController');
    Route::post('/produce-categories/store-ajax', 'ProduceCategoryController@storeAjax')->name('produce-categories.store-ajax');
    Route::get('/produce-categories/{id}/edit-ajax', 'ProduceCategoryController@editAjax')->name('produce-categories.edit-ajax');
    Route::delete('/produce-categories/{id}/delete-ajax', 'ProduceCategoryController@destroyAjax')->name('produce-categories.delete-ajax');

    //produces
    Route::resource('/produces','ProduceController');
    Route::post('/produces/store-ajax', 'ProduceController@storeAjax')->name('produces.store-ajax');
    Route::get('/produces/{id}/edit-ajax', 'ProduceController@editAjax')->name('produces.edit-ajax');
    Route::delete('/produces/{id}/delete-ajax', 'ProduceController@destroyAjax')->name('produces.delete-ajax');

    //produce-items
    Route::resource('/produce-items', 'ProduceItemController');
    Route::post('/produce-items/store-ajax', 'ProduceItemController@storeAjax')->name('produce-items.store-ajax');
    Route::get('/produce-items/{id}/edit-ajax', 'ProduceItemController@editAjax')->name('produce-items.edit-ajax');
    Route::delete('/produce-items/{id}/delete-ajax', 'ProduceItemController@destroyAjax')->name('produce-items.delete-ajax');
    Route::get('/produce-items/{item}/update-stock', 'ProduceItemController@getUpdateStockForm')->name('stock.update-form');
    Route::post('/produce-items/{item}/update-stock', 'ProduceItemController@updateStock')->name('stock.update');

    //trader-types
    Route::resource('/trader-types','TraderTypeController');
    Route::post('/trader-types/store-ajax', 'TraderTypeController@storeAjax')->name('trader-types.store-ajax');
    Route::get('/trader-types/{id}/edit-ajax', 'TraderTypeController@editAjax')->name('trader-types.edit-ajax');
    Route::delete('/trader-types/{id}/delete-ajax', 'TraderTypeController@destroyAjax')->name('trader-types.delete-ajax');

    Route::post('/addmember','TradersController@addMember'); //add member
    Route::post('/updatemember/{id}','TradersController@updateMember'); //update member
    Route::get('/deletemember/{id}','TradersController@deleteMember'); //delete member
    Route::get('/showmembers','TradersController@showMembers'); //show member listing
    Route::get('/orgName/get','TradersController@orgName'); //show member listing



    //users
    Route::resource('/users', 'UserController');
    Route::get('/users/{id}/wallet','UserController@showWallet')->name('wallet');

    
});

/*
 * =======================================================================================================
 * BULK BUYER ROUTES
 * =======================================================================================================
 */

Route::middleware(['auth.buyer'])->group(function() {
    // Route::get('/bdashboard', 'UserController@bdashboard')->name('bdashboard');

});

/*
 * =======================================================================================================
 * BULK SELLER ROUTES
 * =======================================================================================================
 */

Route::middleware(['auth.seller'])->group(function() {
    // Route::get('/sdashboard', 'UserController@sdashboard')->name('sdashboard');
    //Route::resource('/bulkseller','BulkSellerController');
    Route::post('/input-items/store-ajax1', 'InputItemController@storeAjax')->name('input-items.store-ajax');
    Route::post('/input-items/store-ajax1', 'InputItemController@storeAjax')->name('input-items.store-ajax');
    Route::get('/input-items/{id}/edit-ajax1', 'InputItemController@editAjax')->name('input-items.edit-ajax');
    Route::delete('/input-items/{id}/delete-ajax1', 'InputItemController@destroyAjax')->name('input-items.delete-ajax');

});

/*
 * =======================================================================================================
 * TRANSPORTER ROUTES
 * =======================================================================================================
 */

Route::middleware(['auth.transporter'])->group(function() {
    // Route::get('/tdashboard', 'UserController@tdashboard')->name('tdashboard');
    Route::resource('/transporter','TransporterController');

});

/*
 * =======================================================================================================
 * AGRODEALER ROUTES
 * =======================================================================================================
 */

Route::middleware(['auth.agrodealer'])->group(function() {
    // Route::get('/addashboard', 'UserController@addashboard')->name('addashboard');
    Route::resource('/agrodealer','AgroDealerController');

});

/*
 * =======================================================================================================
 * FARMER ORGANISATION ROUTES
 * =======================================================================================================
 */

Route::middleware(['auth.farmerorganisation'])->group(function() {
    // Route::get('/fodashboard', 'UserController@fodashboard')->name('fodashboard');
    Route::resource('/farmerorganisation','FarmerOrganisationController');

    //produce-items
    Route::resource('/produce-items', 'ProduceItemController');
    Route::post('/produce-items/store-ajax', 'ProduceItemController@storeAjax')->name('produce-items.store-ajax');
    Route::get('/produce-items/{id}/edit-ajax', 'ProduceItemController@editAjax')->name('produce-items.edit-ajax');
    Route::delete('/produce-items/{id}/delete-ajax', 'ProduceItemController@destroyAjax')->name('produce-items.delete-ajax');
    Route::get('/produce-items/{item}/update-stock', 'ProduceItemController@getUpdateStockForm')->name('stock.update-form');
    Route::post('/produce-items/{item}/update-stock', 'ProduceItemController@updateStock')->name('stock.update');

    //produce-aggregation
    Route::resource('/produce-aggregations','FarmerProduceAggregationController');
    Route::post('/produce-aggregations/store-ajax', 'FarmerProduceAggregationController@storeAjax')->name('produce-aggregations.store-ajax');
    Route::get('/produce-aggregations/{id}/edit-ajax', 'FarmerProduceAggregationController@editAjax')->name('produce-aggregations.edit-ajax');
    Route::delete('/produce-aggregations/{id}/delete-ajax', 'FarmerProduceAggregationController@destroyAjax')->name('produce-aggregations.delete-ajax');
    Route::post('/produce-aggregations/approve-ajax', 'FarmerProduceAggregationController@approveAjax')->name('produce-aggregations.approve-ajax');

    //fo-settings
    Route::get('/fosettings/{id}','TradersController@fosettings');
    //save the locked savings
    Route::post('/lockedlimit/{id}','TradersController@savefolockedsettings');
    //save the locked savings
    Route::post('/creditlimit/{id}','TradersController@savecreditlimitsettings');
    
    
     //users--originally in the admin section; added to this part to allow Fo to access a user
    Route::resource('/users', 'UserController');
    Route::get('/users/{id}/wallet','UserController@showWallet')->name('wallet');
});

/*
 * =======================================================================================================
 * INPUT ORDERS ROUTES
 * =======================================================================================================
 */
Route::resource('/input_orders','InputOrderController');
Route::post('/input_orders/approve-ajax', 'InputOrderController@approveAjax')->name('input_orders.approve-ajax');

Route::post('/input_orders.details/{id}', 'InputOrderItemsController@store');
Route::get('/input_orders/{id}/edit-ajax', 'InputOrderItemsController@editAjax')->name('input_orders.edit-ajax');
Route::post('/input_orders/store-ajax', 'InputOrderItemsController@storeAjax')->name('input_orders.store-ajax');
Route::delete('/input_orders/{id}/delete-ajax', 'InputOrderItemsController@destroyAjax')->name('input_orders.delete-ajax');
Route::get('/input_orders.details/{id}', 'InputOrderItemsController@index')->name('input_orders.details');
Route::get('/input_orders/get-input-items/{id}','InputOrderItemsController@getInputItemsAjax')->name('get-input-items');
Route::get('/input_orders/forward-input-item/{id}', 'InputOrderItemsController@getForwardInputItemAjax')->name('forward-input-item');
Route::post('/input_orders/forward-input-item','InputOrderItemsController@forwardInputItemAjax')->name('forward-input-item');
Route::get('/input_orders/{id}/export', 'InputOrderItemsController@export')->name('input_orders.export');

/*
 * =======================================================================================================
 * BULK SELLER INPUT ORDERS ROUTES
 * =======================================================================================================
 */
Route::resource('bulk-seller','BulkSellerController');
/*
 * =====================================sse==================================================================
 * CREDIT REQUESTS ROUTES
 * =======================================================================================================
 */
Route::resource('credit_requests', 'CreditRequestsController');
/*
 * =======================================================================================================
 *  INVOICES ROUTES
 * =======================================================================================================
 */
Route::resource('seller-invoices','InvoicesController');
Route::resource('produce-invoices','ProduceInvoicesController');
Route::resource('admin-invoices','AdminInvoicesController');

/*
 * =======================================================================================================
 * PRODUCE ORDER ROUTES
 * =======================================================================================================
 */
//orders
Route::resource('/produce-orders','ProduceOrderController');
Route::post('/produce-orders/store-ajax', 'ProduceOrderController@storeAjax')->name('produce-orders.store-ajax');
Route::get('/produce-orders/{id}/edit-ajax', 'ProduceOrderController@editAjax')->name('produce-orders.edit-ajax');
Route::delete('/produce-orders/{id}/delete-ajax', 'ProduceOrderController@destroyAjax')->name('produce-orders.delete-ajax');
Route::post('/produce-orders/approve-ajax', 'ProduceOrderController@approveAjax')->name('produce-orders.approve-ajax');
//deliveries
Route::resource('deliveries','SellerDeliveriesController');
Route::get('export/{id}', 'CreditRequestsController@export')->name('export');
//collectionds
// Route::resource('collections','ProduceCollectionController');

/*
 * =======================================================================================================
 * PRODUCE ORDER ROUTES
 * =======================================================================================================
 */
Route::resource('drivers','DriverController');
Route::resource('vehicles','VehicleController');
Route::resource('my-deliveries','DeliveryDoneController');
Route::resource('my-delivery-requests','DeliveryRequestsController');
//credits
Route::resource('farmer-credits','UserCreditsController');

//on transit produce deliveries
Route::resource('on-transit','TransitController');
//release inputs to farmer
Route::resource('input_releases','InputReleasesController');

///==========================AGENTS ROUTES===========================///
Route::get('/soil_health/{id}','FarmerSoilHealthController@index')->name('soil_health.index');
Route::post('/soilhealth/store','FarmerSoilHealthController@store');
Route::post('/soilhealth/update','FarmerSoilHealthController@update');
Route::get('/soilhealth/delete/{id}','FarmerSoilHealthController@delete');
Route::get('/pic/delete/{id}','FarmerSoilHealthController@deletePic');
Route::get('/soilhealth/gethealth/{id}','FarmerSoilHealthController@getHealth');

Route::get('/crop_setting','CropSettingController@index')->name('crop_setting.index');
Route::get('/crop_setting/get','CropSettingController@getSettings');
Route::post('/crop_setting/store','CropSettingController@store');
Route::post('/crop_setting/update','CropSettingController@update');
//assign plan to farmer
Route::post('/crop_setting/assign','CropSettingController@assign');
Route::get('/crop_setting/destroy/{id}','CropSettingController@destroy');

Route::get('/season/{id}','SeasonController@index')->name('season.index');
Route::post('/season/store','SeasonController@store');
Route::post('/season/update','SeasonController@update');
Route::get('/season/delete/{id}','SeasonController@delete');
Route::get('/season/getseason/{id}','SeasonController@getSeason');

Route::get('/season_produce/{id}','SeasonProduceController@index')->name('season_produce.index');
Route::post('/season_produce/store','SeasonProduceController@store');
Route::post('/season_produce/update','SeasonProduceController@update');
Route::get('/season_produce/delete/{id}','SeasonProduceController@delete');
Route::get('/season_produce/getseasonproduce/{id}','SeasonProduceController@getSeasonProduce');
Route::get('/produce/get','SeasonProduceController@getProduce');

Route::get('/additional_produce/{id}','AdditionalSeasonalProduceController@index')->name('additional_produce.index');
Route::post('/additional_produce/store','AdditionalSeasonalProduceController@store');
Route::post('/additional_produce/update','AdditionalSeasonalProduceController@update');
Route::get('/additional_produce/delete/{id}','AdditionalSeasonalProduceController@delete');
Route::get('/additional_produce/get/{id}','AdditionalSeasonalProduceController@getAdditionalProduce');

Route::get('/fo-farmers','FOFarmersController@index')->name('fo-farmers.index');
Route::get('/fo-farmers/get','FOFarmersController@get');




   
Route::get('/calendar','EventsController@index')->name('calendar.index');
Route::get('/retrieve/events', 'EventsController@retrieve');
Route::post('/create', 'EventsController@create');
Route::post('/remove/event', 'EventsController@remove');
Route::post('/update/event', 'EventsController@update');

///========IVR ROutes===========///
//==================================//
Route::any('/ivr','IVRController@index')->name('ivr');
Route::any('/ivr/get','IVRController@getIvr');
Route::any('/callback','IVRController@callBack')->name('callback');
Route::any('/event','IVRController@event')->name('event');
Route::any('/call','IVRController@call')->name('call');
Route::any('/call/group','IVRController@callGroup')->name('callGroup');
//Business plans
Route::get('/business-plans','BusinessPlanController@index')->name('business-plans');
Route::get('/business-plans/get','BusinessPlanController@getPlans');

Route::get('/inspection/{id}','LivestockController@index')->name('inspection');
Route::post('/inspection/store','LivestockController@store');
Route::post('/inspection/update','LivestockController@update');
Route::get('/inspection/get/{id}','LivestockController@getInspects');
Route::get('/inspection/delete/{id}','LivestockController@destroy');

///====sms routes==============//
Route::any('/sendsms','SmsController@sendSms')->name('sendsms');
Route::any('/sendsms/group','SmsController@sendSmsGroup')->name('sendsmsGroup');
Route::any('/send_AudioQuestion_sms','SmsController@send_AudioQuestion_sms')->name('send_AudioQuestion_sms');
Route::any('/send_VideoQuestion_sms','SmsController@send_VideoQuestion_sms')->name('send_VideoQuestion_sms');
Route::any('/send_textQuestion_sms','SmsController@send_textQuestion_sms')->name('send_textQuestion_sms');
Route::any('/send_textQuestion_sms_all_farmers','SmsController@send_textQuestion_sms_all_farmers')->name('send_textQuestion_sms_all_farmers');
Route::any('/send_textQuestion_sms_all_farmers_all_users','SmsController@send_textQuestion_sms_all_farmers_all_users')->name('send_textQuestion_sms_all_farmers_all_users');
Route::any('/send_textQuestion_sms_to_org','SmsController@send_textQuestion_sms_to_org')->name('send_textQuestion_sms_to_org');
Route::any('/send_textQuestion_sms_to_All_Users','SmsController@send_textQuestion_sms_to_All_Users')->name('send_textQuestion_sms_to_All_Users');



//FArmer Business plans
Route::get('/farmer-plans/{id}','FarmerBusinesPlanController@farmerindex')->name('farmer-plans');
Route::get('/farmer-plans/get/{id}','FarmerBusinesPlanController@getFarmerPlans');
Route::post('/farmer-plan/store','FarmerBusinesPlanController@store');
Route::post('/farmer-plans/update','FarmerBusinesPlanController@update');
Route::get('/farmer-plans/delete/{id}','FarmerBusinesPlanController@destroy');
//Production cost
Route::get('production-cost/{id}','ProductionCostController@index')->name('production-cost');
Route::post('production-plan/store','ProductionCostController@store');
Route::post('production-cost/update','ProductionCostController@update');
Route::get('production-cost/get/{id}','ProductionCostController@get');
Route::get('/production-cost/delete/{id}','ProductionCostController@destroy');
Route::get('productionorders/get/{id}','ProductionCostController@getOrdered');
//agents fos
Route::get('/agents-traders', 'TradersController@agentFos')->name('traders.agents-fos');
//return agents fos for event
Route::get('/myfos', 'EventsController@getFOs');
Route::get('/getFarmers/{id}', 'EventsController@getFarmers');


Route::get('/textquestion','TextQuestionController@index')->name('textquestion');

Route::any('/textquestion/add','TextQuestionController@store')->name('textquestion.store');
Route::get('/textquestionindexall','TextQuestionController@textquestionindexall')->name('textquestionindexall');

//Audio
Route::get('/audioquestion','AudioQuestionController@index')->name('audioquestion');
Route::get('/audioquestion/delete/{id}','AudioQuestionController@destroy')->name('audioquestion.delete');
Route::get('/audioquestion/confirm/{id}','AudioQuestionController@confirm')->name('audioquestion.confirm');

//Video
Route::get('/videoquestion','VideoQuestionController@index')->name('videoquestion');
Route::get('/videoquestion/delete/{id}','VideoQuestionController@destroy')->name('videoquestion.delete');
Route::get('/videoquestion/confirm/{id}','VideoQuestionController@confirm')->name('videoquestion.confirm');
//get chat records
Route::get('/get_chat','VideoQuestionController@chatIndex');

//chattest
Route::get('/testchat','VideoQuestionController@showTest')->name('chat');

//Bubble Chart
Route::get('/btcottonlocation','BTcottonLocationController@index')->name('btcottonlocation');
Route::get('/btfarmermap','TrainingController@btfarmermap')->name('btfarmermap');
Route::get('/btcottonpdf','BTCottonLocationController@btcottonpdf')->name('btcottonpdf');


 //Pest Suvelance
 Route::post('/pest_suvelance_add','TextQuestionController@pest_suvelance_add')->name('pest_suvelance_add');

 

 //Training Module
 Route::get('/trainings/module','TrainingModuleController@index')->name('trainings.module');
 Route::post('/trainingmodule/store','TrainingModuleController@store')->name('trainingmodule.store');
 Route::post('/trainingmodule/update','TrainingModuleController@update')->name('trainingmodule.update');
 Route::get('/trainingmodule/destroy/{id}','TrainingModuleController@destroy')->name('trainingmodule.destroy');

 
 //Training
 Route::get('/trainings','TrainingController@index')->name('trainings.index');
 Route::post('/trainingtopic/store','TrainingController@store')->name('trainingtopic.store');
 Route::post('/trainingtopic/update','TrainingController@update')->name('trainingtopic.update');
 Route::get('/trainingtopic/destroy/{id}','TrainingController@destroy')->name('trainingtopic.destroy');
 Route::get('/module_names/get','TrainingController@module_names');

 

 Route::get('/chartscript','TrainingController@chartscript')->name('chartscript');

 //test chat
 Route::get('/chat_category','TrainingController@testChat')->name('chat');
 Route::get('chat_main/{id}','TrainingController@ChatMain')->name('chatmain'); //only this to work with
 Route::get('latestr','TrainingController@getLastestTest');
 
Route::get('chathistory/{id}', 'ApiAccessController@getChat');
Route::post('save_chat', 'TrainingController@storeChat');
Route::get('cats', 'ApiAccessController@getChatCategories1');
 Route::get('/chat_test2','TrainingController@testChat2');
 Route::get('/chat_data','TrainingController@getAllChat');
 //test data loading from the form
 Route::get('/chat_messages_data','TrainingController@getChatData');
 
Route::any('/aboutdetails','AboutDetailsController@index')->name('aboutdetails');
Route::any('/aboutdetails/store','AboutDetailsController@store')->name('aboutdetails.store');
Route::any('/aboutdetail/destroy/{id}','AboutDetailsController@destroy')->name('aboutdetail.destroy');
Route::any('/aboutdetail/update','AboutDetailsController@update')->name('aboutdetail.update');
Route::get('/category_names/get','AboutDetailsController@category_names');


//About Category
Route::any('/aboutdetailscategory','AboutDetailsCategoryController@index')->name('aboutdetailscategory');
Route::any('/aboutdetailscategory/store','AboutDetailsCategoryController@store')->name('aboutdetailscategory.store');
Route::any('/aboutdetailcategory/destroy/{id}','AboutDetailsCategoryController@destroy')->name('aboutdetailcategory.destroy');
Route::any('/aboutdetailcategory/update','AboutDetailsCategoryController@update')->name('aboutdetailcategory.update');
Route::post('/send_message_data','TrainingController@sendMessageData');




Route::get('/tags','TaggedController@index')->name('tags.index');
Route::get('/tagged-sms/{id}','TaggedController@tagged')->name('tagged-sms.show');
Route::get('/untagged','TaggedController@untagged')->name('untagged');



 //Publications
 Route::get('/publications','PublicationController@index')->name('publications');
 Route::post('/publication/store','PublicationController@store')->name('publication.store');
 Route::post('/publication/update','PublicationController@update')->name('publication.update');
 Route::get('/publication/destroy/{id}','PublicationController@destroy')->name('publication.destroy');


//addfrequentustions
Route::get('/frequentustions','FrequentQustionsController@index')->name('frequentustions');
Route::post('/addfrequentustions','FrequentQustionsController@store')->name('addfrequentustions');
Route::post('/frequentqustionsupdate','FrequentQustionsController@update')->name('frequentqustionsupdate');
Route::get('/frequentquestions/destroy/{id}','FrequentQustionsController@destroy')->name('frequentquestions.destroy');


