@extends('layouts.site')

@section('title')
BTCotton | Transport vehicles
@endsection

@section('header')
    <div class="page-header">
        <h4 class="page-title">Vehicles</h4>
        {{-- <h5 class="op-7 mb-2">Lorem ipsum dolor sit amet, consectetur adipiscing elit</h5> --}}

        <ul class="breadcrumbs">
            <li class="nav-home">
                <a href="#" class="btn btn-icon btn-sm btn-round btn-light">
                    <i class="flaticon-home"></i>
                </a>
            </li>
            <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="#">vehicles</a>
            </li>
            {{-- <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="#">Buttons</a>
            </li> --}}
        </ul>
    </div>
    <div class="ml-md-auto py-2 py-md-0">

            <button class="btn btn-primary btn-round btn-sm" data-toggle="modal" data-target="#modal-default">
                <i class="fa fa-plus"></i> Add Vehicles
            </button>


        <a href="{{ URL::previous() }}" class="btn btn-white btn-round btn-sm ml-1">
            <i class="fas fa-caret-left"></i> Back
        </a>
    </div>
@endsection

@section('content')
    <div class="row row-card-no-pd mt--2">
        <div class="col-md-12">
            <div class="card">
                <div class="card-body">
                @if ($errors->any())
                        <div class="alert alert-danger alert-dismissible" role="alert">
                        <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
                           <strong>Error! </strong>There were some errors with inputs.
                         <ul>
                        @foreach($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                    </div>

                @endif
                    @include ('layouts._messages')

                    @if($vehicles->count())
                        <div class="table-responsive">
                            <table  id="inputs-list" class="display table table-striped table-hover">
                                <thead>
                                    <tr>
                                        <th>S/No</th>
                                        <th>Model</th>
                                        <th>Make</th>
                                        <th>Plate</th>
                                        <th>Tonnage[Tonnes]</th>
                                        <th>Description</th>
                                        <th>Status</th>
                                        <th class="text-center" style="width: 10%">Action</th>
                                    </tr>
                                </thead>
                                <tfoot>
                                    <tr>
                                        <th>S/No</th>
                                        <th>Make</th>
                                        <th>Model</th>
                                        <th>Plate</th>
                                        <th>Tonnage[Tonnes]</th>
                                        <th>Description</th>
                                        <th>Status</th>
                                        <th class="text-center">Action</th>
                                    </tr>
                                </tfoot>
                                <tbody id="aggregation-list">
                                    @foreach($vehicles as $vehicle)
                                        <tr id="{{ $vehicle->id }}">
                                            <td> {{ ++$i }}</td>
                                            <td>{{ $vehicle->make }}</td>
                                            <td>{{ $vehicle->model }}</td>
                                            <td>{{ $vehicle->plate }}</td>
                                            <td>{{ $vehicle->tonnage }}</td>
                                            <td>{{ $vehicle->description }}</td>
                                            <td>
                                                @if($vehicle->status == 1)
                                                   <span class="badge badge-danger">Unavailable</span>
                                                @else
                                                   <span class="badge badge-success">Available</span>
                                                @endif
                                            </td>
                                            <td>
                                                <div class="btn-group form-actions" role="group" aria-label="Actions">
                                                    <button type="button" name="view" class="btn btn-success btn-sm" title="view" data-original-title="view" data-id=""data-toggle="modal" data-target="#modal-default1-{{$vehicle->id}}">
                                                        <i class="fa fa-check"></i> View
                                                    </button>
                                                    <button type="button" name="edit" class="btn btn-info btn-sm" title="edit" data-original-title="edit" data-id=""data-toggle="modal" data-target="#modal-default-{{$vehicle->id}}">
                                                        <i class="fa fa-edit"></i> Edit
                                                    </button>
                                                    <form name="delete" action="{{ route('vehicles.destroy', $vehicle->id)}}" method="post">
                                                    @csrf
                                                    @METHOD('DELETE')
                                                    <button type="submit" onsubmit="return confirm('Delete Vehicle?')" name="delete" class="btn btn-danger btn-sm" title="delete">
                                                        <i class="fa fa-trash"></i> Delete
                                                    </button>
                                                    </form>
                                                </div>

                                            </td>
                                            <!-- Modal Edit-->

                                        <div class="modal fade" id="modal-default-{{$vehicle->id}}" tabindex="-1" role="dialog" aria-hidden="true">
                                            <div class="modal-dialog" role="document">
                                                <div class="modal-content">
                                                    <div class="modal-header">
                                                        <h4 class="modal-title" id="modal-title">Vehicle Ref#{{ $vehicle->id }} </h4>
                                                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                            <span aria-hidden="true">&times;</span>
                                                        </button>
                                                    </div>
                                                    <form action="{{ route('vehicles.update', $vehicle->id)}}" method="post">
                                                        @csrf
                                                        @METHOD('PUT')
                                                        <div class="modal-body">

                                                            <input type="hidden" name="_token" id="token" value="{{ csrf_token() }}">

                                                            <div class="form-group">
                                                                <label for="license">Model:</label>
                                                                <input class="form-control" type="text" name="model" value="{{ $vehicle->model  }}" required>
                                                                <label for="">Make:</label>
                                                                <input class="form-control" type="text" name="make" value="{{ $vehicle->make }}" required>
                                                                <label for="">Tonnage(Tonnes):</label>
                                                                <input class="form-control" type="text" name="tonnage" value="{{ $vehicle->tonnage }}" required>
                                                                <label for="">Plate No.:</label>
                                                                <input class="form-control" type="text" name="plate" value="{{ $vehicle->plate }}" required>
                                                                <label for="">Description:</label>
                                                                <textarea class="form-control" name="description" required>{{ $vehicle->description }}</textarea>
                                                                <label for="">Unavailable?:</label>
                                                                <input type="hidden" value="0" name="status">
                                                                @if ($vehicle->status === 1)
                                                                    <input type="checkbox" name="status" checked="" value="1">

                                                                @else
                                                                    <input type="checkbox" value="1" name="status">
                                                                @endif
                                                            </div>

                                                        </div>
                                                        <div class="modal-footer">
                                                            <button type="submit" onsubmit="return confirm('Edit Vehicle?')" id="modal-save" class="btn btn-primary btn-round btn-md"><i class="fa fa-check"></i> Update</button>
                                                            <button type="button" class="btn btn-dark btn-round btn-md" data-dismiss="modal">Close</button>
                                                        </div>
                                                        </form>
                                                    </div>
                                                </div>
                                            </div>
                                            @endforeach
                                        </tbody>
                                    </table>
                                </div>
                                        </tr>

                    @else
                        @include('layouts._nodata')
                    @endif
                </div>
            </div>
        </div>
    </div>
        <!--start add modal-->
        <div class="modal fade" id="modal-default" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content"href>
                <div class="modal-header">
                    <h4 class="modal-title" id="modal-title">Add Vehicle</h4>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                            <form action="{{ route('vehicles.store')}}" method="post">
                                @csrf

                                <div class="modal-body">

                                    <input type="hidden" name="_token" id="token" value="{{ csrf_token() }}">

                                    <div class="form-group">
                                    <label for="license">Model:</label>
                                        <input class="form-control" type="text" name="model" required>
                                        <label for="">Make:</label>
                                        <input class="form-control" type="text" name="make" required>
                                        <label for="">Tonnage[Tonnes]:</label>
                                        <input class="form-control" type="text" name="tonnage" required>
                                        <label for="">Plate No.:</label>
                                        <input class="form-control" type="text" name="plate" required>
                                        <label for="">Description.:</label>
                                        <textarea placeholder="e.g. Refrigerated Truck, Insulated body." class="form-control" name="description"></textarea>
                                        <label for="">Available?:</label>
                                        <input type="checkbox" value="1" name="status">
                                        <input type="hidden" name="trader_id" value="{{ $trader->id }}">
                                    </div>

                                </div>
                                <div class="modal-footer">
                                    <button type="submit" onsubmit="return confirm('Add Vehicle?')" id="modal-save" class="btn btn-primary btn-round btn-md"><i class="fa fa-check"></i> Save</button>
                                    <button type="button" class="btn btn-dark btn-round btn-md" data-dismiss="modal">Close</button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
                <!--end add modal-->

    @section('scripts')
<script>
$(document).ready(function () {
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });

            $('#inputs-list').DataTable({
                "order": [[ 0, "desc" ]]
            });
        });
</script>
@endsection

@endsection

