@extends('layouts.site')

@section('title')
BTCotton | User - {{ $user->fullname }}
@endsection

@section('header')
    <div class="page-header">
        <h4 class="page-title">{{ $user->fullname }} - Wallet</h4>
        {{-- <h5 class="op-7 mb-2">Lorem ipsum dolor sit amet, consectetur adipiscing elit</h5> --}}
        <ul class="breadcrumbs">
            <li class="nav-home">
                <a href="#" class="btn btn-icon btn-sm btn-round btn-light">
                    <i class="flaticon-home"></i>
                </a>
            </li>
            <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="{{ route('users.index') }}">Users</a>
            </li>
            {{-- <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="#">Buttons</a>
            </li> --}}
        </ul>

    </div>
    <div class="ml-md-auto py-2 py-md-0">
        <a href="{{ URL::previous() }}" class="btn btn-white btn-round btn-sm ml-1">
            <i class="fas fa-caret-left"></i> Back
        </a>
    </div>
@endsection

@section('content')
    <div class="row">
        <div class="col-md-4">
            <div class="card card-profile">
                {{-- <div class="card-header" style="background-image: url('{{ asset('img/blogpost.jpg') }}')"> --}}
                <div class="card-header">
                <div class="profile-picture">
                        <div class="avatar avatar-xl">
                            <img src="{{ asset('img/profile.jpg') }}" alt="..." class="avatar-img rounded-circle">
                        </div>
                    </div>
                </div>
                <div class="card-body">
                    <div class="user-profile text-center">
                        <div class="name">{{ $user->fullname }}</div>
                        <div class="job">
                            <p><b>Username:</b> {{ $user->username }}
                            <br><b>Email:</b> {{ $user->email }}
                            <br><b>Phone:</b> {{ $user->phone }}</p>
                        </div>
                        <div class="view-profile">
                            <a href="{{ route('users.show', $user->id) }}" class="btn btn-primary btn-block">View Profile</a>
                        </div>
                    </div>
                </div>
                <div class="card-footer">
                    <div class="row user-stats text-center">
                        <div class="col">
                            <div class="number">KSh {{ $user->balance ? number_format(round($user->balance, 2)) : number_format(0) }}</div>
                            <div class="title">Wallet Balance</div>
                        </div>
                        <div class="col">
                            <div class="number">KSh {{ $user->locked_amount ? number_format(round($user->locked_amount, 2)) : number_format(0) }}</div>
                            <div class="title">Locked Amount</div>
                        </div>
                    </div>
                    <div class="row user-stats text-center">
                        <div class="col">
                            <div class="number">{{ $user->aggregations->sum('quantity') }} Kgs</div>
                            <div class="title">Aggregations</div>
                        </div>
                        <div class="col">
                            <div class="number">KSh {{ $user->credit_limit ? number_format(round($user->credit_limit, 2)) : number_format(0) }}</div>
                            <div class="title">Credit Limit</div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-8">
            <div class="card">
                <div class="card-header">
                    <h5 class="card-title">Transactions</h5>
                </div>
                <div class="card-body">
                    @if($user->transactions->count())
                        <div class="table-responsive">
                            <table id="users-list" class="display table table-striped table-hover" >
                                <thead>
                                    <tr>
                                        <th>Type</th>
                                        <th>Description</th>
                                        <th>Date</th>
                                        <th class="text-right">Amount (KSh)</th>
                                    </tr>
                                </thead>
                                <tfoot>
                                    <tr>
                                        <th>Type</th>
                                        <th>Description</th>
                                        <th>Date</th>
                                        <th class="text-right">Amount (KSh)</th>
                                    </tr>
                                </tfoot>
                                <tbody>
                                    @foreach($user->transactions as $transaction)
                                        <tr id="transaction_id_{{ $transaction->id }}">
                                            <td>{{ ucfirst($transaction->type) }}</td>
                                            <td>{{ $transaction->meta['description'] }}</td>
                                            <td>{{ $transaction->created_at }}</td>
                                            <td class="text-right">{{ number_format($transaction->amount, 2) }}</td>
                                        </tr>
                                    @endforeach
                                    <tr>
                                        <td colspan="3"></td>
                                        <td class="text-right">{{ number_format($user->balance, 2) }}</td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    @else
                        @include('layouts._nodata')
                    @endif
                </div>
            </div>
        </div>
    </div>
@endsection

@section('scripts')

@endsection
