@extends('layouts.site')

@section('title')
BTCotton | Update Profile - {{ $user->fullname }}
@endsection

@section('header')
    <div class="page-header">
        <h4 class="page-title">Update Profile - {{ $user->fullname }}</h4>
        {{-- <h5 class="op-7 mb-2">Lorem ipsum dolor sit amet, consectetur adipiscing elit</h5> --}}
        <ul class="breadcrumbs">
            <li class="nav-home">
                <a href="#" class="btn btn-icon btn-sm btn-round btn-light">
                    <i class="flaticon-home"></i>
                </a>
            </li>
            <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="{{ route('users.index') }}">Users</a>
            </li>
            {{-- <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="#">Buttons</a>
            </li> --}}
        </ul>

    </div>
    <div class="ml-md-auto py-2 py-md-0">
        <a href="{{ URL::previous() }}" class="btn btn-white btn-round btn-sm ml-1">
            <i class="fas fa-caret-left"></i> Back
        </a>
    </div>
@endsection

@section('content')
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-body">
                    @include ('layouts._messages')

                    <form action="{{ route('update-profile', $user->id) }}" method="post">
                        @csrf

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-row">
                                    <div class="col form-group">
                                        <label for="user-firstname">First Name*</label>
                                        <input name="firstname" id="user-firstname" type="text" class="form-control {{ $errors->has('firstname') ? 'is-invalid' : '' }}" placeholder="First Name" value="{{ old('firstname', $user->firstname ?? '') }}">

                                        @if ($errors->has('firstname'))
                                            <div class="invalid-feedback">
                                                <strong>{{ $errors->first('firstname') }}</strong>
                                            </div>
                                        @endif
                                    </div> <!-- form-group end.// -->
                                    <div class="col form-group">
                                        <label for="user-middlename">Middle Name</label>
                                        <input name="middlename" id="user-middlename" type="text" class="form-control {{ $errors->has('middlename') ? 'is-invalid' : '' }}" placeholder="Middle Name" value="{{ old('middlename', $user->farmer_profile->middlename ?? '') }}">

                                        @if ($errors->has('middlename'))
                                            <div class="invalid-feedback">
                                                <strong>{{ $errors->first('middlename') }}</strong>
                                            </div>
                                        @endif
                                    </div> <!-- form-group end.// -->
                                    <div class="col form-group">
                                        <label for="user-lastname">Last Name*</label>
                                        <input name="lastname" id="user-lastname" type="text" class="form-control {{ $errors->has('lastname') ? 'is-invalid' : '' }}" placeholder="Last Name" value="{{ old('lastname', $user->lastname ?? '') }}">

                                        @if ($errors->has('lastname'))
                                            <div class="invalid-feedback">
                                                <strong>{{ $errors->first('lastname') }}</strong>
                                            </div>
                                        @endif
                                    </div> <!-- form-group end.// -->
                                </div>
                                <div class="form-row">
                                    <div class="col form-group">
                                        <label for="user-email">Email*</label>
                                        <input name="email" id="user-email" type="text" class="form-control {{ $errors->has('email') ? 'is-invalid' : '' }}" placeholder="Email" value="{{ old('email', $user->email ?? '') }}">

                                        @if ($errors->has('email'))
                                            <div class="invalid-feedback">
                                                <strong>{{ $errors->first('email') }}</strong>
                                            </div>
                                        @endif
                                    </div> <!-- form-group end.// -->
                                </div>
                                <div class="form-row">
                                    <div class="col form-group">
                                        <label for="user-phone">Phone Number*</label>
                                        <input name="phone" id="user-phone" type="text" class="form-control {{ $errors->has('phone') ? 'is-invalid' : '' }}" placeholder="Phone Number" value="{{ old('phone', $user->phone ?? '') }}">

                                        @if ($errors->has('phone'))
                                            <div class="invalid-feedback">
                                                <strong>{{ $errors->first('phone') }}</strong>
                                            </div>
                                        @endif
                                    </div> <!-- form-group end.// -->
                                    <div class="col form-group">
                                        <label for="user-mpesa-number">M-Pesa Number</label>
                                        <input name="mpesa_number" id="user-mpesa-number" type="text" class="form-control {{ $errors->has('mpesa_number') ? 'is-invalid' : '' }}" placeholder="M-Pesa Number" value="{{ old('mpesa_number', $user->farmer_profile->mpesa_number ?? '') }}">

                                        @if ($errors->has('mpesa_number'))
                                            <div class="invalid-feedback">
                                                <strong>{{ $errors->first('mpesa_number') }}</strong>
                                            </div>
                                        @endif
                                    </div> <!-- form-group end.// -->
                                </div>
                                <div class="form-row">
                                    <div class="col form-group">
                                        <label for="user-address">Address</label>
                                        <textarea name="address" id="user-address" class="form-control {{ $errors->has('address') ? 'is-invalid' : '' }}" placeholder="Address">{{ old('address', $user->address ?? '') }}</textarea>
                                        @if ($errors->has('address'))
                                            <div class="invalid-feedback">
                                                <strong>{{ $errors->first('address') }}</strong>
                                            </div>
                                        @endif
                                    </div> <!-- form-group end.// -->
                                </div>
                                <div class="form-row">
                                    <div class="col form-group">
                                        <label for="user-national-id">National ID</label>
                                        <input name="national_id" id="user-national-id" type="text" class="form-control {{ $errors->has('national_id') ? 'is-invalid' : '' }}" placeholder="National ID" value="{{ old('national_id', $user->farmer_profile->national_id ?? '') }}">

                                        @if ($errors->has('national_id'))
                                            <div class="invalid-feedback">
                                                <strong>{{ $errors->first('national_id') }}</strong>
                                            </div>
                                        @endif
                                    </div> <!-- form-group end.// -->
                                </div>
                                <div class="form-row">
                                    <div class="col form-group">
                                        <label for="user-education-level">Education Level</label>
                                        <select id="user-education-level" name="education_level" class="form-control" style="width: 100%; border-color: #ebedf2;">
                                            <option value="">- Select -</option>
                                            <option value="Primary Level" {{ old('education_level', $user->farmer_profile->education_level ?? '') == 'Primary Level' ? 'selected="selected"' : '' }}>Primary Level</option>
                                            <option value="Secondary Level" {{ old('education_level', $user->farmer_profile->education_level ?? '') == 'Secondary Level' ? 'selected="selected"' : '' }}>Secondary Level</option>
                                            <option value="Bachelors Degree" {{ old('education_level', $user->farmer_profile->education_level ?? '') == 'Bachelors Degree' ? 'selected="selected"' : '' }}>Bachelors Degree</option>
                                            <option value="Masters Degree" {{ old('education_level', $user->farmer_profile->education_level ?? '') == 'Masters Degree' ? 'selected="selected"' : '' }}>Masters Degree</option>
                                            <option value="Doctorate" {{ old('education_level', $user->farmer_profile->education_level ?? '') == 'Doctorate' ? 'selected="selected"' : '' }}>Doctorate</option>
                                        </select>

                                        @if ($errors->has('education_level'))
                                            <div class="invalid-feedback">
                                                <strong>{{ $errors->first('education_level') }}</strong>
                                            </div>
                                        @endif
                                    </div> <!-- form-group end.// -->
                                </div>
                                <div class="form-row">
                                    <div class="col form-group">
                                        <label for="user-acreage">Acreage</label>
                                        <input name="acreage" id="user-acreage" type="text" class="form-control {{ $errors->has('acreage') ? 'is-invalid' : '' }}" placeholder="Acreage" value="{{ old('acreage', $user->farmer_profile->acreage ?? '') }}">

                                        @if ($errors->has('acreage'))
                                            <div class="invalid-feedback">
                                                <strong>{{ $errors->first('acreage') }}</strong>
                                            </div>
                                        @endif
                                    </div> <!-- form-group end.// -->
                                    <div class="col form-group">
                                        <label for="user-acreage-farmed">Acreage Farmed</label>
                                        <input name="acreage_farmed" id="user-acreage-farmed" type="text" class="form-control {{ $errors->has('acreage_farmed') ? 'is-invalid' : '' }}" placeholder="Acreage Farmed" value="{{ old('acreage_farmed', $user->farmer_profile->acreage_farmed ?? '') }}">

                                        @if ($errors->has('acreage_farmed'))
                                            <div class="invalid-feedback">
                                                <strong>{{ $errors->first('acreage_farmed') }}</strong>
                                            </div>
                                        @endif
                                    </div> <!-- form-group end.// -->
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-row">
                                    <div class="col form-group">
                                        <label for="user-input-spending">Input Spending
                                            <br><span class="small">Estimated spending per season in KSh</span>
                                        </label>
                                        <input name="input_spending" id="user-input-spending" type="number" class="form-control {{ $errors->has('input_spending') ? 'is-invalid' : '' }}" placeholder="Input Spending" value="{{ old('input_spending', $user->farmer_profile->input_spending ?? '') }}">

                                        @if ($errors->has('input_spending'))
                                            <div class="invalid-feedback">
                                                <strong>{{ $errors->first('input_spending') }}</strong>
                                            </div>
                                        @endif
                                    </div> <!-- form-group end.// -->
                                </div>
                                <div class="form-row">
                                    <div class="col form-group">
                                        <label for="user-preferred-learning-language">Preferred Learning Language</label>
                                        <input name="preferred_learning_language" id="user-preferred-learning-language" type="text" class="form-control {{ $errors->has('preferred_learning_language') ? 'is-invalid' : '' }}" placeholder="Preferred Learning Language" value="{{ old('preferred_learning_language', $user->farmer_profile->preferred_learning_language ?? '') }}">

                                        @if ($errors->has('preferred_learning_language'))
                                            <div class="invalid-feedback">
                                                <strong>{{ $errors->first('preferred_learning_language') }}</strong>
                                            </div>
                                        @endif
                                    </div> <!-- form-group end.// -->
                                </div>
                                <div class="form-row">
                                    <div class="col form-group">
                                        <label for="user-preferred-agrodealer">Preferred Agrodealer</label>
                                        <input name="preferred_agrodealer" id="user-preferred-agrodealer" type="text" class="form-control {{ $errors->has('preferred_agrodealer') ? 'is-invalid' : '' }}" placeholder="Preferred Agrodealer" value="{{ old('preferred_agrodealer', $user->farmer_profile->preferred_agrodealer ?? '') }}">

                                        @if ($errors->has('preferred_agrodealer'))
                                            <div class="invalid-feedback">
                                                <strong>{{ $errors->first('preferred_agrodealer') }}</strong>
                                            </div>
                                        @endif
                                    </div> <!-- form-group end.// -->
                                </div>
                                <div class="form-row">
                                    <div class="col form-group">
                                        <label for="user-computer-access">Computer Access
                                            <br><span class="small">Do you have access to a computer?</span>
                                        </label>
                                        <select id="user-computer-access" name="computer_access" class="form-control" style="width: 100%; border-color: #ebedf2;">
                                            <option value="">- Select -</option>
                                            <option value="0" {{ old('computer_access', $user->farmer_profile->computer_access ?? '') == '0' ? 'selected="selected"' : '' }}>No</option>
                                            <option value="1" {{ old('computer_access', $user->farmer_profile->computer_access ?? '') == '1' ? 'selected="selected"' : '' }}>Yes</option>
                                        </select>

                                        @if ($errors->has('computer_access'))
                                            <div class="invalid-feedback">
                                                <strong>{{ $errors->first('computer_access') }}</strong>
                                            </div>
                                        @endif
                                    </div> <!-- form-group end.// -->
                                    <div class="col form-group">
                                        <label for="user-computer-access-location">Computer Location
                                            <br><small>Where do you access your computer from?</small>
                                        </label>
                                        <select id="user-computer-access-location" name="computer_access_location" class="form-control" style="width: 100%; border-color: #ebedf2;">
                                            <option value="">- Select -</option>
                                            <option value="Home" {{ old('computer_access_location', $user->farmer_profile->computer_access_location ?? '') == 'Home' ? 'selected="selected"' : '' }}>Home</option>
                                            <option value="Office" {{ old('computer_access_location', $user->farmer_profile->computer_access_location ?? '') == 'Office' ? 'selected="selected"' : '' }}>Office</option>
                                            <option value="Phone" {{ old('computer_access_location', $user->farmer_profile->computer_access_location ?? '') == 'Phone' ? 'selected="selected"' : '' }}>Phone</option>
                                            <option value="Cyber Cafe" {{ old('computer_access_location', $user->farmer_profile->computer_access_location ?? '') == 'Cyber Cafe' ? 'selected="selected"' : '' }}>Cyber Cafe</option>
                                            <option value="Other" {{ old('computer_access_location', $user->farmer_profile->computer_access_location ?? '') == 'Other' ? 'selected="selected"' : '' }}>Other</option>
                                        </select>

                                        @if ($errors->has('computer_access_location'))
                                            <div class="invalid-feedback">
                                                <strong>{{ $errors->first('computer_access_location') }}</strong>
                                            </div>
                                        @endif
                                    </div> <!-- form-group end.// -->
                                </div>
                                <div class="form-row">
                                    <div class="col form-group">
                                        <label for="user-internet-access">Internet Access
                                            <br><span class="small">Do you have access to the Internet?</span>
                                        </label>
                                        <select id="user-internet-access" name="internet_access" class="form-control" style="width: 100%; border-color: #ebedf2;">
                                            <option value="">- Select -</option>
                                            <option value="0" {{ old('internet_access', $user->farmer_profile->internet_access ?? '') == '0' ? 'selected="selected"' : '' }}>No</option>
                                            <option value="1" {{ old('internet_access', $user->farmer_profile->internet_access ?? '') == '1' ? 'selected="selected"' : '' }}>Yes</option>
                                        </select>

                                        @if ($errors->has('internet_access'))
                                            <div class="invalid-feedback">
                                                <strong>{{ $errors->first('internet_access') }}</strong>
                                            </div>
                                        @endif
                                    </div> <!-- form-group end.// -->
                                    <div class="col form-group">
                                        <label for="user-internet-access-location">Internet Location
                                            <br><small>Where do you access your computer from?</small>
                                        </label>
                                        <select id="user-internet-access-location" name="internet_access_location" class="form-control" style="width: 100%; border-color: #ebedf2;">
                                            <option value="">- Select -</option>
                                            <option value="Home" {{ old('internet_access_location', $user->farmer_profile->internet_access_location ?? '') == 'Home' ? 'selected="selected"' : '' }}>Home</option>
                                            <option value="Office" {{ old('internet_access_location', $user->farmer_profile->internet_access_location ?? '') == 'Office' ? 'selected="selected"' : '' }}>Office</option>
                                            <option value="Phone" {{ old('internet_access_location', $user->farmer_profile->internet_access_location ?? '') == 'Phone' ? 'selected="selected"' : '' }}>Phone</option>
                                            <option value="Cyber Cafe" {{ old('internet_access_location', $user->farmer_profile->internet_access_location ?? '') == 'Cyber Cafe' ? 'selected="selected"' : '' }}>Cyber Cafe</option>
                                            <option value="Other" {{ old('internet_access_location', $user->farmer_profile->internet_access_location ?? '') == 'Other' ? 'selected="selected"' : '' }}>Other</option>
                                        </select>

                                        @if ($errors->has('computer_access_location'))
                                            <div class="invalid-feedback">
                                                <strong>{{ $errors->first('computer_access_location') }}</strong>
                                            </div>
                                        @endif
                                    </div> <!-- form-group end.// -->
                                </div>
                                <div class="form-row">
                                    <div class="col form-group">
                                        <label for="user-credit-history">Credit History
                                            <br><span class="small">Have you borrowed for farming purposes in the past?</span>
                                        </label>
                                        <select id="user-credit-history" name="credit_history" class="form-control" style="width: 100%; border-color: #ebedf2;">
                                            <option value="">- Select -</option>
                                            <option value="0" {{ old('credit_history', $user->farmer_profile->credit_history ?? '') == '0' ? 'selected="selected"' : '' }}>No</option>
                                            <option value="1" {{ old('credit_history', $user->farmer_profile->credit_history ?? '') == '1' ? 'selected="selected"' : '' }}>Yes</option>
                                        </select>

                                        @if ($errors->has('credit_history'))
                                            <div class="invalid-feedback">
                                                <strong>{{ $errors->first('credit_history') }}</strong>
                                            </div>
                                        @endif
                                    </div> <!-- form-group end.// -->
                                    <div class="col form-group">
                                        <label for="user-credit-history-outstanding">Outstanding Credit
                                            <br><span class="small">Do you have an outstanding loan?</span>
                                        </label>
                                        <select id="user-credit-history-outstanding" name="credit_history_outstanding" class="form-control" style="width: 100%; border-color: #ebedf2;">
                                            <option value="">- Select -</option>
                                            <option value="0" {{ old('credit_history_outstanding', $user->farmer_profile->credit_history_outstanding ?? '') == '0' ? 'selected="selected"' : '' }}>No</option>
                                            <option value="1" {{ old('credit_history_outstanding', $user->farmer_profile->credit_history_outstanding ?? '') == '1' ? 'selected="selected"' : '' }}>Yes</option>
                                        </select>

                                        @if ($errors->has('credit_history_outstanding'))
                                            <div class="invalid-feedback">
                                                <strong>{{ $errors->first('credit_history_outstanding') }}</strong>
                                            </div>
                                        @endif
                                    </div> <!-- form-group end.// -->
                                </div>
                                <div class="form-row">
                                    <div class="col form-group">
                                        <label for="user-credit-history-outstanding-details">Outstanding Credit
                                            <br><span class="small">Information about any outstanding credit</span>
                                        </label>
                                        <textarea name="credit_history_outstanding_details" id="user-credit-history-outstanding-details" class="form-control {{ $errors->has('credit_history_outstanding_details') ? 'is-invalid' : '' }}" placeholder="Outstanding credit information">{{ old('credit_history_outstanding_details', $user->credit_history_outstanding_details ?? '') }}</textarea>
                                        @if ($errors->has('credit_history_outstanding_details'))
                                            <div class="invalid-feedback">
                                                <strong>{{ $errors->first('credit_history_outstanding_details') }}</strong>
                                            </div>
                                        @endif
                                    </div> <!-- form-group end.// -->
                                </div>
                            </div>
                            <div class="col-md-12">
                                <div class="form-row">
                                    <div class="col form-group">
                                        <hr>
                                        <button type="submit" class="btn btn-primary btn-round btn-md">Update Profile</button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('scripts')

@endsection
