        @extends('layouts.site')

        @section('title')
        Twalisha Trading | Users
        @endsection

        @section('header')
        <div class="page-header">
        <h4 class="page-title">Users</h4>
        {{-- <h5 class="op-7 mb-2">Lorem ipsum dolor sit amet, consectetur adipiscing elit</h5> --}}
        <ul class="breadcrumbs">
        <li class="nav-home">
        <a href="#" class="btn btn-icon btn-sm btn-round btn-light">
        <i class="flaticon-home"></i>
        </a>
        </li>
        <li class="separator">
        <i class="flaticon-right-arrow"></i>
        </li>
        <li class="nav-item">
        <a href="{{ route('users.index') }}">Users</a>
        </li>
        {{-- <li class="separator">
        <i class="flaticon-right-arrow"></i>
        </li>
        <li class="nav-item">
        <a href="#">Buttons</a>
        </li> --}}
        </ul>

        </div>
        <div class="ml-md-auto py-2 py-md-0">
        <a href="{{ URL::previous() }}" class="btn btn-white btn-round btn-sm ml-1">
        <i class="fas fa-caret-left"></i> Back
        </a>
        </div>
        @endsection

        @section('content')
        <div class="row row-card-no-pd mt--2">
        <div class="col-md-12">
        <div class="card">
        <div class="card-body">
        @include ('layouts._messages')

        <div class="text-right">
        <a href="{{ route('users.export') }}" class="btn btn-primary btn-border btn-round btn-sm">
        <i class="far fa-file-excel"></i> Export Excel
        </a>
        <hr>
        </div>

        @if($users->count())
        <div class="table-responsive">
        <table id="users-list" class="display table table-striped table-hover" >
        <thead>
        <tr>
        <th>Name</th>
        <th>Username</th>
        <th>Contacts</th>
        <th>Wallet Balance (KSh)</th>
        <th class="text-right" style="width: 10%">Action</th>
        </tr>
        </thead>
        <tfoot>
        <tr>
        <th>Name</th>
        <th>Username</th>
        <th>Contacts</th>
        <th>Wallet Balance (KSh)</th>
        <th class="text-right">Action</th>
        </tr>
        </tfoot>
        <tbody>
        @foreach($users as $user)
        <tr>
        <td><a href="{{ $user->url }}">{{ $user->fullname }}</a></td>
        <td>{{ $user->username }}</td>
        <td>
        <span>Email: {{ $user->email }}</span>
        <br><span>Phone: {{ $user->phone }}</span>
        </td>
        <td>{{ $user->balance ? number_format($user->balance, 2) : number_format(0, 2) }}</td>
        <td class="text-right">
        <div class="btn-group form-actions" role="group" aria-label="Actions">
          @foreach($traders as $trader)
         {{ $trader->user_id }}
         
          @if($trader->user_id =='')
        <a id="edit-user" href="{{ route('assignorganization', $user->id) }}" class="btn btn-success btn-sm" data-toggle="tooltip" title="Edit" data-original-title="Assign Organization" data-id="{{ $user->id }}">
        <i class="fa fa-edit"></i> Assign Organization
        </a>
        @else   
           @endif
           @endforeach
        <a id="show-wallet" href="{{ route('wallet', $user->id) }}" class="btn btn-dark btn-sm" data-toggle="tooltip" title="Wallet" data-original-title="Wallet" data-id="{{ $user->id }}">
        <i class="fas fa-wallet"></i> Wallet
        </a>
        <a id="edit-user" href="{{ route('users.edit', $user->id) }}" class="btn btn-primary btn-sm" data-toggle="tooltip" title="Edit" data-original-title="Edit" data-id="{{ $user->id }}">
        <i class="fa fa-edit"></i> View
        </a>
        <a id="delete-user" href="{{ route('users.delete', $user->id) }}" class="btn btn-danger btn-sm" data-toggle="tooltip" title="Delete" data-original-title="Delete" data-id="{{ $user->id }}">
        <i class="fa fa-trash"></i> Delete
        </a>

        </div>
        </td>
        </tr>
        @endforeach
        </tbody>
        </table>
        </div>
        @else
        @include('layouts._nodata')
        @endif
        </div>
        </div>
        </div>
        </div>
        @endsection

        @section('scripts')
        <script>
        $(document).ready(function () {
        $('#users-list').DataTable({
        "order": [[ 0, "desc" ]]
        });
        });
        </script>
        @endsection