@extends('layouts.site')

@section('title')
BTCotton | Training 
@endsection

@section('header')
    <div class="page-header">
        <h4 class="page-title">Trainings</h4>
        {{-- <h5 class="op-7 mb-2">Lorem ipsum dolor sit amet, consectetur adipiscing elit</h5> --}}

        <ul class="breadcrumbs">
            <li class="nav-home">
                <a href="#" class="btn btn-icon btn-sm btn-round btn-light">
                    <i class="flaticon-home"></i>
                </a>
            </li>
            <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="#">Training </a>
            </li>
            {{-- <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="#">Buttons</a>
            </li> --}}
        </ul>
    </div>
    <div class="ml-md-auto py-2 py-md-0">

            <button class="btn btn-primary btn-round btn-sm" data-toggle="modal" data-target="#modal-default">
                <i class="fa fa-plus"></i> Add Topic 
            </button>


        <a href="{{ URL::previous() }}" class="btn btn-white btn-round btn-sm ml-1">
            <i class="fas fa-caret-left"></i> Back
        </a>
    </div>
@endsection

@section('content')
<div id="vueapp">
    <div class="row row-card-no-pd mt--2">
        <div class="col-md-12">
            <div class="card">
                <div class="card-body">
                @if ($errors->any())
                        <div class="alert alert-danger alert-dismissible" role="alert">
                        <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
                           <strong>Error! </strong>There were some errors with inputs.
                         <ul>
                        @foreach($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                    </div>

                @endif
                    @include ('layouts._messages')

                    @if($trainingtopics->count())
                        <div class="table-responsive">
                            <table  id="inputs-list" class="display table table-striped table-hover">
                                <thead>
                                <tr>
                                        <th>No</th>
                                        <th>Module</th>
                                        <th>Training Topic</th>
                                        <th>Video Link </th>
                                        <th>Status</th>
                                        <th>Posted By</th>
                                        <th class="text-center">Action</th>
                                    </tr>
                                </thead>
                                <tfoot>
                                    <tr>
                                        <th>No</th>
                                        <th>Module</th>
                                        <th>Training Topic</th>
                                        <th>Video Link </th>
                                        <th>Status</th>
                                        <th>Posted By</th>
                                        <th class="text-center">Action</th>
                                    </tr>
                                </tfoot>
                                <tbody id="aggregation-list">
                                
                                    @foreach($trainingtopics as $trainingtopic)
                                        <tr id="{{ $trainingtopic->trainingtopic_id }}">
                                        <td>{{ $trainingtopic['trainingtopic_id'] }}</td>
                                            <td>{{ $trainingtopic->tainingsmodule['module_name'] }}</td>
                                            <td>{{ $trainingtopic->text }}</td>
                                            <td>{{ $trainingtopic->video_link }}</td>
                                            <td>{{ $trainingtopic->status }}</td>
                                            <td>{{ $trainingtopic->posted_by }}</td>
                                            <td>
                                                <div class="btn-group form-actions" role="group" aria-label="Actions">
                                                    <!-- <button type="button" name="view" class="btn btn-success btn-sm" title="view" data-original-title="view" data-id=""data-toggle="modal" data-target="#modal-default1-{{$trainingtopic->id}}">
                                                        <i class="fa fa-check"></i> View
                                                    </button> -->
                                                    <button type="button" name="edit" class="btn btn-info btn-sm" title="edit" data-original-title="edit" data-id=""data-toggle="modal" data-target="#modal-default-{{$trainingtopic->id}}">
                                                        <i class="fa fa-edit"></i> Edit
                                                    </button>
                                                    <a class="btn btn-danger btn-sm" href="{{ route('trainingtopic.destroy', $trainingtopic->trainingtopic_id) }}"  data-target="#smstext-{{ $trainingtopic->trainingtopic_id }}"><i class="fa fa-plus"></i>Delete</a>

                                                </div>

                                            </td>
                                            <!-- Modal Edit-->

                                        <div class="modal fade" id="modal-default-{{$trainingtopic->id}}" tabindex="-1" role="dialog" aria-hidden="true">
                                            <div class="modal-dialog" role="document">
                                                <div class="modal-content">
                                                    <div class="modal-header">
                                                        <h4 class="modal-title" id="modal-title">Training Topic Ref#{{ $trainingtopic->id }} </h4>
                                                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                            <span aria-hidden="true">&times;</span>
                                                        </button>
                                                    </div>
                                                    <edit-trainingtopic-component :trainingtopic="{{ json_encode($trainingtopic)}}"><edit-trainingtopic-component/>

                                                    </div>
                                                </div>
                                            </div>
                                            @endforeach
                                        </tbody>
                                    </table>
                                </div>
                                        </tr>

                    @else
                        @include('layouts._nodata')
                    @endif
                </div>
            </div>
        </div>
    </div>
        <!--start add modal-->
        <div class="modal fade" id="modal-default" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content"href>
                <div class="modal-header">
                    <h4 class="modal-title" id="modal-title">Add Training</h4>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                           
                <div class="modal-body">
                <add-trainingtopic-component> <add-trainingtopic-component/>
                </div>   


                        </div>
                    </div>
                    </div>    </div>
                <!--end add modal-->

    @section('scripts')
<script>
$(document).ready(function () {
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });

            $('#inputs-list').DataTable({
                "order": [[ 0, "desc" ]]
            });
        });
</script>
@endsection

@endsection

