@extends('layouts.site')

@section('title')
BTCotton | Farmers
<script src="//cdnjs.cloudflare.com/ajax/libs/jquery/3.2.1/jquery.min.js"></script>


@endsection

@section('header')
    <div class="page-header">
        <h4 class="page-title">Farmers</h4>
        {{-- <h5 class="text-white op-7 mb-2">Lorem ipsum dolor sit amet, consectetur adipiscing elit</h5> --}}
        <ul class="breadcrumbs">
            <li class="nav-home">
                <a href="#">
                    <i class="flaticon-home"></i>
                </a>
            </li>
            <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="#">Farmers</a>
            </li>
            {{-- <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="#">Buttons</a>
            </li> --}}
        </ul>
    </div>
    <div class="ml-md-auto py-2 py-md-0">
        <a href="{{ URL::previous() }}" class="btn btn-white btn-round btn-sm ml-1">
            <i class="fas fa-caret-left"></i> Back
        </a>
    </div>
@endsection

@section('content')
    <div class="row row-card-no-pd mt--2">
        <div class="col-md-12">
         <div class="card">
         <div class="card-header">
								
		 </div>
		 <div class="card-body">
		   <div class="row">
             <div class="wrapper1">
    <section class="chat-area1">
      <header>
          <div class="details">
          <span>{{$catname}} Room</span>
          <p></p>
        </div>
      </header>
      <div class="chat-box" id="chat-box">
          
        <ul id="chathistory" style="list-style: None;">
        </ul>
      </div>
      <form action="#" class="typing-area" enctype="multipart/form-data" style="width:600px">
        <input type="text" class="incoming_id" name="category_id" value="{{$catid}}" hidden>
        <input type="text" class="incoming_id" name="farmer_id" value="{$lastfarmerid}" hidden>
        <input type="text" class="incoming_id" name="expert_id" value="{{Auth::user()->id}}" hidden>
        <input type="text" class="incoming_id" name="farmer_org_id" value="{$farmerorganisationid}" hidden>
        <input type="text" class="incoming_id" name="role" value="agent" hidden>
        
        <div class="row">
            <table>
                <tr>
                    <td>
                        <label for="attachments">
                <span class="input-group-text attach_btn"><i class="fas fa-paperclip" ></i></label>
                  <input type="file" class="attachments" id="attachments" name="attachments[]" style="display: none">
        
                </span>
        <input type="text" name="message" class="input-field" placeholder="Type a message here..." autocomplete="off"/>
                    </td>
                    <td>
                         <button class="btn btn-primary" style="border-radius:0px"><i class="fab fa-telegram-plane"></i></button>
                    </td>
                </tr>
            </table>
                
       
        </div>
      </form>
    </section>
  </div>
           </div>
         </div>
        </div>
        
    </div>
@endsection

@section('scripts')
<script>
 const form = document.querySelector(".typing-area"),
        incoming_id = form.querySelector(".incoming_id").value,
        inputField = form.querySelector(".input-field"),
        attachments = form.querySelector(".attachments"),
        sendBtn = form.querySelector("button"),
        chatBox = document.querySelector(".chat-box");

        form.onsubmit = (e)=>{
            e.preventDefault();
        }

        inputField.focus();
        inputField.onkeyup = ()=>{
            if(inputField.value != ""){
                sendBtn.classList.add("active");
            }else{
                sendBtn.classList.remove("active");
            }
        }

sendBtn.onclick = ()=>{
    
    let xhr = new XMLHttpRequest();
    xhr.open("POST", "save_chat"+"?_token=" + "{{ csrf_token() }}", true);
    xhr.onload = ()=>{
      if(xhr.readyState === XMLHttpRequest.DONE){
          if(xhr.status === 200){
              inputField.value = "";
              scrollToBottom();
          }
      }
    }
    let formData = new FormData(form);
    xhr.send(formData);
}
chatBox.onmouseenter = ()=>{
    chatBox.classList.add("active");
}

chatBox.onmouseleave = ()=>{
    chatBox.classList.remove("active");
}

setInterval(() =>{
    let xhr = new XMLHttpRequest();
    xhr.open("GET", "chathistory/"+1, true);
    xhr.onload = ()=>{
      if(xhr.readyState === XMLHttpRequest.DONE){
          if(xhr.status === 200){
            let data = xhr.response;
            var newdata=JSON.parse(data)
            
            n = (newdata.length);
            var kk="";

            for(i = 0; i <= (n-1); i++){
                var list = newdata[i].message;
                if(newdata[i].role=='farmer'){
                    if((newdata[i].file_name!="") && (newdata[i].message!="")){
                        kk += "<li class='self'><span><a href='"+newdata[i].file_url+"'>"+newdata[i].file_url+"</a></span><hr style='border-bottom: 2px solid #f4f7f6;'><span>"+list+"</span><hr style='border-bottom: 2px solid #f4f7f6;'><span style='color:green'>Farmer</span></li><br/>"
                   
                    }
                    else if((newdata[i].file_name=="") && (newdata[i].message!="")){
                        kk += "<li class='self'><span>"+list+"</span><hr style='border-bottom: 2px solid #f4f7f6;'><span style='color:green'>Farmer</span></li><br/>"
                   
                    }
                    else if(newdata[i].file_name!="" && newdata[i].message==""){
                        kk += "<li class='self'><span>"+list+"</span><hr style='border-bottom: 2px solid #f4f7f6;'><span style='color:green'>Farmer</span></li><br/>"
                   
                    }
                    
                }
                else if(newdata[i].role=='agent'){
                    kk += "<li class='other'><span>"+list+"</span><hr style='border-bottom: 2px solid #f4f7f6;'><span style='color:red'>Expert</span></li><br/>"
                }
               


            }
            var MyList = document.getElementById('chathistory');
            
            //newdata.forEach(function (arrayItem) {
                //var x = arrayItem;
            chatBox.innerHTML = kk;
            //});
            
               
            
            
            if(!chatBox.classList.contains("active")){
                scrollToBottom();
              }
          }
      }
    }
    xhr.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
    xhr.send("incoming_id="+incoming_id);
}, 500);

function scrollToBottom(){
    chatBox.scrollTop = chatBox.scrollHeight;
  }
  



</script>
@endsection
