@extends('layouts.site')

@section('title')
BTCotton | Link Expert
@endsection

@section('header')
    <div class="page-header">
        <h4 class="page-title">Link organisation </h4>
        {{-- <h5 class="op-7 mb-2">Lorem ipsum dolor sit amet, consectetur adipiscing elit</h5> --}}
        <ul class="breadcrumbs">
            <li class="nav-home">
                <a href="#">
                    <i class="flaticon-home"></i>
                </a>
            </li>
            <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="#">Organisations</a>
            </li>
            {{-- <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="#">Buttons</a>
            </li> --}}
        </ul>
    </div>

    <div class="ml-md-auto py-2 py-md-0">
        <a href="{{ URL::previous() }}" class="btn btn-white btn-round btn-sm ml-1">
            <i class="fas fa-caret-left"></i> Back
        </a>
    </div>
@endsection

@section('content')
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-body">
                    @include ('layouts._messages')

                    <form action="{{ route('update_user_org') }}" method="post">
                    
                        @csrf

<div class="row trader-form">
    <div class="col-md-6">
        <div class="form-row">
          
        </div>
      
    <div class="col-md-6">
        <div class="form-row">
            <div class="col form-group">
                <label for="trader-type-id">Organization*</label>
            
                <input type="hidden" name="type_id" value="{{ $trader->id }}">
                @if (! Auth::User()->isAdmin())
              
                @endif
                <select id="trader-type-id" name="trader_id" class="form-control" style="width: 100%; border-color: #ebedf2;" {{ ! Auth::User()->isAdmin() ? 'disabled' : ''}}>
                    <option value="">- Select -</option>
                    @foreach($trader_types as $key => $value)
                        @if(isset($trader))
                            <option value="{{ $value->id }}" {{ old('id', $trader->id ?? '') == $value->id ? 'selected="selected"' : '' }}>{{ $value->organisation_name }}</option>
                        @else
                            <option value="{{ $value->id }}">{{ $value->organisation_name }}</option>
                        @endif
                    @endforeach
                </select>

                @if ($errors->has('type_id'))
                    <div class="invalid-feedback">
                        <strong>{{ $errors->first('type_id') }}</strong>
                    </div>
                @endif
            </div>
        </div>

    
 
</div>


                        <div class="row">
                            <div class="col-12">
                                <hr>
                                <button type="submit" class="btn btn-primary btn-round btn-md">Link Farmer</button>
                                <small style="padding: .65rem 1.4rem;"></small>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('scripts')
    <script>
        $(document).ready(function() {
            $('#trader-preferred-regions').select2();
        });
    </script>
@endsection
