@csrf
<div class="form-group">
    <label for="name">Name</label>
    <input type="text" name="name" id="name" value="{{ old('name', $trader_type->name ?? '') }}" class="form-control {{ $errors->has('name') ? 'is-invalid' : '' }}" placeholder="Trader Type">

    @if ($errors->has('name'))
        <div class="invalid-feedback">
            <strong>{{ $errors->first('name') }}</strong>
        </div>
    @endif
</div>
<div class="form-group">
    <label for="trader-type-description">Description</label>
    <textarea name="description" id="trader-type-description" class="form-control {{ $errors->has('description') ? 'is-invalid' : '' }}" disabled>{{ old('description', $trader_type->description ?? '') }}</textarea>

    @if ($errors->has('description'))
        <div class="invalid-feedback">
            <strong>{{ $errors->first('description') }}</strong>
        </div>
    @endif
</div>
@if( isset($buttonText) )
    <div class="form-group">
        <button type="submit" class="btn btn-primary btn-lg">{{ $buttonText }}</button>
    </div>
@endif
