@extends('layouts.site')

@section('title')
BTCotton | Network - {{ $trader_network->name }}
@endsection

@section('header')
    <div class="page-header">
        <h4 class="page-title">Network - {{ $trader_network->produce->name }}</h4>
        {{-- <h5 class="op-7 mb-2">Lorem ipsum dolor sit amet, consectetur adipiscing elit</h5> --}}

        <ul class="breadcrumbs">
            <li class="nav-home">
                <a href="{{ URL::previous() }}" class="btn btn-icon btn-sm btn-round btn-light">
                    <i class="flaticon-home"></i>
                </a>
            </li>
            <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="{{ route('traders.index') }}">Organisations</a>
            </li>
            <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="{{ route('traders.show', $trader_network->trader_id) }}">{{ $trader_network->trader->organisation_name}}</a>
            </li>

        </ul>
    </div>
    <div class="ml-md-auto py-2 py-md-0">
        <a id="edit-network" href="{{ route('trader-networks.edit', $trader_network->id) }}" class="btn btn-primary btn-round btn-sm">
            <i class="fa fa-edit"></i> Edit Network
        </a>

        <a href="{{ URL::previous() }}" class="btn btn-white btn-round btn-sm ml-1">
            <i class="fas fa-caret-left"></i> Back
        </a>
    </div>
@endsection

@section('content')
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-body">
                    @include ('layouts._messages')

                    <div class="text-right mb-3">
                        <a id="create-network-detail" href="{{ route('trader-networks.create') }}" class="btn btn-primary btn-round btn-sm"><i class="fa fa-plus"></i>  Link Farmer Organisation</a>
                    </div>
                    <hr>
                    <div class="alert alert-info shadow-sm">
                        <dl class="row main">
                            <dt class="col-sm-5">Network Name</dt>
                            <dd class="col-sm-7">{{ $trader_network->name }}</dd>
                            <dt class="col-sm-5">Produce</dt>
                            <dd class="col-sm-7">{{ $trader_network->produce->name }}</dd>
                            <dt class="col-sm-5 text-truncate">Price per Unit ({{ $trader_network->produce_unit->abbreviation }})</dt>
                            <dd class="col-sm-7">{{ 'KSh ' . number_format($trader_network->price_per_unit, 2) }}</dd>
                            <dt class="col-sm-5">Tonnage ({{ $trader_network->produce_unit->abbreviation }})</dt>
                            <dd class="col-sm-7">{{ number_format($trader_network->tonnage) }}</dd>
                            <dt class="col-sm-5">Percentage Fulfilled (<span class="percentage-label">{{ $trader_network->fulfilled }}</span> %)</dt>
                            <dd class="col-sm-7 pt-1">
                                <span class="percentage in-main">
                                    <div class="progress-card fulfilled mb-0">
                                        <div class="progress">
                                            <div class="progress-bar progress-bar-striped bg-warning" role="progressbar" style="width: {{ $trader_network->fulfilled }}%" aria-valuenow="0" aria-valuemin="{{ $trader_network->fulfilled }}" aria-valuemax="100" data-toggle="tooltip" data-placement="top" title="" data-original-title="{{ $trader_network->fulfilled }}%"></div>
                                        </div>
                                    </div>
                                </span>
                            </dd>
                        </dl>
                    </div>
                    <hr>
                    {{-- @if($user->isAdmin() || $user->isFarmerOrganisation()) { --}}
                    @if($network_details->count())
                        <div class="table-responsive">
                            <table id="network-details-list" class="display table table-striped table-hover" >
                                <thead>
                                    <tr>
                                        <th>Farmer Organisation</th>
                                        <th>Tonnage (in Kgs)</th>
                                        <th>Available</th>
                                        <th class="text-center" style="width: 10%">Action</th>
                                    </tr>
                                </thead>
                                <tfoot>
                                    <tr>
                                        <th>Farmer Organisation</th>
                                        <th>Tonnage (in Kgs)</th>
                                        <th>Available</th>
                                        <th class="text-center">Action</th>
                                    </tr>
                                </tfoot>
                                <tbody id="network-detail-list">
                                    @foreach($network_details as $network_detail)
                                        <tr id="network_detail_id_{{ $network_detail->id }}">
                                            <td>
                                                <a href="{{ $network_detail->url }}">{{ $network_detail->produce_item->trader->organisation_name }}</a>
                                                <small><br><b>Produce:</b> {{ $network_detail->produce_item->produce->name }}
                                                <br><b>Quality:</b> {{ $network_detail->produce_item->quality }}
                                                <br><b>Unit:</b> {{ $network_detail->produce_item->produce_unit->abbreviation }}</small>
                                            </td>
                                            <td>{{ number_format($network_detail->tonnage) }}</td>
                                            <td>{{ number_format($network_detail->produce_item->balance) }}</td>
                                            <td>
                                                <div class="btn-group form-actions" role="group" aria-label="Actions">
                                                    <a id="edit-network-detail" href="{{ route('network-details.edit', $network_detail->id) }}" class="btn btn-primary btn-sm" data-toggle="tooltip" title="Edit" data-original-title="Edit" data-id="{{ $network_detail->id }}">
                                                        <i class="fa fa-edit"></i> Edit
                                                    </a>
                                                    <button id="delete-network-detail" type="submit" class="btn btn-danger btn-sm" data-toggle="tooltip" title="Delete" data-original-title="Delete" data-id="{{ $network_detail->id }}">
                                                        <i class="far fa-trash-alt"></i> Delete
                                                    </button>
                                                </div>
                                            </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    @else
                        @include('layouts._nodata')
                    @endif
                </div>
            </div>
        </div>
    </div>

    <!-- Network Details Modal -->
    <div class="modal fade" id="crud-modal" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title" id="modal-title"></h4>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form id="network-detail-form" name="network-detail-form" method="post">
                    <div class="modal-body">
                        <div class="alert alert-info shadow-sm bg-info text-white">
                            <dl class="row">
                                <dt class="col-sm-5">Network Name</dt>
                                <dd class="col-sm-7">{{ $trader_network->name }}</dd>
                                <dt class="col-sm-5">Produce</dt>
                                <dd class="col-sm-7">{{ $trader_network->produce->name }}</dd>
                                <dt class="col-sm-5 text-truncate">Price per Unit ({{ $trader_network->produce_unit->abbreviation }})</dt>
                                <dd class="col-sm-7">{{ 'KSh ' . number_format($trader_network->price_per_unit, 2) }}</dd>
                                <dt class="col-sm-5">Tonnage ({{ $trader_network->produce_unit->abbreviation }})</dt>
                                <dd class="col-sm-7">{{ number_format($trader_network->tonnage) }}</dd>
                                <dt class="col-sm-5">Percentage Fulfilled</dt>
                                <dd class="col-sm-7 pt-1">
                                    <span class="percentage in-modal">
                                        <div class="progress-card fulfilled mb-0">
                                            <div class="progress">
                                            <div class="progress-bar progress-bar-striped bg-warning" role="progressbar" style="width: {{ $trader_network->fulfilled }}%" aria-valuenow="{{ $trader_network->fulfilled }}" aria-valuemin="{{ $trader_network->fulfilled }}" aria-valuemax="100" data-toggle="tooltip" data-placement="top" title="" data-original-title="{{ $trader_network->fulfilled }}%"></div>
                                            </div>
                                            <span class="percentage-label"></span>
                                        </div>
                                    </span>
                                </dd>
                            </dl>
                        </div>
                        <input type="hidden" name="_token" id="token" value="{{ csrf_token() }}">
                        <input type="hidden" name="id" id="network-detail-id">
                        <input type="hidden" name="network_id" id="network-detail-network-id" value="{{ $trader_network->id }}">

                        <div class="form-group">
                            <label for="network-detail-produce-item-id">Farmer Organisation</label>
                            <select id="network-detail-produce-item-id" name="produce_item_id" class="form-control" style="width: 100%; border-color: #ebedf2;">
                                <option value="">- Select -</option>
                                @foreach($produce_items as $produce_item)
                                    <option value="{{ $produce_item->id }}" data-id="{{ $produce_item->id }}">{{ $produce_item->trader->organisation_name . ' (Quality: ' . $produce_item->quality . ')' }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="form-group">
                            <label for="network-detail-tonnage">Tonnage (in Kgs)</label>
                            <input type="number" name="tonnage" id="network-detail-tonnage" class="form-control">
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="submit" id="modal-save" class="btn btn-primary btn-round btn-md"><i class="fa fa-check"></i> Save</button>
                        <button type="button" class="btn btn-dark btn-round btn-md" data-dismiss="modal">Close</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
@endsection

@section('scripts')
    <script>
        $(document).ready(function () {
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });

            $('#crud-modal').on('shown.bs.modal', function() {
                $('#network-detail-produce-item-id').trigger('focus');

                $('#network-detail-produce-item-id').select2({
                    dropdownParent: $('#crud-modal')
                });
            });

            $('#network-details-list').DataTable({
                "order": [[ 0, "desc" ]]
            });

            // create
            $('body').on('click', '#create-network-detail', function(e) {
                e.preventDefault();

                $('#modal-save').val("create-network-detail");
                $('#network-detail-form').trigger("reset");
                $('#network-detail-id').val('');
                $('#network-detail-produce-item-id').val('').trigger('change');
                $('#network-detail-tonnage').val('');
                $('#modal-title').html("Add Network Item");
                $('#crud-modal').modal('show');
            });

            // edit
            $('body').on('click', '#edit-network-detail', function (e) {
                e.preventDefault();

                var network_detail_id = $(this).data('id');

                $.get('/network-details/' + network_detail_id +'/edit-ajax', function (data) {
                    $('#modal-title').html("Edit Network Item");
                    $('#modal-save').val("edit-network-detail");

                    $('#network-detail-id').val(data.id);
                    $('#network-detail-network-id').val(data.network_id);
                    $('#network-detail-produce-item-id').val(data.produce_item_id).trigger('change');
                    $('#network-detail-tonnage').val(data.tonnage);
                    $('#crud-modal').modal('show');
                })
                .fail(function (jqXHR, textStatus, errorThrown) {
                    // console.warn(xhr.responseText)
                    console.log(JSON.stringify(jqXHR));
                    console.log("AJAX error: " + textStatus + ' : ' + errorThrown);
                    $('#modal-save').html('Save');
                })
            });

            // delete
            $('body').on('click', '#delete-network-detail', function (e) {
                e.preventDefault();

                var network_detail_id = $(this).data("id");
                var confirmDelete = confirm("Are you sure want to delete?");
                if (confirmDelete) {
                    $.ajax({
                        type: "DELETE",
                        url: '/network-details/' + network_detail_id + '/delete-ajax',
                        success: function (data) {
                            $("#network_detail_id_" + network_detail_id).remove();
                            console.log('Success:', data);
                        },
                        error: function (data) {
                            console.log('Error:', data);
                        }
                    });
                }
            });

            // progress
            // $('body').on("select2:select","#network-detail-produce-item-id", function(e) {
            $('#network-detail-tonnage').on('input', function() {
                let el_fulfilled_percentage = $('.percentage.in-modal .fulfilled .percentage-label');
                let el_fulfilled_progress_bar = $('.percentage.in-modal  .fulfilled .progress-bar');
                let network_id = $('#network-detail-network-id').val();
                console.log(network_id);
                if(network_id) {
                    $.ajax({
                        url: '/trader-networks/calculate-fulfilment/' + network_id,
                        dataType: 'json',
                        type: "GET",
                        data: {
                            tonnage: $("#network-detail-tonnage").val()
                        },
                        success: function (data) {
                            el_fulfilled_progress_bar.css('width', data.fulfilled + '%').attr('aria-valuenow', data.fulfilled).data("original-title", data.fulfilled);
                            el_fulfilled_percentage.text(data.fulfilled + '%');
                        },
                        error: function (data) {
                            console.log('Error:', data);
                        }
                    });
                }
            });

            // submit
            if ($("#network-detail-form").length > 0) {
                $("#network-detail-form").validate({
                    submitHandler: function(form) {
                        let formData = $('#network-detail-form').serialize();
                        var actionType = $('#modal-save').val();
                        $('#modal-save').html('Saving...');

                        $.ajax({
                            data: formData,
                            url: '/network-details/store-ajax',
                            type: "POST",
                            dataType: 'json',
                            success: function (data) {
                                let el_fulfilled_percentage = $('.main .percentage-label');
                                let el_fulfilled_progress_bar = $('.percentage.in-main  .fulfilled .progress-bar');
                                el_fulfilled_progress_bar.css('width', data.network.fulfilled + '%').attr('aria-valuenow', data.network.fulfilled).data("original-title", data.network.fulfilled);
                                el_fulfilled_percentage.text(data.network.fulfilled);

                                // var produce = getProduceName(data.produce_item.produce_id);
                                // var produce_unit = getProduceUnitName(data.produce_item.produce_unit_id);
                                // var network_detail = '<tr id="network_detail_id_' + data.id + '"><td><a href="'+ data.url +'">' + data.produce_item.name + '</a><br><span><b>Produce: </b> </span><br><span><b>Units: </b> </span></td>';
                                var network_detail = '<tr id="network_detail_id_' + data.id + '"><td><a href="'+ data.url +'">' + data.produce_item.trader.organisation_name + '</a>';
                                    network_detail += '<br><small><b>Produce:</b> ' + data.produce_item.produce.name;
                                    network_detail += '<br><b>Quality:</b> ' + data.produce_item.quality;
                                    network_detail += '<br><b>Unit:</b> ' + data.produce_item.produce_unit.abbreviation + '</small></td>';
                                    network_detail += '<td>' + data.tonnage + '</td><td>' + data.produce_item.balance + '</td><td class="text-right"><div class="btn-group form-actions" role="group" aria-label="Actions">';
                                    network_detail += '<a id="edit-network-detail" href="'+ data.id +'/edit" class="btn btn-primary btn-sm" data-toggle="tooltip" title="Edit" data-original-title="Edit" data-id="'+ data.id +'"><i class="fa fa-edit"></i> Edit</a>';
                                    network_detail += '<button id="delete-network-detail" type="submit" class="btn btn-danger btn-sm" data-toggle="tooltip" title="Delete" data-original-title="Delete" data-id="'+ data.id +'"><i class="far fa-trash-alt"></i> Delete</button></div></td></tr>';

                                    // $('#add-row').dataTable().fnAddData([
                                    //     $("#addName").val(),
                                    //     $("#addPosition").val(),
                                    //     $("#addOffice").val(),
                                    //     network-detail
                                    // ]);

                                if (actionType == "create-network-detail") {
                                    $('#network-detail-list').prepend(network_detail);
                                } else {
                                    $("#network_detail_id_" + data.id).replaceWith(network_detail);
                                }

                                $('#modal-save').html('Save');
                                $('#crud-modal').modal('hide');
                            },
                            error: function (jqXHR, textStatus, errorThrown) {
                                // console.warn(xhr.responseText)
                                console.log(JSON.stringify(jqXHR));
                                console.log("AJAX error: " + textStatus + ' : ' + errorThrown);
                                $('#modal-save').html('Save');
                            }
                        });
                    }
                });
            }
        });
    </script>
@endsection
