<div class="table-responsive">
    <table id="trader-networks-list" class="display table table-striped table-hover" >
        <thead>
            <tr>
                <th>Agrodealer</th>
                <th class="text-center" style="width: 10%">Action</th>
            </tr>
        </thead>
        <tfoot>
            <tr>
                <th>Agrodealer</th>
                <th class="text-center">Action</th>
            </tr>
        </tfoot>
        <tbody id="trader-network-list">
            @foreach($trader_networks as $network)
                <tr id="trader_network_id_{{ $network->id }}">
                    <td>
                        {{ $network->agrodealer->organisation_name }}
                        <small>
                            <br><b>Type: </b><span class="text-capitalize">{{ $network->type }}</span>
                            @if($network->region)
                                <br><b>Region: </b>{{$network->region->name}}
                            @endif
                            @if($network->county)
                                <br><b>County: </b>{{$network->county->name}}
                            @endif
                        </small>
                    </td>
                    <td>
                        <div class="btn-group form-actions" role="group" aria-label="Actions">
                            <button id="edit-trader-network" type="button" class="btn btn-primary btn-sm" data-toggle="tooltip" title="Edit" data-original-title="Edit" data-id="{{ $network->id }}">
                                <i class="fa fa-edit"></i> Edit
                            </button>
                            <button id="delete-trader-network" type="button" class="btn btn-danger btn-sm" data-toggle="tooltip" title="Delete" data-original-title="Delete" data-id="{{ $network->id }}">
                                <i class="far fa-trash-alt"></i> Delete
                            </button>
                        </div>
                    </td>
                </tr>
            @endforeach
        </tbody>
    </table>
</div>
