<div class="table-responsive">
@if($traders->count())
                        <div class="table-responsive">
                            <table id="traders-list" class="display table table-striped table-hover" >
                                <thead>
                                    <tr>
                                        <th>Name</th>
                                        <th>Type</th>
                                        <th>Email</th>
                                        <th>Phone</th>
                                        <th>Region</th>
                                        <th>County</th>
                                        <th>Contact Person</th>
                                        <th class="text-right">Action</th>
                                    </tr>
                                </thead>
                                <tfoot>
                                    <tr>
                                        <th>Name</th>
                                        <th>Type</th>
                                        <th>Email</th>
                                        <th>Phone</th>
                                        <th>Region</th>
                                        <th>County</th>
                                        <th>Contact Person</th>
                                        <th class="text-right">Action</th>
                                    </tr>
                                </tfoot>
                                <tbody id="trader-list">
                                    @foreach($traders as $trader)
                                        <tr id="trader_id_{{ $trader->id }}">
                                            <td><a href="{{ $trader->url }}">{{ $trader->organisation_name }}</a></td>
                                            <td>{{ $trader->trader_type->name }}</td>
                                            <td>{{ $trader->email }}</td>
                                            <td>{{ $trader->phone }}</td>
                                            <td>{{ isset($trader->region) ? $trader->region->name : '' }}</td>
                                            <td>{{ isset($trader->county) ? $trader->county->name : '' }}</td>
                                            <td>{{ $trader->user->fullname }}</td>
                                            <td class="text-right">
                                                <div class="btn-group form-actions" role="group" aria-label="Actions">
                                                    <a id="edit-trader" href="{{ route('traders.edit', $trader->id) }}" class="btn btn-primary btn-sm" data-toggle="tooltip" title="Edit" data-original-title="Edit" data-id="{{ $trader->id }}">
                                                        <i class="fa fa-edit"></i> Edit
                                                    </a>
                                                    <button id="delete-trader" type="submit" class="btn btn-danger btn-sm" data-toggle="tooltip" title="Delete" data-original-title="Delete" data-id="{{ $trader->id }}">
                                                        <i class="far fa-trash-alt"></i> Delete
                                                    </button>
                                                </div>
                                            </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    @else
                        @include('layouts._nodata')
                    @endif
</div>
