<div class="table-responsive">
    <table id="trader-members-list" class="display table table-striped table-hover" >
        <thead>
            <tr>
                <th>Name</th>
                <th>Username</th>
                <th>Email</th>
                <th>Phone</th>
                <th>Active</th>
                <th class="text-center" style="width: 10%">Action</th>
            </tr>
        </thead>
        <tfoot>
            <tr>
                <th>Name</th>
                <th>Username</th>
                <th>Email</th>
                <th>Phone</th>
                <th>Active</th>
                <th class="text-center">Action</th>
            </tr>
        </tfoot>
        <tbody id="trader-member-list">
            @foreach($trader_members as $member)
                <tr id="trader_member_id_{{ $member->id }}">
                    <td><a href="{{ $member->user->url }}">{{ $member->user->fullname }}</a></td>
                    <td>{{ $member->user->username }}</td>
                    <td>{{ $member->user->email }}</td>
                    <td>{{ $member->user->phone }}</td>
                    <td class="text-center">{!! $member->active ? '<i class="fa fa-check"></i>' : '' !!}</td>
                    <td>
                        <div class="btn-group form-actions" role="group" aria-label="Actions">
                            <button id="edit-trader-member" type="button" class="btn btn-primary btn-sm" data-toggle="tooltip" title="Edit" data-original-title="Edit" data-id="{{ $member->id }}">
                                <i class="fa fa-edit"></i> Edit
                            </button>
                            <button id="delete-trader-member" type="button" class="btn btn-danger btn-sm" data-toggle="tooltip" title="Delete" data-original-title="Delete" data-id="{{ $member->id }}">
                                <i class="far fa-trash-alt"></i> Delete
                            </button>
                        </div>
                    </td>
                </tr>
            @endforeach
        </tbody>
    </table>
</div>
