<div class="table-responsive">
    <table id="trader-contracts-list" class="display table table-striped table-hover" >
        <thead>
            <tr>
                <th>Contract</th>
                <th>Price per Unit</th>
                <th>Tonnage (in Kgs)</th>
                @if(Auth::user()->isAdmin())
                    <th class="text-center" style="width: 10%">Action</th>
                @endif
            </tr>
        </thead>
        <tfoot>
            <tr>
                <th>Contract</th>
                <th>Price per Unit</th>
                <th>Tonnage (in Kgs)</th>
                @if(Auth::user()->isAdmin())
                    <th class="text-center">Action</th>
                @endif
            </tr>
        </tfoot>
        <tbody id="trader-contract-list">
            @foreach($trader_contracts as $contract)
                <tr id="trader_contract_id_{{ $contract->id }}">
                    <td>
                        <a href="{{ $contract->url }}">{{ $contract->name }}</a>
                        <br><small><i class="far fa-file-pdf"></i> Contract Document [<a href="{{ asset('trader-contracts/' . $contract->contract_file) }}" target="_blank">Download</a>]</small>
                        <br><small>Produce: {{ $contract->produce->name }}</small>
                        <br><small>Unit: {{ $contract->produce_unit->name }}</small>
                    </td>
                    <td>{{ number_format($contract->price_per_unit, 2) }}</td>
                    <td>{{ number_format($contract->tonnage) }}</td>
                    @if(Auth::user()->isAdmin())
                        <td>
                            <div class="btn-group form-actions" role="group" aria-label="Actions">
                                <button id="edit-trader-contract" type="button" class="btn btn-primary btn-sm" data-toggle="tooltip" title="Edit" data-original-title="Edit" data-id="{{ $contract->id }}">
                                    <i class="fa fa-edit"></i> Edit
                                </button>
                                <button id="delete-trader-contract" type="button" class="btn btn-danger btn-sm" data-toggle="tooltip" title="Delete" data-original-title="Delete" data-id="{{ $contract->id }}">
                                    <i class="far fa-trash-alt"></i> Delete
                                </button>
                            </div>
                        </td>
                    @endif
                </tr>
            @endforeach
        </tbody>
    </table>
</div>
