<div class="table-responsive">
    <table id="trader-contacts-list" class="display table table-striped table-hover" >
        <thead>
            <tr>
                <th>Name</th>
                <th>Email</th>
                <th>Phone</th>
                <th>Primary</th>
                <th class="text-center" style="width: 10%">Action</th>
            </tr>
        </thead>
        <tfoot>
            <tr>
                <th>Name</th>
                <th>Email</th>
                <th>Phone</th>
                <th>Primary</th>
                <th class="text-center">Action</th>
            </tr>
        </tfoot>
        <tbody id="trader-contact-list">
            @foreach($trader_contacts as $contact)
                <tr id="trader_contact_id_{{ $contact->id }}">
                    <td><a href="{{ $contact->url }}">{{ $contact->fullname }}</a></td>
                    <td>{{ $contact->email }}</td>
                    <td>{{ $contact->phone }}</td>
                    <td class="text-center is-admin">
                        @if($contact->is_admin == 1)
                            <i class="fa fa-check"></i>
                        @endif
                    </td>
                    <td>
                        <div class="btn-group form-actions" role="group" aria-label="Actions">
                            <a id="edit-trader-contact" href="{{ route('trader-contacts.edit', $contact->id) }}" class="btn btn-primary btn-sm" data-toggle="tooltip" title="Edit" data-original-title="Edit" data-id="{{ $contact->id }}">
                                <i class="fa fa-edit"></i> Edit
                            </a>
                            <button id="delete-trader-contact" type="submit" class="btn btn-danger btn-sm" data-toggle="tooltip" title="Delete" data-original-title="Delete" data-id="{{ $contact->id }}">
                                <i class="far fa-trash-alt"></i> Delete
                            </button>
                        </div>
                    </td>
                </tr>
            @endforeach
        </tbody>
    </table>
</div>
