@extends('layouts.site')

@section('title')
BTCotton | Farmers
@endsection

@section('header')
    <div class="page-header">
        <h4 class="page-title">@if($selectedtrader->count()) {{ $selectedtrader[0] }} @else {{ 'All' }} @endif Farmers</h4>
        {{-- <h5 class="text-white op-7 mb-2">Lorem ipsum dolor sit amet, consectetur adipiscing elit</h5> --}}
        <ul class="breadcrumbs">
            <li class="nav-home">
                <a href="#">
                    <i class="flaticon-home"></i>
                </a>
            </li>
            <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="#">Farmers</a>
            </li>
            {{-- <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="#">Buttons</a>
            </li> --}}
        </ul>
    </div>
    <div class="ml-md-auto py-2 py-md-0">
        <a href="{{ URL::previous() }}" class="btn btn-white btn-round btn-sm ml-1">
            <i class="fas fa-caret-left"></i> Back
        </a>
    </div>
@endsection

@section('content')
    <div class="row row-card-no-pd mt--2">
        <div class="col-md-12">
            <div class="card">
            <div id="vueapp">
                <div class="card-body">
                    @include ('layouts._messages')

                  
                        <!-- end advisories -->
                     
                        
                        <!-- content -->
                        <!-- filter -->
                
                        <!-- group messages -->
                  
                        <!-- end send advisories -->
                        <div class="table-responsive">
                      <table id="farmer-users-list" class="display table table-striped table-hover" >
                                <thead>
                                    <tr>
                                    <th>Farmer </th>
                                        <th>Organization</th>
                                        <th>Coach</th>
                                        <th>Message</th>
                                        <th class="text-center" style="width: 10%">Action</th>
                                    </tr>
                                </thead>
                                <tfoot>
                                    <tr>
                                        <th>Farmer </th>
                                        <th>Organization</th>
                                        <th>Coach</th>
                                          <th>Message</th>
                                        <th class="text-center">Action</th>
                                            </tr>
                                        </tfoot>
                                        <tbody>
                                            @foreach($expert_messages as $expert_message)
                                                <tr>
                                            <td>
                                                <a href="#">{{ $expert_message->farmer_id }}</a>
                                            </td>
                                            <td>                                           
                                            @if($expert_message->TextQuestionOrganization) 
                        {{  $expert_message->TextQuestionOrganization->organisation_name }}
                        @endif
                                            
                                            </td>
                                            <td>   @if($expert_message->TextQuestionCoach) 
                        {{  $expert_message->TextQuestionCoach->lastname }}
                        @endif </td>
                                            <td>{{ $expert_message->message }}</td>
                                            <td>
                                            <div class="form-button-action" role="group" aria-label="Actions">
                                                    <div class="btn-group btn-group-sm"><a href="#" class="btn btn-sm btn-success" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">Actions</a>
                                                        <button type="button" class="btn btn-success btn-sm dropdown-toggle dropdown-toggle-split" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                                            <span class="sr-only">Toggle Dropdown</span>
                                                        </button>
                                                        <ul class="dropdown-menu dropdown-menu-left">
                                                       
                                                 

                                       
                                                    <a class="dropdown-item" href="{{ route('audioquestion.confirm', $expert_message->id) }}"  data-target="#smstext-{{ $expert_message->id }}"><i class="fa fa-plus"></i>Confirm</a>
                          
                                                    <a class="dropdown-item" href="#" data-toggle="modal" data-target="#smstext-{{$expert_message->id}}"><i class="fa fa-plus"></i> Send Text Message</a>
                                                    

                                                    <a class="dropdown-item" href="#" data-toggle="modal" data-target="#pestsuvelance-{{$expert_message->id}}"><i class="fa fa-plus"></i> Pest suvelance</a>

                                                    <a class="dropdown-item" href="{{ route('audioquestion.delete', $expert_message->id) }}"  data-target="#smstext-{{ $expert_message->id }}"><i class="fa fa-plus"></i>Delete</a>
                                                  
                                                    </div>
                                                </div>
                                            </td>




      <!-- Modal -->
      <div class="modal fade" id="pestsuvelance-{{$expert_message->id}}" tabindex="-1" role="dialog" aria-hidden="true">
                                            <div class="modal-dialog" role="document">
                                                <div class="modal-content">
                                                    <div class="modal-header">
                                                        <h5 class="modal-title">
                                                            Add Pest Suvelance -{{$expert_message->id}}
                                                        </h5>
                                                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                            <span aria-hidden="true">&times;</span>
                                                        </button>
                                                    </div>
                                                        <div class="modal-body">
                                                            
                                                        <pestsuvelance-component :textquestion="{{ json_encode($expert_message)}}"><pestsuvelance-component/>
                                                            
                                                        </div>
                                                </div>
                                            </div>
                                        </div>


                                                        <!-- Modal -->
                                        <div class="modal fade" id="smstext-{{$expert_message->id}}" tabindex="-1" role="dialog" aria-hidden="true">
                                            <div class="modal-dialog" role="document">
                                                <div class="modal-content">
                                                    <div class="modal-header">
                                                        <h5 class="modal-title">
                                                            Send Text Message To Farmers -{{$expert_message->id}}
                                                        </h5>
                                                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                            <span aria-hidden="true">&times;</span>
                                                        </button>
                                                    </div>
                                                        <div class="modal-body">
                                                            
                                                        <addtextquestionsms-component :textquestion="{{ json_encode($expert_message)}}"><addtextquestionsms-component/>
                                                            
                                                        </div>
                                                </div>
                                            </div>
                                        </div>
                                        
                                        
                                                                   <!-- Modal -->
                                        <div class="modal fade" id="smstextallfarmers-{{$expert_message->id}}" tabindex="-1" role="dialog" aria-hidden="true">
                                            <div class="modal-dialog" role="document">
                                                <div class="modal-content">
                                                    <div class="modal-header">
                                                        <h5 class="modal-title">
                                                            Send Text Message To All Farmers -{{$expert_message->id}}
                                                        </h5>
                                                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                            <span aria-hidden="true">&times;</span>
                                                        </button>
                                                    </div>
                                                        <div class="modal-body">
                                                            
                                                        <all-farmers-addtextquestionsms-component :textquestion="{{ json_encode($expert_message)}}"><all-farmers-addtextquestionsms-component/>
                                                            
                                                        </div>
                                                </div>
                                            </div>
                                        </div>
                                        
                                        
                                                                                                           <!-- Modal -->
                                        <div class="modal fade" id="smstextallfarmersandusers-{{$expert_message->id}}" tabindex="-1" role="dialog" aria-hidden="true">
                                            <div class="modal-dialog" role="document">
                                                <div class="modal-content">
                                                    <div class="modal-header">
                                                        <h5 class="modal-title">
                                                            Send Text Message To Farmers and Users -{{$expert_message->id}}
                                                        </h5>
                                                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                            <span aria-hidden="true">&times;</span>
                                                        </button>
                                                    </div>
                                                        <div class="modal-body">
                                                            
                                                        <all-farmers-andusers-addtextquestionsms-component :textquestion="{{ json_encode($expert_message)}}"><all-farmers-andusers-addtextquestionsms-component/>
                                                            
                                                        </div>
                                                </div>
                                            </div>
                                        </div>
                                        
                                        
                                        

                                            <!-- Modal -->
                                            <div class="modal fade" id="ivr-{{$expert_message->id}}" tabindex="-1" role="dialog" aria-hidden="true">
                                                <div class="modal-dialog" role="document">
                                                    <div class="modal-content">
                                                        <div class="modal-header">
                                                            <h5 class="modal-title">
                                                                Send Voice Message -{{$expert_message->id}}
                                                            </h5>
                                                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                                <span aria-hidden="true">&times;</span>
                                                            </button>
                                                        </div>
                                                            <div class="modal-body">
                                                                
                                                            <addivr-component :farmer="{{ json_encode($expert_message->user)}}"><addivr-component/>
                                                                
                                                            </div>
                                                    </div>
                                                </div>
                                            </div>

                             <!--sms modal-->

                            
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>


                            </div>  
              
                                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('scripts')
    <script>
        $(document).ready(function () {
            $('#farmer-users-list').DataTable({
                "order": [[ 0, "desc" ]]
            });
        });
        /*display the farmerproducemodal with the farmerid*/
        $(document).on('click','#addproducelink',function(){
                var farmerid = $(this).data('farmer-id');
                var farmerorganisation = $(this).data('org-id');
                var fid=$("#farmerid").val(farmerid);
                var org=$("#organisationid").val(farmerorganisation);


        });

         /*display the walletmodal with the farmerid*/
         $(document).on('click','#addwalletlink',function(){
                var farmerid = $(this).data('farmer-id');
                var farmerorganisation = $(this).data('org-id');
                var fid=$("#userid").val(farmerid);
                var org=$("#orgid").val(farmerorganisation);


        });

    </script>
@endsection
