@extends('layouts.shop')

@section('title')
BTCotton | Browse Items
@endsection

@section('content')
    <div class="card">
        <div class="card-body">
            <div class="row">
                <div class="col-md-3-24"> <strong>Your are here:</strong> </div> <!-- col.// -->
                <nav class="col-md-18-24">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="#">Home</a></li>
                    <li class="breadcrumb-item"><a href="#">Category name</a></li>
                    <li class="breadcrumb-item"><a href="#">Sub category</a></li>
                    <li class="breadcrumb-item active" aria-current="page">Items</li>
                </ol>
                </nav> <!-- col.// -->
                <div class="col-md-3-24 text-right">
                <a href="#" data-toggle="tooltip" title="List view"> <i class="fa fa-bars"></i></a>
                <a href="#" data-toggle="tooltip" title="Grid view"> <i class="fa fa-th"></i></a>
                </div> <!-- col.// -->
            </div> <!-- row.// -->
            <hr>
            <div class="row">
                <div class="col-md-3-24"> <strong>Filter by:</strong> </div> <!-- col.// -->
                <div class="col-md-21-24">
                    <ul class="list-inline">
                        <li class="list-inline-item dropdown"><a href="#" class="dropdown-toggle" data-toggle="dropdown">   Supplier type </a>
                            <div class="dropdown-menu p-3" style="max-width:400px;"">
                            <label class="form-check">
                                <a href="#">
                                <input type="checkbox" class="form-check-input">Products
                                </a>
                            </label>
                            <label class="form-check">
                                <a href="#">
                                <input type="checkbox" class="form-check-input">Services
                                </a>
                            </label>
                            <label class="form-check">
                                <a href="#">
                                <input type="checkbox" class="form-check-input">Trade
                                </a>
                            </label>
                            </div> <!-- dropdown-menu.// -->
                        </li>
                        <li class="list-inline-item dropdown"><a href="#" class="dropdown-toggle" data-toggle="dropdown">Region</a>
                            <div class="dropdown-menu p-3" style="max-width:400px;"">
                            <label class="form-check">
                                <a href="#">
                                <input type="checkbox" class="form-check-input">Nairobi
                                </a>
                            </label>
                            <label class="form-check">
                                <a href="#">
                                <input type="checkbox" class="form-check-input">Mombasa
                                </a>
                            </label>
                            <label class="form-check">
                                <a href="#">
                                <input type="checkbox" class="form-check-input">Kisumu
                                </a>
                            </label>
                            <label class="form-check">
                                <a href="#">
                                <input type="checkbox" class="form-check-input">Nakuru
                                </a>
                            </label>
                            </div> <!-- dropdown-menu.// -->
                        </li>
                        <li class="list-inline-item"><a href="#">Product type</a></li>
                        <li class="list-inline-item"><a href="#">Units</a></li>
                        {{-- <li class="list-inline-item"><a href="#">Size</a></li> --}}
                        <li class="list-inline-item">
                            <div class="form-inline">
                                <label class="mr-2">Price</label>
                                <input class="form-control form-control-sm" placeholder="Min" type="number">
                                    <span class="px-2"> - </span>
                                <input class="form-control form-control-sm" placeholder="Max" type="number">
                                <button type="submit" class="btn btn-sm ml-2">Ok</button>
                            </div>
                        </li>
                    </ul>
                </div> <!-- col.// -->
            </div> <!-- row.// -->
        </div> <!-- card-body .// -->
    </div> <!-- card.// -->

    {{-- <div class="padding-y-sm">
        <span>3897 results for "Item"</span>
    </div> --}}

    <style>
        .img-wrap img {
            object-fit: cover !important;
            width: 100% !important;
            height: 100% !important;
        }
        .price-wrap .price-new {
            display: block;
            font-size: 1.5rem;
            /* text-align: right; */
            margin: 0;
        }
        .price-wrap .price-old {
            display: block;
            /* text-align: right; */
        }
    </style>

    <div id="item-list" class="row-sm">
        <div class="col-md-12">
            <a id="show-product-list" href="{{ url('/') }}" class="btn btn-primary btn-sm mb-3 mt-3"><i class="fas fa-long-arrow-alt-left"></i> Back to Products List</a>
            <figure class="card card-product">
                <div class="img-wrap">
                    <a href="#">
                        <img src="{{ asset('images/items/_ball-peppers.jpg') }}">
                    </a>
                </div>
                <figcaption class="info-wrap">
                    <h5><a href="#" class="title">Ball Peppers</a></h5>
                    <hr>
                    <div class="price-wrap">
                        <span>Average Price</span>
                        <span class="price-new">KSh200 /Kg <i class="fas fa-angle-down" style="color: green;"></i></span>
                        <del class="price-old">KSh230</del>
                        {{-- <span class="unit"><b>Units:</b> Kg</span> --}}
                    </div> <!-- price-wrap.// -->
                    {{-- <div class="seller-wrap">
                        <span><b>Seller:</b> <a href="#">Jane M.</a></span>
                    </div> --}}
                </figcaption>

                <div class="card-body">
                    <div class="table-responsive">
                        <table id="items-list" class="display table table-striped table-hover" >
                            <thead>
                                <tr>
                                    <th>Product</th>
                                    <th>Price (KSh)</th>
                                    <th>Unit</th>
                                    <th>Quantity in Stock</th>
                                    <th>Region</th>
                                    {{-- <th class="text-right" style="width: 10%">Action</th> --}}
                                </tr>
                            </thead>
                            <tfoot>
                                <tr>
                                    <th>Product</th>
                                    <th>Price (KSh)</th>
                                    <th>Unit</th>
                                    <th>Quantity in Stock</th>
                                    <th>Region</th>
                                    {{-- <th class="text-right">Action</th> --}}
                                </tr>
                            </tfoot>
                            <tbody>
                                <tr>
                                    <td><a href="{{ url('shop/single') }}">Ball Peppers</a></td>
                                    <td>180</td>
                                    <td>Kg</td>
                                    <td>1,000</td>
                                    <td>Nairobi, Machakos</td>
                                </tr>
                                <tr>
                                    <td><a href="#">Ball Peppers</a></td>
                                    <td>185</td>
                                    <td>Kg</td>
                                    <td>5,000</td>
                                    <td>Mombasa, Kwale</td>
                                </tr>
                                <tr>
                                    <td><a href="#">Ball Peppers</a></td>
                                    <td>175</td>
                                    <td>Kg</td>
                                    <td>2,500</td>
                                    <td>Nyandarua, Nyeri, Embu</td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
            </figure>
        </div>
    </div>
@endsection

@section('scripts')
    {{-- <script>
        $(document).ready(function() {
            $("#show-item-list").click(function(e){
                e.preventDefault();
                $('product-list').hide();
                $('item-list').show("slow");
            });
            $("#show-product-list").click(function(e){
                e.preventDefault();
                $('item-list').hide();
                $('product-list').show("slow");
            });
        });
    </script> --}}
@endsection
