@extends('layouts.site')

@section('title')
BTCotton | {{ request()->filled('type') ? ucfirst(request()->type) . 's' : 'Traders' }}
@endsection

@section('header')
    <div class="page-header">
        <h4 class="page-title">Shop</h4>
        {{-- <h5 class="text-white op-7 mb-2">Lorem ipsum dolor sit amet, consectetur adipiscing elit</h5> --}}
        <ul class="breadcrumbs">
            <li class="nav-home">
                <a href="#">
                    <i class="flaticon-home"></i>
                </a>
            </li>
            <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="#">Shop</a>
            </li>
            {{-- <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="#">Buttons</a>
            </li> --}}
        </ul>
    </div>
    <div class="ml-md-auto py-2 py-md-0">
        <a href="{{ URL::previous() }}" class="btn btn-white btn-round btn-sm ml-1">
            <i class="fas fa-caret-left"></i> Back
        </a>
    </div>
@endsection

@section('content')
    <div class="row">
        <div class="col-md-4">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">Filters</h3>
                </div>
                <div class="card-body">

                </div>
            </div>
        </div>
        <div class="col-md-8">
            <div class="card">
                <div class="card-header">
                    <h4 class="card-title">Farm Inputs</h4>
                </div>
                <div class="card-body">
                    @if($items->count())
                        <div class="table-responsive">
                            <table id="items-list" class="display table table-striped table-hover" >
                                <thead>
                                    <tr>
                                        <th>Item</th>
                                        <th class="text-right" style="width: 10%">Action</th>
                                    </tr>
                                </thead>
                                <tfoot>
                                    <tr>
                                        <th>Item</th>
                                        <th class="text-right">Action</th>
                                    </tr>
                                </tfoot>
                                <tbody>
                                    @foreach($items as $item)
                                    <tr>
                                        <td>
                                            <figure class="media">
                                                <div class="img-wrap"><img src="{{ asset('images/items/_ball-peppers.jpg') }}" class="img-thumbnail img-sm" width="50"></div>
                                                <figcaption class="media-body ml-3">
                                                    <h4 class="title text-truncate mb-0"><a href="{{ $item->url }}">{{ $item->name }}</a></h4>
                                                    <dl class="dlist-inline small">
                                                        <dt>Variety: {{ $item->category->name }}</dt>
                                                    </dl>
                                                </figcaption>
                                            </figure>
                                        </td>
                                        <td class="text-right">
                                            <div class="form-button-action">
                                                <form class="d-inline" method="post" action="">
                                                    @method('PUT')
                                                    @csrf
                                                    <input name="category" type="hidden" value="{{ $item->category_id }}">
                                                    <button id="addToCart" type="submit" class="btn btn-primary btn-sm ml-1" data-id="{{ $item->id }}" onclick="return confirm('Add item to cart?')">
                                                        <i class="fa fa-plus"></i> Order Item
                                                    </button>
                                                </form>
                                            </div>
                                        </td>
                                    </tr>
                                    @endforeach
                                </tbody>
                            </table>

                            {{-- {{ $items->links() }} --}}
                        </div>
                    @else
                        @include('layouts._nodata')
                    @endif
                </div>
            </div>
        </div>
    </div>
@endsection

@section('scripts')
    <script>
        $(document).ready(function () {
            $('#items-list').DataTable({
                "order": [[ 0, "desc" ]]
            });
        });
    </script>
@endsection
