@extends('layouts.shop')

@section('title')
BTCotton | Shopping Cart
@endsection

@section('content')
    <!-- ========================= SECTION CONTENT ========================= -->
<section class="section-content bg padding-y border-top">
    <div class="container">
        <div class="row">
            <main class="col-sm-9">
                <div class="card">
                    <table class="table table-hover shopping-cart-wrap">
                        <thead class="text-muted">
                            <tr>
                                <th scope="col">Product</th>
                                <th scope="col" width="120">Quantity</th>
                                <th scope="col" width="120">Price</th>
                                <th scope="col" class="text-right" width="200">Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr>
                                <td>
                                    <figure class="media">
                                        <div class="img-wrap"><img src="{{ asset('images/items/_ball-peppers.jpg') }}" class="img-thumbnail img-sm"></div>
                                        <figcaption class="media-body">
                                            <h6 class="title text-truncate">Ball Peppers</h6>
                                            <dl class="dlist-inline small">
                                                <dt>Unit:</dt>
                                                <dd>per Kg</dd>
                                            </dl>
                                            {{-- <dl class="dlist-inline small">
                                                <dt>Color: </dt>
                                                <dd>Orange color</dd>
                                            </dl> --}}
                                        </figcaption>
                                    </figure>
                                </td>
                                <td>
                                    <select class="form-control">
                                        <option>100</option>
                                        <option>150</option>
                                        <option>200</option>
                                        <option>250</option>
                                        <option>300</option>
                                        <option>350</option>
                                        <option>400</option>
                                        <option>450</option>
                                        <option>500</option>
                                        <option selected>550</option>
                                        <option>600</option>
                                        <option>650</option>
                                        <option>700</option>
                                        <option>750</option>
                                        <option>800</option>
                                        <option>850</option>
                                        <option>900</option>
                                        <option>950</option>
                                        <option>1000</option>
                                    </select>
                                </td>
                                <td>
                                    <div class="price-wrap">
                                        <var class="price">KSh180</var>
                                        {{-- <small class="text-muted">(USD5 each)</small> --}}
                                    </div> <!-- price-wrap .// -->
                                </td>
                                <td class="text-right">
                                    <a data-original-title="Save to Wishlist" title="" href="" class="btn btn-outline-success" data-toggle="tooltip"> <i class="fa fa-heart"></i></a>
                                    <a href="" class="btn btn-outline-danger"><i class="fas fa-times"></i> Remove</a>
                                </td>
                            </tr>
                        </tbody>
                    </table>
                </div> <!-- card.// -->
                <div class="text-right mt-4">
                    <a href="#" class="btn btn-primary btn-lg">Checkout</a>
                    <a href="{{ url('/') }}" class="btn btn-outline-primary btn-lg">Continue Shopping</a>
                </div>
            </main> <!-- col.// -->
            <aside class="col-sm-3">
                <p class="alert alert-success">Add KSh5,000.00 of eligible items to your order to qualify for FREE Shipping. </p>
                <dl class="dlist-align">
                    <dt>Total price: </dt>
                    <dd class="text-right">KSh99,000</dd>
                </dl>
                <dl class="dlist-align">
                    <dt>Discount:</dt>
                    <dd class="text-right">-</dd>
                </dl>
                <dl class="dlist-align h4">
                    <dt>Total:</dt>
                    <dd class="text-right"><strong>KSh99,000</strong></dd>
                </dl>
                <hr>
                <figure class="itemside mb-3">
                    <aside class="aside"><img src="{{ asset('images/icons/pay-visa.png') }}"></aside>
                    <div class="text-wrap small text-muted">
                        Pay 84.78 KSh ( Save 14.97 KSh )
                        By using a Visa Card
                    </div>
                </figure>
                <figure class="itemside mb-3">
                    <aside class="aside"> <img src="{{ asset('images/icons/pay-mastercard.png') }}"> </aside>
                    <div class="text-wrap small text-muted">
                        Pay by MasterCard and Save 40%. <br>
                        Lorem ipsum dolor
                    </div>
                </figure>
            </aside> <!-- col.// -->
        </div>

    </div> <!-- container .//  -->
</section>
<!-- ========================= SECTION CONTENT END// ========================= -->
@endsection

@section('scripts')

@endsection
