@extends('layouts.site')

@section('title')
BTCotton | Invoices to pay
@endsection

@section('header')
    <div class="page-header">
        <h4 class="page-title">Invoices Payments for Ref# {{ $invoice->id}}</h4>
        {{-- <h5 class="op-7 mb-2">Lorem ipsum dolor sit amet, consectetur adipiscing elit</h5> --}}
        <ul class="breadcrumbs">
            <li class="nav-home">
                <a href="#" class="btn btn-icon btn-sm btn-round btn-light">
                    <i class="flaticon-home"></i>
                </a>
            </li>
            <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
                                        <th class="text-right" style="width: 10%">Action</th>
                                    </tr>
                                </thead>
                                <tfoot>
                                    <tr>
            <li class="nav-item">
                <a href="#">Invoices</a>
            </li>
            {{-- <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="#">Buttons</a>
            </li> --}}
        </ul>

    </div>
    <div class="ml-md-auto py-2 py-md-0">

        <a href="{{ URL::previous() }}" class="btn btn-white btn-round btn-sm ml-1">
            <i class="fas fa-caret-left"></i> Back
        </a>
    </div>
@endsection

@section('content')
    <div class="row row-card-no-pd mt--2">
        <div class="col-md-12">
            <div class="card">
                <div class="card-body">
                    @include ('layouts._messages')

                      @if($invoices)
                        <div class="table-responsive">
                            <table id="inputs-list" class="display table table-striped table-hover" >

                            <thead>
                                    <tr>
                                        <th>S/No.</th>
                                        <th>Mode.</th>
                                        <th>Amount</th>
                                        <th>Date </th>
                                        </tr>
                                </thead>
                                <tbody id="input-list">
                                @foreach($invoices as $invoicePay)
                                        <tr>
                                            <td><a href="#">{{ $invoicePay->id }}</a></td>
                                            <td>{{ $invoicePay->mode }}</td>
                                            <td>{{ Str::limit($invoicePay->amount,-2,'.') }}</td>
                                            <td>{{ Str::limit($invoicePay->created_at,10,'.') }}</td>

                                    </tr>
                                    @endforeach
                                </tbody>
                                <tfoot>
                                    <tr>
                                    <th>S/No.</th>
                                        <th>Mode.</th>
                                        <th>Amount</th>
                                        <th>Date </th>
                                    </tr>
                                </tfoot>
                            </table>
                        </div>
                        @else
                        @include('layouts._nodata')
                    @endif
                </div>
            </div>


        </div>
    </div>

@endsection
@section('scripts')
<script>
$(document).ready(function () {
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });

            $('#inputs-list').DataTable({
                "order": [[ 0, "desc" ]]
            });
        });
</script>
@endsection
