@extends('layouts.site')

@section('title')
BTCotton | Deliveries
@endsection

@section('header')
    <div class="page-header">
        <h4 class="page-title">Input Seller | Deliveries</h4>
        {{-- <h5 class="op-7 mb-2">Lorem ipsum dolor sit amet, consectetur adipiscing elit</h5> --}}
        <ul class="breadcrumbs">
            <li class="nav-home">
                <a href="#" class="btn btn-icon btn-sm btn-round btn-light">
                    <i class="flaticon-home"></i>
                </a>
            </li>
            <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
                                        <th class="text-right" style="width: 10%">Action</th>
                                    </tr>
                                </thead>
                                <tfoot>
                                    <tr>
            <li class="nav-item">
                <a href="#">Invoices</a>
            </li>
            {{-- <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="#">Buttons</a>
            </li> --}}
        </ul>

    </div>
    <div class="ml-md-auto py-2 py-md-0">
        <a href="{{ URL::previous() }}" class="btn btn-white btn-round btn-sm ml-1">
            <i class="fas fa-caret-left"></i> Back
        </a>
    </div>
@endsection

@section('content')
    <div class="row row-card-no-pd mt--2">
        <div class="col-md-12">
            <div class="card">
                <div class="card-body">
                    @include ('layouts._messages')

                    @if($deliveries->count())
                        <div class="table-responsive">
                            <table id="inputs-list" class="display table table-striped table-hover" >

                                <thead>
                                    <tr>
                                        <th>S/No.</th>
                                        <th>Invoice No.</th>
                                        <th>Amount</th>
                                        <th>Posted By</th>
                                        <th>Direction</th>
                                        <th>Status</th>
                                        <th>Date Created</th>
                                        <th class="text-right" style="width: 10%">Action</th>
                                    </tr>
                                </thead>
                                <tbody id="input-list">
                                    @foreach($deliveries as $delivery)
                                        <tr id="{{$delivery->id}}">
                                            <td><a href="#">{{ $delivery->id }}</a></td>
                                            <td>{{ $delivery->number }}</td>
                                            <td>{{ $delivery->total }}</td>
                                            <td>{{ $delivery->posted_by }}</td>
                                            <td>{{ $delivery->direction }}</td>
                                            <td>
                                                @if($delivery->status == 0)
                                                    <span class="badge badge-warning">Pending</l>
                                                @elseif($delivery->status == 1)
                                                    <span class="badge badge-success">Paid</l>
                                                @endif
                                            </td>
                                            <td>{{ $delivery->created_at }}</td>
                                            <td class="text-right">
                                               <div class="btn-group form-actions" role="group" aria-label="Actions">
                                                   <a href="{{ route('seller-invoices.show', $delivery->id)}}">
                                                    <button type="submit" class="btn btn-success btn-sm" data-toggle="tooltip" title="View" data-original-title="View">
                                                        <i class="fa fa-edit"></i> View
                                                    </button>
                                                    </a>
                                                    <form action="{{ route('seller-invoices.destroy', $delivery->id)}}" method="post">
                                                    @csrf
                                                    @METHOD('DELETE')
                                                    <button type="submit" class="btn btn-danger btn-sm" data-toggle="tooltip" title="Delete" data-original-title="Delete">
                                                        <i class="fa fa-trash-alt"></i> Delete
                                                    </button>
                                                    </form>
                                                    </div>

                                    </tr>

                                    @endforeach
                                </tbody>
                                <tfoot>
                                    <tr>
                                        <th>ID</th>
                                        <th>Farmer Organization</th>
                                        <th>Totals</th>
                                        <th>Status</th>
                                        <th>Date Created</th>
                                        <th class="text-right" style="width: 10%">Action</th>
                                    </tr>
                                </tfoot>
                            </table>
                        </div>
                    @else
                        @include('layouts._nodata')
                    @endif
                </div>
            </div>


        </div>
    </div>


@endsection
