@extends('layouts.site')

@section('title')
BTCotton | Regions - {{ $region->name }}
@endsection

@section('header')
    <div class="page-header">
        <h4 class="page-title">Region - {{ $region->name }}</h4>
        {{-- <h5 class="text-white op-7 mb-2">Lorem ipsum dolor sit amet, consectetur adipiscing elit</h5> --}}
        <ul class="breadcrumbs">
            <li class="nav-home">
                <a href="#">
                    <i class="flaticon-home"></i>
                </a>
            </li>
            <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="#">Regions</a>
            </li>
            {{-- <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="#">Buttons</a>
            </li> --}}
        </ul>
    </div>
    <div class="ml-md-auto py-2 py-md-0">
        {{-- <a href="{{ route('regions.create') }}" class="btn btn-primary btn-round" data-toggle="modal" data-target="#addRowModal"> --}}
        <a href="{{ route('regions.edit', $region->id) }}" class="btn btn-primary btn-round">
            <i class="fa fa-edit"></i> Edit Region
        </a>
        <a href="{{ URL::previous() }}" class="btn btn-white btn-round btn-sm ml-1">
            <i class="fas fa-caret-left"></i> Back
        </a>
    </div>
@endsection

@section('content')
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-body">
                    @include ('layouts._messages')

                    <p><b>Region ID:</b> {{ $region->id }}</p>
                    <p><b>Name:</b> {{ $region->name }}</p>
                    <p><b>Description:</b> <br>{{ $region->description }}</p>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('scripts')

@endsection
