@extends('layouts.site')

@section('title')
BTCotton | Edit Produce Variety
@endsection

@section('header')
    <div class="page-header">
    <h4 class="page-title">Edit Produce Variety</h4>
        {{-- <h5 class="text-white op-7 mb-2">Lorem ipsum dolor sit amet, consectetur adipiscing elit</h5> --}}
        <ul class="breadcrumbs">
            <li class="nav-home">
                <a href="#">
                    <i class="flaticon-home"></i>
                </a>
            </li>
            <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="#">Produce Variety</a>
            </li>
            {{-- <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="#">Buttons</a>
            </li> --}}
        </ul>
    </div>
    <div class="ml-md-auto py-2 py-md-0">
        <a href="{{ URL::previous() }}" class="btn btn-white btn-round btn-sm ml-1">
            <i class="fas fa-caret-left"></i> Back
        </a>
    </div>
@endsection

@section('content')
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-body">
                    @include ('layouts._messages')

                    <h5 class="text-right"><strong>produce ID:</strong> {{ $produce->id }}</h5>
                    <form action="{{ route('produces.update', $produce->id) }}" method="post">
                        @method('PUT')
                        <input name="category_id" type="hidden" value="{{$produce->category_id}}"/>
                        @include ("produces._form", ['buttonText' => "Update produce"])
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('scripts')

@endsection
